/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class EmergeEffect
extends Effect {
    private static final float DEFAULT_SPEED = 0.125f;
    private float speed = 4.0f;
    private boolean elastic = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public EmergeEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.speed = 1.0f / this.paramAsFloat(params[0], 0.25f);
        }
        if (params.length > 1) {
            this.elastic = this.paramAsBoolean(params[1]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realIntensity = this.speed * (this.elastic ? 3.0f : 1.0f) * 0.125f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realIntensity), (float)0.0f, (float)1.0f);
        Interpolation.SwingOut interpolation = this.elastic ? Interpolation.swingOut : Interpolation.sine;
        float interpolatedValue = interpolation.apply(progress) - 1.0f;
        this.label.getSizing().incr(globalIndex << 1 | 1, interpolatedValue);
        this.label.getOffsets().incr(globalIndex << 1 | 1, interpolatedValue * 0.5f * this.label.getLineHeight(globalIndex));
    }
}

