/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.NoiseUtils;

public class WindEffect
extends Effect {
    private static final float DEFAULT_SPACING = 10.0f;
    private static final float DEFAULT_DISTANCE = 0.33f;
    private static final float DEFAULT_INTENSITY = 0.375f;
    private static final float DISTANCE_X_RATIO = 1.5f;
    private static final float DISTANCE_Y_RATIO = 1.0f;
    private static final float IDEAL_DELTA = 60.0f;
    private float noiseCursorX = 0.0f;
    private float noiseCursorY = 0.0f;
    private float distanceX = 1.0f;
    private float distanceY = 1.0f;
    private float spacing = 1.0f;
    private float intensity = 1.0f;

    public WindEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distanceX = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.distanceY = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.spacing = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.intensity = this.paramAsFloat(params[3], 1.0f);
        }
        if (params.length > 4) {
            this.duration = this.paramAsFloat(params[4], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        float changeAmount = 0.15f * this.intensity * 0.375f * delta * 60.0f;
        this.noiseCursorX += changeAmount;
        this.noiseCursorY += changeAmount;
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float progressModifier = 0.375f / this.intensity;
        float normalSpacing = 10.0f / this.spacing;
        float progressOffset = (float)localIndex / normalSpacing;
        float progress = this.calculateProgress(progressModifier, progressOffset);
        float indexOffset = (float)localIndex * 0.05f * this.spacing;
        float noiseX = NoiseUtils.octaveNoise1D(this.noiseCursorX + indexOffset, 123);
        float noiseY = NoiseUtils.octaveNoise1D(this.noiseCursorY + indexOffset, -4321);
        float lineHeight = this.label.getLineHeight(globalIndex);
        float x = lineHeight * noiseX * progress * this.distanceX * 1.5f * 0.33f;
        float y = lineHeight * noiseY * progress * this.distanceY * 1.0f * 0.33f;
        float fadeout = this.calculateFadeout();
        x *= fadeout;
        x = Math.abs(x) * -Math.signum(this.distanceX);
        this.label.getOffsets().incr(globalIndex << 1, x);
        this.label.getOffsets().incr(globalIndex << 1 | 1, y *= fadeout);
    }
}

