/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.LongArray;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Justify;
import com.github.tommyettinger.textra.Line;

public class Layout {
    protected Font font;
    protected final Array<Line> lines = new Array(true, 8);
    protected int maxLines = Integer.MAX_VALUE;
    protected boolean atLimit = false;
    protected String ellipsis = null;
    protected float targetWidth = 0.0f;
    protected float baseColor = Color.WHITE_FLOAT_BITS;
    protected Justify justification = Justify.NONE;
    public final FloatArray offsets = new FloatArray();
    public final FloatArray sizing = new FloatArray();
    public final FloatArray rotations = new FloatArray();
    public final FloatArray advances = new FloatArray();

    public Layout() {
        this.lines.add((Object)new Line());
    }

    public Layout(Font font) {
        this.font = font;
        this.lines.add((Object)new Line());
    }

    public Layout(Layout other) {
        this.font = other.font;
        this.maxLines = other.maxLines;
        this.atLimit = other.atLimit;
        this.ellipsis = other.ellipsis;
        this.targetWidth = other.targetWidth;
        this.baseColor = other.baseColor;
        for (int i = 0; i < other.lines(); ++i) {
            Line ln = new Line();
            Line o = (Line)other.lines.get(i);
            ln.glyphs.addAll(o.glyphs);
            this.lines.add((Object)ln.size(o.width, o.height));
        }
        this.rotations.addAll(other.rotations);
        this.offsets.addAll(other.offsets);
        this.sizing.addAll(other.sizing);
        this.advances.addAll(other.advances);
        this.justification = other.justification;
    }

    public Layout font(Font font) {
        if (this.font == null || !this.font.equals(font)) {
            this.font = font;
            this.lines.clear();
            this.lines.add((Object)new Line());
        }
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font(font);
    }

    public Layout add(long glyph) {
        return this.add(glyph, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Layout add(long glyph, float scale, float advance, float offsetX, float offsetY, float rotation) {
        if (!this.atLimit) {
            if ((glyph & 0xFFFFL) == 10L) {
                if (this.lines.size >= this.maxLines) {
                    this.atLimit = true;
                    return null;
                }
                Line line = new Line();
                Line prev = (Line)this.lines.peek();
                prev.glyphs.add(10L);
                line.height = 0.0f;
                this.lines.add((Object)line);
            } else {
                ((Line)this.lines.peek()).glyphs.add(glyph);
            }
            this.sizing.add(scale, scale);
            this.advances.add(advance);
            this.offsets.add(offsetX, offsetY);
            this.rotations.add(rotation);
        }
        return this;
    }

    public Layout clear() {
        this.lines.clear();
        this.sizing.clear();
        this.advances.clear();
        this.offsets.clear();
        this.rotations.clear();
        this.lines.add((Object)new Line());
        this.atLimit = false;
        return this;
    }

    public float getWidth() {
        if (this.justification != Justify.NONE && this.lines.size > 1 && !this.justification.ignoreLastLine) {
            return this.targetWidth;
        }
        float w = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            w = Math.max(w, ((Line)this.lines.get((int)i)).width);
        }
        return w;
    }

    public float getHeight() {
        float h = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            h += ((Line)this.lines.get((int)i)).height;
        }
        return h;
    }

    public int lines() {
        return this.lines.size;
    }

    public Line getLine(int i) {
        if (i >= this.lines.size) {
            return null;
        }
        return (Line)this.lines.get(i);
    }

    public Line peekLine() {
        return (Line)this.lines.peek();
    }

    public Line pushLine() {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        Line line = new Line();
        if (this.advances.isEmpty()) {
            this.add(10L);
        } else {
            this.add(10L, this.sizing.peek(), this.advances.peek(), this.offsets.get(this.offsets.size - 2), this.offsets.peek(), this.rotations.peek());
        }
        line.height = 0.0f;
        this.lines.add((Object)line);
        return line;
    }

    public Line pushLineBare() {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        Line line = new Line();
        line.height = 0.0f;
        this.lines.add((Object)line);
        return line;
    }

    public Line insertLine(int index) {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        if (index < 0 || index >= this.maxLines) {
            return null;
        }
        Line line = new Line();
        Line prev = (Line)this.lines.get(index);
        prev.glyphs.add(10L);
        line.height = 0.0f;
        this.lines.insert(index + 1, (Object)line);
        return line;
    }

    public float getTargetWidth() {
        return this.targetWidth;
    }

    public Layout setTargetWidth(float targetWidth) {
        this.targetWidth = targetWidth;
        return this;
    }

    public float getBaseColor() {
        return this.baseColor;
    }

    public Layout setBaseColor(float baseColor) {
        this.baseColor = baseColor;
        return this;
    }

    public Layout setBaseColor(Color baseColor) {
        this.baseColor = baseColor == null ? Color.WHITE_FLOAT_BITS : baseColor.toFloatBits();
        return this;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public Layout setMaxLines(int maxLines) {
        this.maxLines = Math.max(1, maxLines);
        return this;
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public Layout setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
        return this;
    }

    public Justify getJustification() {
        return this.justification;
    }

    public Layout setJustification(Justify justification) {
        this.justification = justification == null ? Justify.NONE : justification;
        return this;
    }

    public int countGlyphs() {
        int layoutSize = 0;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            layoutSize += ((Line)this.lines.get((int)i)).glyphs.size;
        }
        return layoutSize;
    }

    public int countGlyphsBeforeLine(int lineIndex) {
        int layoutSize = 0;
        int n = Math.min(this.lines.size, lineIndex);
        for (int i = 0; i < n; ++i) {
            layoutSize += ((Line)this.lines.get((int)i)).glyphs.size;
        }
        return layoutSize;
    }

    public void reset() {
        this.clear();
        this.justification = Justify.NONE;
        this.targetWidth = 0.0f;
        this.baseColor = Color.WHITE_FLOAT_BITS;
        this.maxLines = Integer.MAX_VALUE;
        this.atLimit = false;
        this.ellipsis = null;
        this.font = null;
    }

    public StringBuilder appendIntoDirect(StringBuilder sb) {
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            Line line = (Line)this.lines.get(i);
            int ln = line.glyphs.size;
            for (int j = 0; j < ln; ++j) {
                long gl = line.glyphs.get(j);
                sb.append((char)gl);
            }
        }
        return sb;
    }

    public StringBuilder appendSubstringInto(StringBuilder sb, int start, int end) {
        start = Math.max(0, start);
        end = Math.min(Math.max(this.countGlyphs(), start), end);
        int index = start;
        sb.ensureCapacity(end - start);
        int glyphCount = 0;
        int n = this.lines.size;
        for (int i = 0; i < n && index >= 0; ++i) {
            LongArray glyphs = ((Line)this.lines.get((int)i)).glyphs;
            if (index < glyphs.size) {
                int fin = index - start - glyphCount + end;
                while (index < fin && index < glyphs.size) {
                    char c = (char)glyphs.get(index);
                    if (c >= '\ue000' && c <= '\uf800') {
                        String name = (String)this.font.namesByCharCode.get((int)c);
                        if (name != null) {
                            sb.append(name);
                        } else {
                            sb.append(c);
                        }
                    } else if (c == '\u0002') {
                        sb.append('[');
                    } else {
                        sb.append(c);
                    }
                    ++glyphCount;
                    ++index;
                }
                if (glyphCount == end - start) {
                    return sb;
                }
                index = 0;
                continue;
            }
            index -= glyphs.size;
        }
        return sb;
    }

    public StringBuilder appendInto(StringBuilder sb) {
        return this.appendSubstringInto(sb, 0, Integer.MAX_VALUE);
    }

    public String toString() {
        return this.appendInto(new StringBuilder()).toString();
    }

    public Layout truncateExtra(int i) {
        this.advances.truncate(i);
        this.rotations.truncate(i);
        this.sizing.truncate(i << 1);
        this.offsets.truncate(i << 1);
        return this;
    }
}

