/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TextraField;
import com.github.tommyettinger.textra.TypingLabel;

public class TextraArea
extends TextraField {
    public TextraArea(@Null String text, Skin skin) {
        this(text, (Styles.TextFieldStyle)skin.get(Styles.TextFieldStyle.class));
    }

    public TextraArea(@Null String text, Skin skin, Font replacementFont) {
        this(text, (Styles.TextFieldStyle)skin.get(Styles.TextFieldStyle.class), replacementFont);
    }

    public TextraArea(@Null String text, Skin skin, String styleName) {
        this(text, (Styles.TextFieldStyle)skin.get(styleName, Styles.TextFieldStyle.class));
    }

    public TextraArea(String text, Styles.TextFieldStyle style) {
        Styles.TextFieldStyle s = new Styles.TextFieldStyle(style);
        s.font.enableSquareBrackets = false;
        s.font.omitCurlyBraces = false;
        this.setStyle(s);
        this.style.font.enableSquareBrackets = false;
        this.style.font.omitCurlyBraces = false;
        this.label = new TypingLabel("", new Styles.LabelStyle(this.style.font, style.fontColor));
        this.label.workingLayout.targetWidth = 1.0f;
        this.label.setMaxLines(Integer.MAX_VALUE);
        this.label.setAlignment(10);
        this.label.setWrap(true);
        this.label.setSelectable(true);
        if (style.selection != null) {
            this.label.selectionDrawable = style.selection;
        }
        this.writeEnters = true;
        this.initialize();
        this.label.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.setText(text);
        this.label.skipToTheEnd(true, true);
        this.updateDisplayText();
    }

    public TextraArea(String text, Styles.TextFieldStyle style, Font replacementFont) {
        this.setStyle(style);
        replacementFont = new Font(replacementFont);
        replacementFont.enableSquareBrackets = false;
        replacementFont.omitCurlyBraces = false;
        this.label = new TypingLabel("", new Styles.LabelStyle(replacementFont, style.fontColor));
        this.label.workingLayout.targetWidth = 1.0f;
        this.label.setMaxLines(Integer.MAX_VALUE);
        this.label.setAlignment(10);
        this.label.setWrap(true);
        this.label.setSelectable(true);
        if (style.selection != null) {
            this.label.selectionDrawable = style.selection;
        }
        this.writeEnters = true;
        this.initialize();
        this.label.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.setText(text);
        this.label.skipToTheEnd(true, true);
        this.updateDisplayText();
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        this.label.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    protected void drawCursor(Drawable cursorPatch, Batch batch, Font font, float x, float y) {
        float layoutHeight = this.label.getHeight();
        float linesHeight = this.label.getCumulativeLineHeight(this.cursor);
        cursorPatch.draw(batch, x + this.textOffset + this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.visibleTextStart) + this.fontOffset, y + layoutHeight - linesHeight, cursorPatch.getMinWidth(), this.label.getLineHeight(this.cursor));
    }

    @Override
    protected float getTextY(Font font, @Null Drawable background) {
        float textY = 0.0f;
        if (background != null) {
            textY -= background.getTopHeight();
        }
        if (font.integerPosition) {
            textY = (int)textY;
        }
        return textY;
    }
}

