/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TypingButton;
import com.github.tommyettinger.textra.TypingLabel;

public class TypingCheckBox
extends TypingButton {
    private final Image image;
    private final Cell<?> imageCell;
    private Styles.CheckBoxStyle style;

    public TypingCheckBox(@Null String text, Skin skin) {
        this(text, (Styles.CheckBoxStyle)((Object)skin.get(Styles.CheckBoxStyle.class)));
    }

    public TypingCheckBox(@Null String text, Skin skin, String styleName) {
        this(text, (Styles.CheckBoxStyle)((Object)skin.get(styleName, Styles.CheckBoxStyle.class)));
    }

    public TypingCheckBox(@Null String text, Styles.CheckBoxStyle style) {
        this(text, style, new Font(style.font));
    }

    public TypingCheckBox(@Null String text, Skin skin, Font replacementFont) {
        this(text, (Styles.CheckBoxStyle)((Object)skin.get(Styles.CheckBoxStyle.class)), replacementFont);
    }

    public TypingCheckBox(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (Styles.CheckBoxStyle)((Object)skin.get(styleName, Styles.CheckBoxStyle.class)), replacementFont);
    }

    public TypingCheckBox(@Null String text, Styles.CheckBoxStyle style, Font replacementFont) {
        super(text, style, replacementFont);
        TypingLabel label = (TypingLabel)this.getTextraLabel();
        label.setAlignment(8);
        this.image = this.newImage();
        this.image.setDrawable(style.checkboxOff);
        this.clearChildren();
        this.imageCell = this.add((Actor)this.image);
        this.add((Actor)label);
        this.pack();
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected Image newImage() {
        return new Image(null, Scaling.none);
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof Styles.CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (Styles.CheckBoxStyle)style;
        super.setStyle(style);
    }

    @Override
    public void setStyle(Button.ButtonStyle style, boolean makeGridGlyphs) {
        if (!(style instanceof Styles.CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (Styles.CheckBoxStyle)style;
        super.setStyle(style, makeGridGlyphs);
    }

    @Override
    public void setStyle(Button.ButtonStyle style, Font font) {
        if (!(style instanceof Styles.CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (Styles.CheckBoxStyle)style;
        super.setStyle(style, font);
    }

    @Override
    public Styles.CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable checkbox = null;
        if (this.isDisabled()) {
            checkbox = this.isChecked() && this.style.checkboxOnDisabled != null ? this.style.checkboxOnDisabled : this.style.checkboxOffDisabled;
        }
        if (checkbox == null) {
            boolean over;
            boolean bl = over = this.isOver() && !this.isDisabled();
            checkbox = this.isChecked() && this.style.checkboxOn != null ? (over && this.style.checkboxOnOver != null ? this.style.checkboxOnOver : this.style.checkboxOn) : (over && this.style.checkboxOver != null ? this.style.checkboxOver : this.style.checkboxOff);
        }
        this.image.setDrawable(checkbox);
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell<?> getImageCell() {
        return this.imageCell;
    }
}

