/*
 * Decompiled with CFR 0.152.
 */
package com.ToneThink.DataTable;

import com.ToneThink.DataTable.DataColumn;
import com.ToneThink.DataTable.DataColumnCollection;
import com.ToneThink.DataTable.DataKey;
import com.ToneThink.DataTable.DataRow;
import com.ToneThink.DataTable.DataRowCollection;
import com.ToneThink.DataTable.SortType;
import com.ToneThink.DataTable.SortedDataColumn;
import com.ToneThink.DataTable.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataTable {
    private static String l = "SCAN_TIME";
    private DataRowCollection m;
    private DataColumnCollection i;
    private String tableName = "";
    private String dataSourceName;
    private DataKey n = new DataKey();
    private List<DataKey> o = new ArrayList<DataKey>();
    private Map<String, Object> p = new HashMap<String, Object>();

    public final DataKey getPrimeKey() {
        return this.n;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPrimeKey(DataKey primeKey) {
        void var1_1;
        this.n = var1_1;
    }

    public final List<DataKey> getDataIndexs() {
        return this.o;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataIndexs(List<DataKey> dataIndexs) {
        void var1_1;
        this.o = var1_1;
    }

    public DataTable() {
        this.i = new DataColumnCollection();
        this.m = new DataRowCollection();
        this.m.setColumns(this.i);
    }

    /*
     * WARNING - void declaration
     */
    public DataTable(String dataTableName) {
        this();
        void var1_1;
        this.tableName = var1_1;
    }

    public final int getCount() {
        return this.m.size();
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTableName(String tableName) {
        void var1_1;
        this.tableName = var1_1;
    }

    public final DataRowCollection Rows() {
        return this.m;
    }

    public final DataColumnCollection Columns() {
        return this.i;
    }

    public final DataRowCollection getRows() {
        return this.m;
    }

    public final DataColumnCollection getColumns() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getValue(int row, String colName) {
        void var2_2;
        void var1_1;
        return this.m.get((int)var1_1).getValue((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Object getValue(int row, int col) {
        void var2_2;
        void var1_1;
        return this.m.get((int)var1_1).getValue((int)var2_2);
    }

    public final DataRow newRow() {
        DataRow dataRow = new DataRow(this);
        try {
            int n = this.m.size() > 0 ? this.m.get(this.m.size() - 1).getRowIndex() : 0;
            dataRow.setColumns(this.i);
            dataRow.setRowIndex(++n);
        }
        catch (Exception exception) {}
        return dataRow;
    }

    /*
     * WARNING - void declaration
     */
    public final void setValue(int row, int col, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.m.get((int)var1_1).setValue((int)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void setValue(int row, String colName, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.m.get((int)var1_1).setValue((String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTag(String name, Object value) {
        void var2_2;
        void var1_1;
        this.p.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Object getTag(String name) {
        void var1_1;
        return this.p.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final DataColumn addColumn(String columnName, int dataType) {
        void var2_2;
        void var1_1;
        return this.i.addColumn((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final DataColumn addColumnIndex(int index, String columnName, int dataType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.i.addColumn((int)var1_1, (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addRow(DataRow row) {
        boolean bl = false;
        try {
            void var1_1;
            if (this.m.size() > 0) {
                row.setRowIndex(this.m.get(this.m.size() - 1).getRowIndex() + 1);
            } else {
                row.setRowIndex(1);
            }
            bl = this.m.add((DataRow)var1_1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public final DataTable select(String filterString) {
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        if (StringUtil.IsNotEmpty(filterString)) {
            for (DataRow dataRow : this.m) {
                Boolean bl;
                try {
                    bl = StringUtil.compute(filterString, dataRow);
                }
                catch (EmptyStackException emptyStackException) {
                    System.out.println("DataTable select \u6267\u884c\u6210\u529f\uff0c\u6761\u4ef6\u4e0d\u7b26:" + emptyStackException.getMessage());
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("DataTable select \u6267\u884c\u9519\u8bef\uff0c\u8df3\u8fc7\u6267\u884c:" + exception.getMessage());
                    continue;
                }
                if (!bl.booleanValue()) continue;
                arrayList.add(dataRow);
            }
            DataTable dataTable = this.cloneTable();
            dataTable.getRows().addAll((Collection<? extends DataRow>)arrayList);
            return dataTable;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final DataTable select(String filterString, String orderBy) {
        void var1_1;
        String[] stringArray = orderBy.split(",");
        ArrayList<SortedDataColumn> arrayList = new ArrayList<SortedDataColumn>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            SortedDataColumn sortedDataColumn = new SortedDataColumn();
            String string2 = string.trim().toLowerCase();
            if (string2.endsWith("desc")) {
                sortedDataColumn.setSortType(SortType.DESC);
            } else {
                sortedDataColumn.setSortType(SortType.ASC);
            }
            String string3 = string2.replace("desc", "").replace("asc", "").trim();
            sortedDataColumn.setColumn(this.getColumns().get(string3));
            arrayList.add(sortedDataColumn);
        }
        DataTable dataTable = this.cloneTable();
        for (DataRow dataRow : this.select((String)var1_1).getRows()) {
            this.sort(dataTable, dataRow, arrayList);
        }
        return dataTable;
    }

    /*
     * WARNING - void declaration
     */
    public final DataTable sort(DataTable table, DataRow row, List<SortedDataColumn> sort) {
        void var1_1;
        void var2_2;
        if (table == null) {
            return null;
        }
        int n = 0;
        for (DataRow dataRow : table.m) {
            int n2 = 0;
            ++n;
            for (SortedDataColumn sortedDataColumn : sort) {
                if (sortedDataColumn.getColumn() == null) continue;
                int n3 = sortedDataColumn.getSortType() == SortType.DESC ? DataTable.compare(row.getValue(sortedDataColumn.getColumn().getColumnName()), dataRow.getValue(sortedDataColumn.getColumn().getColumnName())) : DataTable.compare(dataRow.getValue(sortedDataColumn.getColumn().getColumnName()), row.getValue(sortedDataColumn.getColumn().getColumnName()));
                if (n3 < 0) {
                    n2 = 0;
                    break;
                }
                if ((n2 += n3) <= 0) continue;
                --n;
                break;
            }
            if (n2 <= 0) continue;
        }
        table.getRows().add(n, (DataRow)var2_2);
        return var1_1;
    }

    public final DataTable cloneTable() {
        try {
            DataTable dataTable = new DataTable();
            dataTable.setTableName(this.getTableName());
            dataTable.setDataSourceName(this.getDataSourceName());
            dataTable.setPrimeKey(this.n);
            dataTable.setDataIndexs(this.getDataIndexs());
            for (DataColumn dataColumn : this.i) {
                dataTable.addColumn(dataColumn.getColumnName(), dataColumn.getDataType()).setDisplayed(dataColumn.isDisplayed());
            }
            return dataTable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final DataTable copyTable() {
        try {
            DataTable dataTable = new DataTable();
            dataTable.setTableName(this.getTableName());
            dataTable.setDataSourceName(this.getDataSourceName());
            dataTable.setPrimeKey(this.n);
            dataTable.setDataIndexs(this.getDataIndexs());
            for (Object object : this.i) {
                dataTable.addColumn(((DataColumn)object).getColumnName(), ((DataColumn)object).getDataType()).setDisplayed(((DataColumn)object).isDisplayed());
            }
            for (Object object : this.Rows()) {
                DataRow dataRow = dataTable.newRow();
                dataRow.copyFrom((DataRow)object);
                dataTable.addRow(dataRow);
            }
            return dataTable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final DataTable select(String filterString, String[] columns, boolean distinct) {
        Iterator iterator;
        DataRowCollection dataRowCollection;
        DataTable dataTable = new DataTable();
        dataRowCollection = this.select((String)((Object)dataRowCollection)).getRows();
        for (DataColumn dataColumn : iterator) {
            dataColumn = this.i.get((String)((Object)dataColumn));
            DataColumn dataColumn2 = new DataColumn(dataColumn.getColumnName(), dataColumn.getDataType());
            dataColumn2.setCaptionName(dataColumn.getCaptionName());
            dataTable.i.add(dataColumn2);
        }
        for (DataRow dataRow : dataRowCollection) {
            DataRow dataRow2 = dataTable.newRow();
            dataRow2.copyFrom(dataRow);
            dataTable.addRow(dataRow2);
        }
        return dataTable;
    }

    public static Object newest(DataTable table, Object field, Object filter) {
        Object object;
        Object object2 = -99999999;
        if (((DataTable)object).getColumns().contains(l)) {
            Object object3 = null;
            if (StringUtil.IsEmpty((filter = filter.toString().replace("[", "").replace("]", "")).toString())) {
                filter = "1>0";
            }
            object = ((DataTable)object).select(filter.toString()).getRows();
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DataRow dataRow = (DataRow)iterator.next();
                if (StringUtil.IsEmpty(filter.toString())) {
                    filter = "1>0";
                }
                if (n == 0) {
                    object3 = StringUtil.getDate(dataRow.getValue(l).toString());
                    object2 = dataRow.getValue(field.toString());
                } else {
                    object = StringUtil.getDate(dataRow.getValue(l).toString());
                    if (((Date)object3).before((Date)object)) {
                        object3 = object;
                        object2 = dataRow.getValue(field.toString());
                    }
                }
                ++n;
            }
        }
        if (object2 == null) {
            return -99999999;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object max(DataTable dt, Object field) {
        void var1_1;
        return DataTable.max(dt, var1_1, "");
    }

    public static Object max(DataTable dt, Object field, Object filter) {
        Iterator iterator;
        double d = -9.99999999E8;
        field = field.toString().replace("[", "").replace("]", "");
        if (iterator != null) {
            Object object;
            if (StringUtil.IsEmpty((filter = filter.toString().replace("[", "").replace("]", "")).toString())) {
                filter = "1>0";
            }
            iterator = ((DataTable)((Object)iterator)).select(object.toString()).getRows().iterator();
            while (iterator.hasNext()) {
                double d2;
                object = ((DataRow)iterator.next()).getValue(field.toString());
                if (object == null || object.toString().equals("") || !(d < (d2 = Double.parseDouble(object.toString())))) continue;
                d = d2;
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public static Object min(Object dt, Object field) {
        void var1_1;
        return DataTable.min(dt, var1_1, "");
    }

    public static Object min(Object dt, Object field, Object filter) {
        Iterator iterator;
        double d = 9.99999999E8;
        field = field.toString().replace("[", "").replace("]", "");
        if ((iterator = (DataTable)((Object)iterator)) != null) {
            Object object;
            if (StringUtil.IsEmpty(filter.toString())) {
                filter = "1>0";
            }
            iterator = ((DataTable)((Object)iterator)).select(object.toString().replace("[", "").replace("]", "")).getRows().iterator();
            while (iterator.hasNext()) {
                double d2;
                object = ((DataRow)iterator.next()).getValue(field.toString());
                if (object == null || object.toString().equals("") || !(d > (d2 = Double.parseDouble(object.toString())))) continue;
                d = d2;
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public static Object avg(Object dt, Object field) {
        void var1_1;
        return DataTable.avg(dt, var1_1, "");
    }

    public static Object avg(Object dt, Object field, Object filter) {
        Object object;
        double d = 0.0;
        filter = filter.toString().replace("[", "").replace("]", "");
        field = field.toString().replace("[", "").replace("]", "");
        if ((object = (DataTable)object) != null) {
            Iterator iterator;
            if (StringUtil.IsEmpty(filter.toString())) {
                filter = "1>0";
            }
            object = ((DataTable)object).select(iterator.toString().replace("[", "").replace("]", "")).getRows();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = ((DataRow)iterator.next()).getValue(field.toString());
                if (object2 == null || object2.toString().equals("")) continue;
                d += Double.parseDouble(object2.toString());
            }
            d = object.size() == 0 ? 0.0 : (d /= (double)object.size());
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public static Object sum(Object dt, Object field) {
        void var1_1;
        return DataTable.sum(dt, var1_1, "");
    }

    public static Object sum(Object dt, Object field, Object filter) {
        Iterator iterator;
        field = field.toString().replace("[", "").replace("]", "");
        double d = 0.0;
        if ((iterator = (DataTable)((Object)iterator)) != null) {
            Object object;
            if (StringUtil.IsEmpty(filter.toString())) {
                filter = "1>0";
            }
            iterator = ((DataTable)((Object)iterator)).select(object.toString().replace("[", "").replace("]", "")).getRows().iterator();
            while (iterator.hasNext()) {
                object = ((DataRow)iterator.next()).getValue(field.toString());
                if (object == null || object.toString().equals("")) continue;
                d += Double.parseDouble(object.toString());
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public static Object count(Object table, Object filter) {
        void var1_1;
        Object object = (DataTable)table;
        if (((DataTable)object).i.contains(filter.toString().trim())) {
            filter = "";
        }
        return ((DataTable)object).select(var1_1.toString().replace("[", "").replace("]", "")).getRows().size();
    }

    public static Object count(Object table) {
        return DataTable.count(table, "");
    }

    public final Object compute(Object object) {
        String string;
        if (object == null) {
            return null;
        }
        if (this.i.contains(object.toString().trim().toLowerCase()) && this.getRows().size() > 0) {
            return this.getRows().get(0).getValue(object.toString());
        }
        string = string.toString();
        Matcher matcher = Pattern.compile("(max|min|avg|sum|count)[\\s]*\\(").matcher(string);
        while (matcher.find()) {
            string = string.replace(matcher.group(0), matcher.group(0) + "table,");
        }
        return StringUtil.compute(string, this);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(Object a, Object b) {
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        try {
            if (Double.parseDouble(a.toString()) > Double.parseDouble(b.toString())) {
                return 1;
            }
            if (Double.parseDouble(a.toString()) < Double.parseDouble(b.toString())) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            try {
                if (StringUtil.getDate(a.toString()).after(StringUtil.getDate(b.toString()))) {
                    return 1;
                }
                if (StringUtil.getDate(a.toString()).equals(StringUtil.getDate(b.toString()))) {
                    return 0;
                }
                return -1;
            }
            catch (Exception exception2) {
                void var1_1;
                Object object;
                if (a.toString().compareTo(b.toString()) == 0) {
                    return 0;
                }
                if (object.toString().compareTo(var1_1.toString()) > 0) {
                    return 1;
                }
                return -1;
            }
        }
    }

    public final Object get(String varname) {
        if (varname.equals("table")) {
            return this;
        }
        return null;
    }

    public final boolean has(String varName) {
        return varName.equals("table");
    }

    public final Map getContextMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("table", this);
        for (DataColumn dataColumn : this.getColumns()) {
            hashMap.put(dataColumn.getColumnName().toLowerCase(), dataColumn.getColumnName().toLowerCase());
        }
        return hashMap;
    }

    public final Object set(String varname, Object o) {
        return null;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDataSourceName(String dataSourceName) {
        void var1_1;
        this.dataSourceName = var1_1;
    }

    public final void Merge(DataTable table) {
        Iterator<DataRow> iterator;
        if (table == null) {
            return;
        }
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (DataRow dataRow : ((DataTable)((Object)iterator)).m) {
            if (this.m.contains(dataRow)) continue;
            arrayList.add(dataRow);
        }
        this.getRows().addAll((Collection<? extends DataRow>)arrayList);
    }
}

