/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purecfg;

import com.github.tonivade.purecfg.DSLOf;
import com.github.tonivade.purecfg.PureCFG;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Precondition;

@HigherKind
public sealed interface DSL<T>
extends DSLOf<T> {
    public String key();

    public <F extends Kind<F, ?>> Kind<F, T> accept(Visitor<F> var1);

    public record ReadConfig<T>(String key, PureCFG<T> next) implements DSL<T>
    {
        public ReadConfig {
            Precondition.checkNonNull((Object)key);
            Precondition.checkNonNull(next);
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, T> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public record ReadIterable<T>(String key, PureCFG<T> next) implements DSL<Iterable<T>>
    {
        public ReadIterable {
            Precondition.checkNonEmpty((String)key);
            Precondition.checkNonNull(next);
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, Iterable<T>> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public record ReadPrimitiveIterable<T>(String key, Class<T> type) implements DSL<Iterable<T>>
    {
        public ReadPrimitiveIterable {
            Precondition.checkNonEmpty((String)key);
            Precondition.checkNonNull(type);
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, Iterable<T>> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public record ReadBoolean(String key) implements DSL<Boolean>
    {
        public ReadBoolean {
            Precondition.checkNonEmpty((String)key);
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, Boolean> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public record ReadString(String key) implements DSL<String>
    {
        public ReadString {
            Precondition.checkNonEmpty((String)key);
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, String> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public record ReadInt(String key) implements DSL<Integer>
    {
        public ReadInt {
            Precondition.checkNonEmpty((String)key);
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, Integer> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public record Pure<T>(String key, T value) implements DSL<T>
    {
        public Pure {
            Precondition.checkNonEmpty((String)key);
            Precondition.checkNonNull(value);
        }

        public T get() {
            return this.value;
        }

        @Override
        public <F extends Kind<F, ?>> Kind<F, T> accept(Visitor<F> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface Visitor<F extends Kind<F, ?>> {
        public <T> Kind<F, T> visit(Pure<T> var1);

        public Kind<F, String> visit(ReadString var1);

        public Kind<F, Integer> visit(ReadInt var1);

        public Kind<F, Boolean> visit(ReadBoolean var1);

        public <T> Kind<F, Iterable<T>> visit(ReadPrimitiveIterable<T> var1);

        public <T> Kind<F, Iterable<T>> visit(ReadIterable<T> var1);

        public <T> Kind<F, T> visit(ReadConfig<T> var1);
    }
}

