/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purecfg;

import com.github.tonivade.purecfg.DSL;
import com.github.tonivade.purecfg.DSLOf;
import com.github.tonivade.purecfg.PureCFGApplicative;
import com.github.tonivade.purecfg.PureCFGOf;
import com.github.tonivade.purecfg.Source;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Applicable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Function3;
import com.github.tonivade.purefun.core.Function4;
import com.github.tonivade.purefun.core.Function5;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.data.ImmutableArray;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.data.SequenceOf;
import com.github.tonivade.purefun.free.FreeAp;
import com.github.tonivade.purefun.type.Const;
import com.github.tonivade.purefun.type.ConstOf;
import com.github.tonivade.purefun.type.Id;
import com.github.tonivade.purefun.type.IdOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.OptionOf;
import com.github.tonivade.purefun.type.Validation;
import com.github.tonivade.purefun.type.ValidationOf;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Instance;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.purefun.typeclasses.Monoid;
import com.github.tonivade.purefun.typeclasses.Semigroup;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;

@HigherKind
public final class PureCFG<T>
implements PureCFGOf<T>,
Applicable<PureCFG<?>, T> {
    private final FreeAp<DSL<?>, T> value;

    private PureCFG(DSL<T> value) {
        this(FreeAp.lift(value));
    }

    private PureCFG(FreeAp<DSL<?>, T> value) {
        this.value = (FreeAp)Precondition.checkNonNull(value);
    }

    public <R> PureCFG<R> map(Function1<? super T, ? extends R> mapper) {
        return new PureCFG<T>(this.value.map(mapper));
    }

    public <R> PureCFG<R> ap(Kind<PureCFG<?>, ? extends Function1<? super T, ? extends R>> apply) {
        return new PureCFG<T>(this.value.ap(((PureCFG)apply.fix((Function<Kind, PureCFG>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toPureCFG(com.github.tonivade.purefun.Kind<com.github.tonivade.purecfg.PureCFG<?>, ? extends T> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purecfg/PureCFG;)())).value));
    }

    private <G extends Kind<G, ?>> Kind<G, T> foldMap(FunctionK<DSL<?>, G> functionK, Applicative<G> applicative) {
        return this.value.foldMap(functionK, applicative);
    }

    public T unsafeRun(Source source) {
        return (T)((Id)this.value.foldMap(new Interpreter(new IdVisitor(Key.empty(), source)), Instances.applicative((Kind[])new Id[0])).fix(IdOf::toId)).value();
    }

    public Option<T> safeRun(Source source) {
        return (Option)this.value.foldMap(new Interpreter(new OptionVisitor(Key.empty(), source)), Instances.applicative((Kind[])new Option[0])).fix(OptionOf::toOption);
    }

    public Validation<Validation.Result<String>, T> validatedRun(Source source) {
        Instance instance = new Instance<Validation<Validation.Result<String>, ?>>(this){};
        Semigroup semigroup = Validation.Result::concat;
        return (Validation)this.value.foldMap(new Interpreter(new ValidationVisitor(Key.empty(), source)), instance.applicative(new Object[]{semigroup})).fix(ValidationOf::toValidation);
    }

    public String describe() {
        Instance instance = new Instance<Const<String, ?>>(this){};
        return (String)this.value.analyze(new Interpreter(new ConstVisitor(Key.empty())), instance.applicative(new Object[]{Monoid.string()}));
    }

    public static <A, B, C> PureCFG<C> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, Function2<? super A, ? super B, ? extends C> apply) {
        return fb.ap((Kind)fa.map(apply.curried()));
    }

    public static <A, B> Map2<A, B> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb) {
        return new Map2<A, B>(fa, fb);
    }

    public static <A, B, C, D> PureCFG<D> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, Function3<? super A, ? super B, ? super C, ? extends D> apply) {
        return fc.ap(PureCFG.mapN(fa, fb, (a, b) -> (Function1)((Function1)apply.curried().apply(a)).apply(b)));
    }

    public static <A, B, C> Map3<A, B, C> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc) {
        return new Map3<A, B, C>(fa, fb, fc);
    }

    public static <A, B, C, D, E> PureCFG<E> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, PureCFG<? extends D> fd, Function4<? super A, ? super B, ? super C, ? super D, ? extends E> apply) {
        return fd.ap(PureCFG.mapN(fa, fb, fc, (a, b, c) -> (Function1)((Function1)((Function1)apply.curried().apply(a)).apply(b)).apply(c)));
    }

    public static <A, B, C, D> Map4<A, B, C, D> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, PureCFG<? extends D> fd) {
        return new Map4<A, B, C, D>(fa, fb, fc, fd);
    }

    public static <A, B, C, D, E, F> PureCFG<F> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, PureCFG<? extends D> fd, PureCFG<? extends E> fe, Function5<? super A, ? super B, ? super C, ? super D, ? super E, ? extends F> apply) {
        return fe.ap(PureCFG.mapN(fa, fb, fc, fd, (a, b, c, d) -> (Function1)((Function1)((Function1)((Function1)apply.curried().apply(a)).apply(b)).apply(c)).apply(d)));
    }

    public static <A, B, C, D, E> Map5<A, B, C, D, E> mapN(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, PureCFG<? extends D> fd, PureCFG<? extends E> fe) {
        return new Map5<A, B, C, D, E>(fa, fb, fc, fd, fe);
    }

    public static <T> PureCFG<T> pure(T value) {
        return new PureCFG<T>(FreeAp.pure(value));
    }

    public static PureCFG<Integer> readInt(String key) {
        return new PureCFG<Integer>(new DSL.ReadInt(key));
    }

    public static PureCFG<String> readString(String key) {
        return new PureCFG<String>(new DSL.ReadString(key));
    }

    public static PureCFG<Boolean> readBoolean(String key) {
        return new PureCFG<Boolean>(new DSL.ReadBoolean(key));
    }

    public static <T> PureCFG<Iterable<T>> readIterable(String key, Class<T> type) {
        return new PureCFG<Iterable<T>>(new DSL.ReadPrimitiveIterable<T>(key, type));
    }

    public static <T> PureCFG<Iterable<T>> readIterable(String key, PureCFG<? extends T> item) {
        return new PureCFG<Iterable<T>>(new DSL.ReadIterable(key, PureCFGOf.toPureCFG(item)));
    }

    public static <T> PureCFG<T> readConfig(String key, PureCFG<? extends T> cfg) {
        return new PureCFG(new DSL.ReadConfig(key, PureCFGOf.toPureCFG(cfg)));
    }

    public static Applicative<PureCFG<?>> applicative() {
        return PureCFGApplicative.INSTANCE;
    }

    private static final class Interpreter<F extends Kind<F, ?>>
    implements FunctionK<DSL<?>, F> {
        private final DSL.Visitor<F> visitor;

        private Interpreter(DSL.Visitor<F> visitor) {
            this.visitor = (DSL.Visitor)Precondition.checkNonNull(visitor);
        }

        public <T> Kind<F, T> apply(Kind<DSL<?>, ? extends T> from) {
            return ((DSL)from.fix(DSLOf::toDSL)).accept(this.visitor);
        }
    }

    private static final class IdVisitor
    extends AbstractVisitor<Id<?>> {
        private IdVisitor(Key baseKey, Source source) {
            super(baseKey, source);
        }

        public <T> Id<T> visit(DSL.Pure<T> value) {
            return Id.of(value.get());
        }

        public Id<String> visit(DSL.ReadString value) {
            return Id.of((Object)((String)this.getString(value).getOrElseThrow()));
        }

        public Id<Integer> visit(DSL.ReadInt value) {
            return Id.of((Object)((Integer)this.getInteger(value).getOrElseThrow()));
        }

        public Id<Boolean> visit(DSL.ReadBoolean value) {
            return Id.of((Object)((Boolean)this.getBoolean(value).getOrElseThrow()));
        }

        public <T> Id<Iterable<T>> visit(DSL.ReadIterable<T> value) {
            return ((Id)Instances.traverse((Kind[])new Sequence[0]).sequence(Instances.applicative((Kind[])new Id[0]), this.readAll(value)).fix(IdOf::toId)).map(s -> (Iterable)s.fix(SequenceOf::toSequence));
        }

        public <T> Id<Iterable<T>> visit(DSL.ReadPrimitiveIterable<T> value) {
            return ((Id)Instances.traverse((Kind[])new Sequence[0]).sequence(Instances.applicative((Kind[])new Id[0]), this.readAll(value)).fix(IdOf::toId)).map(s -> (Iterable)s.fix(SequenceOf::toSequence));
        }

        public <A> Id<A> visit(DSL.ReadConfig<A> value) {
            return (Id)value.next().foldMap(this.nestedInterpreter(value), Instances.applicative((Kind[])new Id[0])).fix(IdOf::toId);
        }

        private <A> Interpreter<Id<?>> nestedInterpreter(DSL.ReadConfig<A> value) {
            return new Interpreter(new IdVisitor(Key.with(value.key()), this.getSource()));
        }
    }

    @FunctionalInterface
    private static interface Key {
        public String extend(DSL<?> var1);

        public static Key with(String baseKey) {
            Precondition.checkNonNull((Object)baseKey);
            return dsl -> baseKey + "." + dsl.key();
        }

        public static Key empty() {
            return DSL::key;
        }
    }

    private static final class OptionVisitor
    extends AbstractVisitor<Option<?>> {
        private OptionVisitor(Key baseKey, Source source) {
            super(baseKey, source);
        }

        public <T> Option<T> visit(DSL.Pure<T> value) {
            return Option.of(value.get());
        }

        public Option<String> visit(DSL.ReadString value) {
            return this.getString(value);
        }

        public Option<Integer> visit(DSL.ReadInt value) {
            return this.getInteger(value);
        }

        public Option<Boolean> visit(DSL.ReadBoolean value) {
            return this.getBoolean(value);
        }

        public <T> Option<Iterable<T>> visit(DSL.ReadIterable<T> value) {
            return ((Option)Instances.traverse((Kind[])new Sequence[0]).sequence(Instances.applicative((Kind[])new Option[0]), this.readAll(value)).fix(OptionOf::toOption)).map(s -> (Iterable)s.fix(SequenceOf::toSequence));
        }

        public <T> Option<Iterable<T>> visit(DSL.ReadPrimitiveIterable<T> value) {
            return ((Option)Instances.traverse((Kind[])new Sequence[0]).sequence(Instances.applicative((Kind[])new Option[0]), this.readAll(value)).fix(OptionOf::toOption)).map(s -> (Iterable)s.fix(SequenceOf::toSequence));
        }

        public <A> Option<A> visit(DSL.ReadConfig<A> value) {
            return (Option)value.next().foldMap(this.nestedInterpreter(value), Instances.applicative((Kind[])new Option[0])).fix(OptionOf::toOption);
        }

        private <A> Interpreter<Option<?>> nestedInterpreter(DSL.ReadConfig<A> value) {
            return new Interpreter(new OptionVisitor(Key.with(value.key()), this.getSource()));
        }
    }

    private static final class ValidationVisitor
    extends AbstractVisitor<Validation<Validation.Result<String>, ?>> {
        private ValidationVisitor(Key baseKey, Source source) {
            super(baseKey, source);
        }

        @Override
        public <T> Validation<Validation.Result<String>, T> visit(DSL.Pure<T> value) {
            return Validation.valid(value.get());
        }

        @Override
        public Validation<Validation.Result<String>, String> visit(DSL.ReadString value) {
            return (Validation)this.getString(value).fold(() -> this.invalid(value), this::valid);
        }

        @Override
        public Validation<Validation.Result<String>, Integer> visit(DSL.ReadInt value) {
            return (Validation)this.getInteger(value).fold(() -> this.invalid(value), this::valid);
        }

        @Override
        public Validation<Validation.Result<String>, Boolean> visit(DSL.ReadBoolean value) {
            return (Validation)this.getBoolean(value).fold(() -> this.invalid(value), this::valid);
        }

        @Override
        public <T> Validation<Validation.Result<String>, Iterable<T>> visit(DSL.ReadIterable<T> value) {
            Instance instance = new Instance<Validation<Validation.Result<String>, ?>>(this){};
            Semigroup semigroup = Validation.Result::concat;
            return ((Validation)Instances.traverse((Kind[])new Sequence[0]).sequence(instance.applicative(new Object[]{semigroup}), this.readAll(value)).fix(ValidationOf::toValidation)).map(s -> (Iterable)s.fix(SequenceOf::toSequence));
        }

        @Override
        public <T> Validation<Validation.Result<String>, Iterable<T>> visit(DSL.ReadPrimitiveIterable<T> value) {
            Instance instance = new Instance<Validation<Validation.Result<String>, ?>>(this){};
            Semigroup semigroup = Validation.Result::concat;
            return ((Validation)Instances.traverse((Kind[])new Sequence[0]).sequence(instance.applicative(new Object[]{semigroup}), this.readAll(value)).fix(ValidationOf::toValidation)).map(s -> (Iterable)s.fix(SequenceOf::toSequence));
        }

        @Override
        public <A> Validation<Validation.Result<String>, A> visit(DSL.ReadConfig<A> value) {
            Instance instance = new Instance<Validation<Validation.Result<String>, ?>>(this){};
            Semigroup semigroup = Validation.Result::concat;
            return (Validation)value.next().foldMap(this.nestedInterpreter(value), instance.applicative(new Object[]{semigroup})).fix(ValidationOf::toValidation);
        }

        private <A> Interpreter<Validation<Validation.Result<String>, ?>> nestedInterpreter(DSL.ReadConfig<A> value) {
            return new Interpreter(new ValidationVisitor(Key.with(value.key()), this.getSource()));
        }

        private <T> Validation<Validation.Result<String>, T> invalid(DSL<T> value) {
            return Validation.invalid((Object)Validation.Result.of((Object)("key not found: " + this.extend(value)), (Object[])new String[0]));
        }

        private <T> Validation<Validation.Result<String>, T> valid(T value) {
            return Validation.valid(value);
        }
    }

    private static final class ConstVisitor
    implements DSL.Visitor<Const<String, ?>> {
        private final Key baseKey;

        private ConstVisitor(Key baseKey) {
            this.baseKey = (Key)Precondition.checkNonNull((Object)baseKey);
        }

        @Override
        public <T> Const<String, T> visit(DSL.Pure<T> value) {
            return this.typeOf(value, String.valueOf(value.get()));
        }

        @Override
        public Const<String, String> visit(DSL.ReadString value) {
            return this.typeOf(value, "String");
        }

        @Override
        public Const<String, Integer> visit(DSL.ReadInt value) {
            return this.typeOf(value, "Integer");
        }

        @Override
        public Const<String, Boolean> visit(DSL.ReadBoolean value) {
            return this.typeOf(value, "Boolean");
        }

        @Override
        public <T> Const<String, Iterable<T>> visit(DSL.ReadIterable<T> value) {
            return ((Const)this.visit((DSL.ReadConfig<A>)new DSL.ReadConfig<T>(this.extend(value) + ".[]", value.next())).fix(ConstOf::toConst)).retag();
        }

        @Override
        public <T> Const<String, Iterable<T>> visit(DSL.ReadPrimitiveIterable<T> value) {
            return this.typeOf(value, value.type().getSimpleName() + "[]");
        }

        @Override
        public <A> Const<String, A> visit(DSL.ReadConfig<A> value) {
            Instance instance = new Instance<Const<String, ?>>(this){};
            return (Const)value.next().foldMap(this.nestedInterpreter(value), instance.applicative(new Object[]{Monoid.string()})).fix(ConstOf::toConst);
        }

        private <T> Const<String, T> typeOf(DSL<T> value, String type) {
            return Const.of((Object)("- " + this.extend(value) + ": " + type + "\n"));
        }

        private <A> Interpreter<Const<String, ?>> nestedInterpreter(DSL.ReadConfig<A> value) {
            return new Interpreter(new ConstVisitor(Key.with(this.extend(value))));
        }

        private String extend(DSL<?> value) {
            return this.baseKey.extend(value);
        }
    }

    public record Map2<A, B>(PureCFG<? extends A> fa, PureCFG<? extends B> fb) {
        public <C> PureCFG<C> apply(Function2<? super A, ? super B, ? extends C> apply) {
            return PureCFG.mapN(this.fa, this.fb, apply);
        }
    }

    public record Map3<A, B, C>(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc) {
        public <D> PureCFG<D> apply(Function3<? super A, ? super B, ? super C, ? extends D> apply) {
            return PureCFG.mapN(this.fa, this.fb, this.fc, apply);
        }
    }

    public record Map4<A, B, C, D>(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, PureCFG<? extends D> fd) {
        public <E> PureCFG<E> apply(Function4<? super A, ? super B, ? super C, ? super D, ? extends E> apply) {
            return PureCFG.mapN(this.fa, this.fb, this.fc, this.fd, apply);
        }
    }

    public record Map5<A, B, C, D, E>(PureCFG<? extends A> fa, PureCFG<? extends B> fb, PureCFG<? extends C> fc, PureCFG<? extends D> fd, PureCFG<? extends E> fe) {
        public <F> PureCFG<F> apply(Function5<? super A, ? super B, ? super C, ? super D, ? super E, ? extends F> apply) {
            return PureCFG.mapN(this.fa, this.fb, this.fc, this.fd, this.fe, apply);
        }
    }

    private static abstract class AbstractVisitor<F extends Kind<F, ?>>
    implements DSL.Visitor<F> {
        private final Key baseKey;
        private final Source source;

        private AbstractVisitor(Key baseKey, Source source) {
            this.baseKey = (Key)Precondition.checkNonNull((Object)baseKey);
            this.source = (Source)Precondition.checkNonNull((Object)source);
        }

        protected Source getSource() {
            return this.source;
        }

        protected String extend(DSL<?> value) {
            return this.baseKey.extend(value);
        }

        protected Option<String> getString(DSL<?> value) {
            return this.source.getString(this.extend(value));
        }

        protected Option<Integer> getInteger(DSL<?> value) {
            return this.source.getInteger(this.extend(value));
        }

        protected Option<Boolean> getBoolean(DSL<?> value) {
            return this.source.getBoolean(this.extend(value));
        }

        protected <T> Sequence<Kind<F, T>> readAll(DSL.ReadPrimitiveIterable<T> value) {
            Iterable<DSL<T>> properties = this.source.getIterable(this.extend(value), value.type());
            return ImmutableArray.from(properties).map(dsl -> dsl.accept(this));
        }

        protected <T> Sequence<Kind<F, T>> readAll(DSL.ReadIterable<T> value) {
            Iterable<DSL<T>> properties = this.source.getIterable(this.extend(value), value.next());
            return ImmutableArray.from(properties).map(dsl -> dsl.accept(this));
        }
    }
}

