/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purecfg;

import com.github.tonivade.purecfg.DSL;
import com.github.tonivade.purecfg.PureCFG;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.data.ImmutableArray;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public interface Source {
    public Option<String> getString(String var1);

    public Option<Integer> getInteger(String var1);

    public Option<Boolean> getBoolean(String var1);

    public <T> Iterable<DSL<T>> getIterable(String var1, Class<T> var2);

    public <T> Iterable<DSL<T>> getIterable(String var1, PureCFG<T> var2);

    public static Source fromProperties(String file) {
        return Source.from(PropertiesSource.read(file));
    }

    public static Source fromToml(String file) {
        return Source.from(TomlSource.read(file));
    }

    public static Source fromArgs(String ... args) {
        return Source.from(Source.parseArgs(args));
    }

    public static Source from(Properties properties) {
        return new PropertiesSource(properties);
    }

    public static Source from(TomlParseResult toml) {
        return new TomlSource(toml);
    }

    private static Properties parseArgs(String[] args) {
        Properties properties = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String current = args[i];
            if (current.charAt(0) == '-') {
                if (current.length() < 2) {
                    throw new IllegalArgumentException("Not a valid argument: " + current);
                }
                if (current.charAt(1) == '-') {
                    if (current.length() < 3) {
                        throw new IllegalArgumentException("Not a valid argument: " + current);
                    }
                    properties.setProperty(current.substring(2), Boolean.TRUE.toString());
                    continue;
                }
                if (args.length == i + 1) {
                    throw new IllegalArgumentException("Expected arg after: " + current);
                }
                properties.setProperty(current.substring(1), args[++i]);
                continue;
            }
            throw new IllegalArgumentException("invalid param: " + current);
        }
        return properties;
    }

    public static final class PropertiesSource
    implements Source {
        private final Properties properties;

        public PropertiesSource(Properties properties) {
            this.properties = (Properties)Precondition.checkNonNull((Object)properties);
        }

        public static Properties read(String file) {
            try {
                Properties properties = new Properties();
                properties.load((InputStream)Precondition.checkNonNull((Object)PropertiesSource.class.getClassLoader().getResourceAsStream(file)));
                return properties;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Option<String> getString(String key) {
            return this.readString(key);
        }

        @Override
        public Option<Integer> getInteger(String key) {
            return this.readString(key).map(Integer::parseInt);
        }

        @Override
        public Option<Boolean> getBoolean(String key) {
            return this.readString(key).map(Boolean::parseBoolean);
        }

        @Override
        public <T> Iterable<DSL<T>> getIterable(String key, Class<T> type) {
            return (Iterable)this.iterableKeys(key).map(k -> this.readKey((String)k, type)).collect(ImmutableArray.toImmutableArray());
        }

        @Override
        public <T> Iterable<DSL<T>> getIterable(String key, PureCFG<T> next) {
            return (Iterable)this.iterableKeys(key).map(k -> new DSL.ReadConfig((String)k, next)).collect(ImmutableArray.toImmutableArray());
        }

        private Stream<String> iterableKeys(String key) {
            String regex = "(" + key.replace("\\.", ".") + "\\.\\d+).*";
            return this.properties.keySet().stream().map(Object::toString).flatMap(k -> this.getKey((String)k, regex)).distinct().sorted();
        }

        private <T> DSL<T> readKey(String key, Class<T> type) {
            return switch (type.getSimpleName()) {
                case "String" -> new DSL.ReadString(key);
                case "Integer" -> new DSL.ReadInt(key);
                case "Boolean" -> new DSL.ReadBoolean(key);
                default -> throw new UnsupportedOperationException("this class is not supported: " + type.getName());
            };
        }

        private Option<String> readString(String key) {
            return Option.of((Object)this.properties.getProperty(key));
        }

        private Stream<String> getKey(String key, String regex) {
            Matcher matcher = Pattern.compile(regex).matcher(key);
            if (matcher.find()) {
                return Stream.of(matcher.group(1));
            }
            return Stream.empty();
        }
    }

    public static final class TomlSource
    implements Source {
        private final TomlParseResult toml;

        public TomlSource(TomlParseResult toml) {
            this.toml = (TomlParseResult)Precondition.checkNonNull((Object)toml);
        }

        public static TomlParseResult read(String file) {
            try {
                return Toml.parse((InputStream)((InputStream)Precondition.checkNonNull((Object)TomlSource.class.getClassLoader().getResourceAsStream(file))));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Option<String> getString(String key) {
            return Try.of(() -> (String)TomlSource.readValue(this.toml, key)).toOption();
        }

        @Override
        public Option<Integer> getInteger(String key) {
            return Try.of(() -> ((Long)TomlSource.readValue(this.toml, key)).intValue()).toOption();
        }

        @Override
        public Option<Boolean> getBoolean(String key) {
            return Try.of(() -> (Boolean)TomlSource.readValue(this.toml, key)).toOption();
        }

        @Override
        public <T> Iterable<DSL<T>> getIterable(String key, Class<T> type) {
            TomlArray array = this.toml.getArrayOrEmpty(key);
            if (array.isEmpty()) {
                return ImmutableArray.empty();
            }
            ArrayList<DSL.Pure<Object>> result = new ArrayList<DSL.Pure<Object>>();
            for (int i = 0; i < array.size(); ++i) {
                Object item = array.get(i);
                result.add(new DSL.Pure<Object>(key, item));
            }
            return ImmutableArray.from(result);
        }

        @Override
        public <T> Iterable<DSL<T>> getIterable(String key, PureCFG<T> next) {
            TomlArray array = this.toml.getArrayOrEmpty(key);
            if (array.isEmpty()) {
                return ImmutableArray.empty();
            }
            ArrayList<DSL.ReadConfig<T>> result = new ArrayList<DSL.ReadConfig<T>>();
            for (int i = 0; i < array.size(); ++i) {
                result.add(new DSL.ReadConfig<T>(key + "." + i, next));
            }
            return ImmutableArray.from(result);
        }

        private static <T> T readValue(TomlParseResult toml, String key) {
            Object current = toml;
            for (String item : key.split("\\.")) {
                if (current instanceof TomlTable) {
                    TomlTable table = (TomlTable)current;
                    current = table.get(item);
                    continue;
                }
                if (!(current instanceof TomlArray)) continue;
                TomlArray array = (TomlArray)current;
                current = array.get(Integer.parseInt(item));
            }
            return (T)current;
        }
    }
}

