/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Recoverable;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.StackItem;
import com.github.tonivade.purefun.type.Option;

final class CallStack<R, E, A>
implements Recoverable {
    @Nullable
    private StackItem<R, E, A> top = new StackItem();

    CallStack() {
    }

    public void push() {
        if (this.top != null) {
            this.top.push();
        }
    }

    public void pop() {
        if (this.top == null) {
            return;
        }
        if (this.top.count() > 0) {
            this.top.pop();
        } else {
            this.top = this.top.prev();
        }
    }

    public void add(PartialFunction1<? super Throwable, ? extends Kind<PureIO<R, E, ?>, ? extends A>> mapError) {
        if (this.top == null) {
            return;
        }
        if (this.top.count() > 0) {
            this.top.pop();
            this.top = new StackItem<R, E, A>(this.top);
        }
        this.top.add(mapError);
    }

    public Option<PureIO<R, E, A>> tryHandle(Throwable error) {
        while (this.top != null) {
            this.top.reset();
            Option<PureIO<R, E, A>> result = this.top.tryHandle(error);
            if (result.isPresent()) {
                return result;
            }
            this.top = this.top.prev();
        }
        return Option.none();
    }
}

