/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.core.CheckedRunnable;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.effect.EIOOf;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.PureIOOf;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Fiber;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

@HigherKind
public final class EIO<E, A>
implements EIOOf<E, A>,
Effect<EIO<E, ?>, A> {
    private static final EIO<?, Unit> UNIT = new EIO(PureIO.unit());
    private final PureIO<Void, E, A> instance;

    EIO(PureIO<Void, E, A> value) {
        this.instance = (PureIO)Precondition.checkNonNull(value);
    }

    public <R> PureIO<R, E, A> toPureIO() {
        return this.instance;
    }

    public UIO<A> toUIO() {
        return new UIO<A>(this.instance.toURIO().toPureIO());
    }

    public Either<E, A> safeRunSync() {
        return this.instance.provide(null);
    }

    public Future<Either<E, A>> runAsync() {
        return this.instance.runAsync(null);
    }

    public Future<Either<E, A>> runAsync(Executor executor) {
        return EIO.forked(executor).andThen(this).runAsync();
    }

    public void safeRunAsync(Consumer1<? super Try<? extends Either<E, ? extends A>>> callback) {
        this.instance.provideAsync(null, callback);
    }

    public <B> EIO<E, B> map(Function1<? super A, ? extends B> map) {
        return new EIO<E, A>(this.instance.map((Function1)map));
    }

    public <B> EIO<E, B> flatMap(Function1<? super A, ? extends Kind<EIO<E, ?>, ? extends B>> map) {
        return new EIO<E, A>(this.instance.flatMap(value -> {
            EIO apply = (EIO)map.andThen(EIOOf::toEIO).apply(value);
            return apply.instance;
        }));
    }

    public <B> EIO<E, B> andThen(Kind<EIO<E, ?>, ? extends B> next) {
        return new EIO<E, A>(this.instance.andThen(((EIO)next.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance));
    }

    public <B> EIO<E, B> ap(Kind<EIO<E, ?>, ? extends Function1<? super A, ? extends B>> apply) {
        return new EIO<E, A>(this.instance.ap(((EIO)apply.fix(EIOOf::toEIO)).toPureIO()));
    }

    public EIO<A, E> swap() {
        return new EIO<A, E>(this.instance.swap());
    }

    public <B> EIO<B, A> mapError(Function1<? super E, ? extends B> map) {
        return new EIO<B, A>(this.instance.mapError(map));
    }

    public <F> EIO<F, A> flatMapError(Function1<? super E, ? extends Kind<EIO<F, ?>, ? extends A>> map) {
        return new EIO(this.instance.flatMapError(error -> {
            EIO apply = (EIO)map.andThen(EIOOf::toEIO).apply(error);
            return apply.instance;
        }));
    }

    public <B, F> EIO<F, B> bimap(Function1<? super E, ? extends F> mapError, Function1<? super A, ? extends B> map) {
        return new EIO<F, B>(this.instance.bimap(mapError, map));
    }

    public <B, F> EIO<F, B> foldM(Function1<? super E, ? extends Kind<EIO<F, ?>, ? extends B>> mapError, Function1<? super A, ? extends Kind<EIO<F, ?>, ? extends B>> map) {
        return new EIO(this.instance.foldM(error -> ((EIO)mapError.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)()).apply((Object)error)).instance, value -> ((EIO)map.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)()).apply((Object)value)).instance));
    }

    public <B> UIO<B> fold(Function1<? super E, ? extends B> mapError, Function1<? super A, ? extends B> map) {
        return new UIO<B>(this.instance.fold(mapError, map).toPureIO());
    }

    public UIO<A> recover(Function1<? super E, ? extends A> mapError) {
        return new UIO<A>(this.instance.recover(mapError).toPureIO());
    }

    public EIO<E, A> orElse(EIO<E, ? extends A> other) {
        return new EIO<E, A>(this.instance.orElse(other.instance));
    }

    public <B> EIO<E, Tuple2<A, B>> zip(Kind<EIO<E, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Tuple::of);
    }

    public <B> EIO<E, A> zipLeft(Kind<EIO<E, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.first());
    }

    public <B> EIO<E, B> zipRight(Kind<EIO<E, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.second());
    }

    public <B, C> EIO<E, C> zipWith(Kind<EIO<E, ?>, ? extends B> other, Function2<? super A, ? super B, ? extends C> mapper) {
        return EIO.parMap2(this, (Kind)other.fix(EIOOf::toEIO), mapper);
    }

    public EIO<E, Fiber<EIO<E, ?>, A>> fork() {
        return new EIO<E, A>(this.instance.fork().map(f -> f.mapK(new FunctionK<PureIO<Void, E, ?>, EIO<E, ?>>(this){

            public <T> EIO<E, T> apply(Kind<PureIO<Void, E, ?>, ? extends T> from) {
                return new EIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })));
    }

    public EIO<E, A> timeout(Duration duration) {
        return this.timeout(Future.DEFAULT_EXECUTOR, duration);
    }

    public EIO<E, A> timeout(Executor executor, Duration duration) {
        return EIO.racePair(executor, this, EIO.sleep(duration)).flatMap(either -> (Kind)either.fold(ta -> ((EIO)((Fiber)ta.get2()).cancel().fix(EIOOf::toEIO)).map(x -> ta.get1()), tb -> ((EIO)((Fiber)tb.get1()).cancel().fix(EIOOf::toEIO)).flatMap(x -> EIO.throwError(new TimeoutException()))));
    }

    public EIO<E, A> repeat() {
        return this.repeat(1);
    }

    public EIO<E, A> repeat(int times) {
        return new EIO<E, A>(this.instance.repeat(times));
    }

    public EIO<E, A> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public EIO<E, A> repeat(Duration delay, int times) {
        return new EIO<E, A>(this.instance.repeat(delay, times));
    }

    public EIO<E, A> retry() {
        return this.retry(1);
    }

    public EIO<E, A> retry(int maxRetries) {
        return new EIO<E, A>(this.instance.retry(maxRetries));
    }

    public EIO<E, A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public EIO<E, A> retry(Duration delay, int maxRetries) {
        return new EIO<E, A>(this.instance.retry(delay, maxRetries));
    }

    public EIO<E, Tuple2<Duration, A>> timed() {
        return new EIO<E, A>(this.instance.timed());
    }

    public static <E> EIO<E, Unit> forked(Executor executor) {
        return EIO.async(callback -> executor.execute(() -> callback.accept((Object)Try.success((Object)Either.right((Object)Unit.unit())))));
    }

    public <X extends Throwable> EIO<X, A> refineOrDie(Class<X> type) {
        return new EIO<X, A>(this.instance.refineOrDie(type));
    }

    public static <E, A, B, C> EIO<E, C> parMap2(Kind<EIO<E, ?>, ? extends A> za, Kind<EIO<E, ?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return EIO.parMap2(Future.DEFAULT_EXECUTOR, za, zb, mapper);
    }

    public static <E, A, B, C> EIO<E, C> parMap2(Executor executor, Kind<EIO<E, ?>, ? extends A> za, Kind<EIO<E, ?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return new EIO(PureIO.parMap2(executor, ((EIO)za.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance, ((EIO)zb.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance, mapper));
    }

    public static <E, A, B> EIO<E, Either<A, B>> race(Kind<EIO<E, ?>, ? extends A> fa, Kind<EIO<E, ?>, ? extends B> fb) {
        return EIO.race(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <E, A, B> EIO<E, Either<A, B>> race(Executor executor, Kind<EIO<E, ?>, ? extends A> fa, Kind<EIO<E, ?>, ? extends B> fb) {
        return EIO.racePair(executor, fa, fb).flatMap(either -> (Kind)either.fold(ta -> ((EIO)((Fiber)ta.get2()).cancel().fix(EIOOf::toEIO)).map(x -> Either.left((Object)ta.get1())), tb -> ((EIO)((Fiber)tb.get1()).cancel().fix(EIOOf::toEIO)).map(x -> Either.right((Object)tb.get2()))));
    }

    public static <E, A, B> EIO<E, Either<Tuple2<A, Fiber<EIO<E, ?>, B>>, Tuple2<Fiber<EIO<E, ?>, A>, B>>> racePair(Executor executor, Kind<EIO<E, ?>, ? extends A> fa, Kind<EIO<E, ?>, ? extends B> fb) {
        PureIO instance1 = (PureIO)((EIO)fa.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance.fix(PureIOOf::toPureIO);
        PureIO instance2 = (PureIO)((EIO)fb.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance.fix(PureIOOf::toPureIO);
        return new EIO<E, A>(PureIO.racePair(executor, instance1, instance2).map(either -> either.bimap(a -> a.map2(f -> f.mapK(new FunctionK<PureIO<Void, E, ?>, EIO<E, ?>>(){

            public <T> EIO<E, T> apply(Kind<PureIO<Void, E, ?>, ? extends T> from) {
                return new EIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })), b -> b.map1(f -> f.mapK(new FunctionK<PureIO<Void, E, ?>, EIO<E, ?>>(){

            public <T> EIO<E, T> apply(Kind<PureIO<Void, E, ?>, ? extends T> from) {
                return new EIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })))));
    }

    public static <E, A> EIO<E, A> absorb(EIO<E, Either<E, A>> value) {
        return new EIO(PureIO.absorb(value.instance));
    }

    public static <A, B> Function1<A, EIO<Throwable, B>> lift(Function1<? super A, ? extends B> function) {
        return PureIO.lift(function).andThen(EIO::new);
    }

    public static <A, B> Function1<A, EIO<Throwable, B>> liftOption(Function1<? super A, ? extends Option<? extends B>> function) {
        return value -> EIO.fromOption((Option)function.apply(value));
    }

    public static <A, B> Function1<A, EIO<Throwable, B>> liftTry(Function1<? super A, ? extends Try<? extends B>> function) {
        return value -> EIO.fromTry((Try)function.apply(value));
    }

    public static <E, A, B> Function1<A, EIO<E, B>> liftEither(Function1<? super A, ? extends Either<E, ? extends B>> function) {
        return value -> EIO.fromEither((Either)function.apply(value));
    }

    public static <A> EIO<Throwable, A> fromOption(Option<? extends A> task) {
        return EIO.fromOption(Producer.cons(task));
    }

    public static <A> EIO<Throwable, A> fromOption(Producer<Option<? extends A>> task) {
        return new EIO<Throwable, A>(PureIO.fromOption(task));
    }

    public static <A> EIO<Throwable, A> fromTry(Try<? extends A> task) {
        return EIO.fromTry(Producer.cons(task));
    }

    public static <A> EIO<Throwable, A> fromTry(Producer<Try<? extends A>> task) {
        return new EIO<Throwable, A>(PureIO.fromTry(task));
    }

    public static <E, A> EIO<E, A> fromEither(Either<E, ? extends A> task) {
        return EIO.fromEither(Producer.cons(task));
    }

    public static <E, A> EIO<E, A> fromEither(Producer<Either<E, ? extends A>> task) {
        return new EIO<E, A>(PureIO.fromEither(task));
    }

    public static <E> EIO<E, Unit> sleep(Duration delay) {
        return EIO.sleep(Future.DEFAULT_EXECUTOR, delay);
    }

    public static <E> EIO<E, Unit> sleep(Executor executor, Duration delay) {
        return new EIO(PureIO.sleep(executor, delay));
    }

    public static EIO<Throwable, Unit> exec(CheckedRunnable task) {
        return new EIO<Throwable, Unit>(PureIO.exec(task));
    }

    public static <E, A> EIO<E, A> pure(A value) {
        return new EIO(PureIO.pure(value));
    }

    public static <E, A> EIO<E, A> defer(Producer<Kind<EIO<E, ?>, ? extends A>> lazy) {
        return new EIO(PureIO.defer(() -> ((EIO)lazy.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)()).get()).instance));
    }

    public static <A> EIO<Throwable, A> task(Producer<? extends A> task) {
        return new EIO<Throwable, A>(PureIO.task(task));
    }

    public static <E, A> EIO<E, A> never() {
        return EIO.async(cb -> {});
    }

    public static <E, A> EIO<E, A> async(Consumer1<Consumer1<? super Try<? extends Either<E, ? extends A>>>> consumer) {
        return new EIO(PureIO.async((env, cb) -> consumer.accept(cb)));
    }

    public static <E, A> EIO<E, A> cancellable(Function1<Consumer1<? super Try<? extends Either<E, ? extends A>>>, EIO<E, Unit>> consumer) {
        return new EIO(PureIO.cancellable((env, cb) -> (PureIO)consumer.andThen(EIO::toPureIO).apply(cb)));
    }

    public static <E, A> EIO<E, A> raiseError(E error) {
        return new EIO(PureIO.raiseError(error));
    }

    public static <E, A> EIO<E, A> throwError(Throwable error) {
        return new EIO(PureIO.throwError(error));
    }

    public static <E, A> EIO<E, Sequence<A>> traverse(Sequence<? extends Kind<EIO<E, ?>, ? extends A>> sequence) {
        return EIO.traverse(Future.DEFAULT_EXECUTOR, sequence);
    }

    public static <E, A> EIO<E, Sequence<A>> traverse(Executor executor, Sequence<? extends Kind<EIO<E, ?>, ? extends A>> sequence) {
        return (EIO)sequence.foldLeft(EIO.pure(ImmutableList.empty()), (xs, a) -> EIO.parMap2(executor, xs, a, Sequence::append));
    }

    public static <E, A extends AutoCloseable, B> EIO<E, B> bracket(Kind<EIO<E, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<EIO<E, ?>, ? extends B>> use) {
        return new EIO(PureIO.bracket(((EIO)acquire.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance, resource -> ((EIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)()).apply((Object)resource)).instance));
    }

    public static <E, A, B> EIO<E, B> bracket(Kind<EIO<E, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<EIO<E, ?>, ? extends B>> use, Consumer1<? super A> release) {
        return new EIO(PureIO.bracket(((EIO)acquire.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance, resource -> ((EIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)()).apply((Object)resource)).instance, release));
    }

    public static <E, A, B> EIO<E, B> bracket(Kind<EIO<E, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<EIO<E, ?>, ? extends B>> use, Function1<? super A, ? extends Kind<EIO<E, ?>, Unit>> release) {
        return new EIO(PureIO.bracket(((EIO)acquire.fix((Function<Kind, EIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)())).instance, resource -> ((EIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toEIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.EIO<E, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/EIO;)()).apply((Object)resource)).instance, release.andThen(EIOOf::toEIO).andThen(EIO::toPureIO)));
    }

    public static <E> EIO<E, Unit> unit() {
        return UNIT;
    }
}

