/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.effect.ManagedOf;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.type.Either;
import java.time.Duration;

@HigherKind
public final class Managed<R, E, A>
implements ManagedOf<R, E, A> {
    private final PureIO<R, E, Tuple2<A, Consumer1<? super A>>> resource;

    private Managed(PureIO<R, E, Tuple2<A, Consumer1<? super A>>> resource) {
        this.resource = (PureIO)Precondition.checkNonNull(resource);
    }

    public <B> Managed<R, E, B> map(Function1<? super A, ? extends B> mapper) {
        return this.flatMap(a -> Managed.pure(PureIO.pure(mapper.apply(a))));
    }

    public <F> Managed<R, F, A> mapError(Function1<? super E, ? extends F> mapper) {
        return new Managed<R, F, A>(this.resource.mapError(mapper));
    }

    public <B> Managed<R, E, B> flatMap(Function1<? super A, ? extends Kind<Managed<R, E, ?>, ? extends B>> mapper) {
        Effect result = this.resource.flatMap(t -> {
            Managed apply = ManagedOf.toManaged((Kind)mapper.apply(t.get1()));
            return apply.resource.map(r -> r.map2(ignore -> Managed.releaseAndThen(t, r)));
        });
        return new Managed<R, E, A>(result);
    }

    public <F> Managed<R, F, A> flatMapError(Function1<? super E, ? extends Kind<Managed<R, F, ?>, ? extends A>> mapper) {
        return new Managed(this.resource.flatMapError(e -> ManagedOf.toManaged((Kind)mapper.apply((Object)e)).resource));
    }

    public <B> Managed<R, E, B> andThen(Kind<Managed<A, E, ?>, B> other) {
        Effect flatMap = this.resource.flatMap(a -> {
            Either next = ManagedOf.toManaged(other).resource.provide(a.get1());
            return PureIO.fromEither(() -> next.map(t -> t.map2(ignore -> Managed.releaseAndThen(a, t))));
        });
        return new Managed<R, E, A>(flatMap);
    }

    public <B> PureIO<R, E, B> use(Function1<? super A, ? extends PureIO<R, E, ? extends B>> use) {
        return PureIO.bracket(this.resource, a -> (Kind)use.apply(a.get1()), Managed.release());
    }

    public <B> Managed<R, Void, B> fold(Function1<? super E, ? extends B> mapError, Function1<? super A, ? extends B> mapper) {
        return this.foldM(mapError.andThen(Managed::pure), mapper.andThen(Managed::pure));
    }

    public Managed<R, Void, A> recover(Function1<? super E, ? extends A> mapError) {
        return this.fold(mapError, Function1.identity());
    }

    public Managed<R, E, A> orElse(Managed<R, E, ? extends A> other) {
        return this.foldM(Function1.cons(other), Function1.cons((Object)this));
    }

    public <F, B> Managed<R, F, B> foldM(Function1<? super E, ? extends Kind<Managed<R, F, ?>, ? extends B>> mapError, Function1<? super A, ? extends Kind<Managed<R, F, ?>, ? extends B>> mapper) {
        PureIO foldM = this.resource.foldM(error -> ManagedOf.toManaged((Kind)mapError.apply((Object)error)).resource, a -> ManagedOf.toManaged((Kind)mapper.apply((Object)a.get1())).resource.map(b -> b.map2(ignore -> Managed.releaseAndThen(a, b))));
        return new Managed(foldM);
    }

    public <B> Managed<R, E, Tuple2<A, B>> combine(Managed<R, E, B> other) {
        return new Managed(PureIO.bracket(this.resource, t -> PureIO.bracket(other.resource, r -> PureIO.pure(Tuple.of((Object)Tuple.of((Object)t.get1(), (Object)r.get1()), (Object)Consumer1.noop())), Managed.release()), Managed.release()));
    }

    public <B> Managed<R, E, Either<A, B>> either(Managed<R, E, B> other) {
        PureIO foldM = this.resource.foldM(error -> other.resource.map(Either::right), success -> PureIO.pure(Either.left((Object)success)));
        return new Managed<R, E, A>(foldM.map(e -> (Tuple2)e.fold(a -> a.map(Either::left, x -> either -> Managed.release().accept(a)), b -> b.map(Either::right, y -> either -> Managed.release().accept(b)))));
    }

    public Managed<R, E, A> retry() {
        return this.retry(1);
    }

    public Managed<R, E, A> retry(int maxRetries) {
        return new Managed<R, E, A>(this.resource.retry(maxRetries));
    }

    public Managed<R, E, A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public Managed<R, E, A> retry(Duration delay, int maxRetries) {
        return new Managed<R, E, A>(this.resource.retry(delay, maxRetries));
    }

    public Managed<R, E, Tuple2<Duration, A>> timed() {
        return new Managed<R, E, A>(this.resource.timed().map(tt -> Tuple.of((Object)Tuple.of((Object)((Duration)tt.get1()), (Object)((Tuple2)tt.get2()).get1()), t -> ((Consumer1)((Tuple2)tt.get2()).get2()).accept(t.get2()))));
    }

    public static <R, E, A> Managed<R, E, A> pure(A resource) {
        return Managed.pure(PureIO.pure(resource));
    }

    public static <R, E, A> Managed<R, E, A> pure(PureIO<R, E, ? extends A> resource) {
        return Managed.from(resource, Consumer1.noop());
    }

    public static <R, E, A extends AutoCloseable> Managed<R, E, A> from(PureIO<R, E, ? extends A> resource) {
        return Managed.from(resource, AutoCloseable::close);
    }

    public static <R, E, A> Managed<R, E, A> from(PureIO<R, E, ? extends A> resource, Consumer1<? super A> release) {
        return new Managed<R, E, A>(resource.map(a -> Tuple.of((Object)a, (Object)release)));
    }

    public static <R, E, A extends AutoCloseable> Managed<R, E, A> from(Function1<? super R, ? extends A> mapper) {
        return Managed.from(mapper, AutoCloseable::close);
    }

    public static <R, E, A> Managed<R, E, A> from(Function1<? super R, ? extends A> mapper, Consumer1<? super A> release) {
        return new Managed<R, E, A>(PureIO.access(mapper).map(y -> Tuple.of((Object)y, (Object)release)));
    }

    public static <R, E, A extends AutoCloseable> Managed<R, E, A> fromM(Function1<? super R, ? extends PureIO<R, E, ? extends A>> mapper) {
        return Managed.fromM(mapper, AutoCloseable::close);
    }

    public static <R, E, A> Managed<R, E, A> fromM(Function1<? super R, ? extends PureIO<R, E, ? extends A>> mapper, Consumer1<? super A> release) {
        return new Managed<R, E, A>(PureIO.accessM(mapper).map(y -> Tuple.of((Object)y, (Object)release)));
    }

    private static <X, T, R> Consumer1<X> releaseAndThen(Tuple2<T, Consumer1<? super T>> outter, Tuple2<R, Consumer1<? super R>> inner) {
        return ignore -> {
            try {
                Managed.release().accept((Object)inner);
            }
            finally {
                Managed.release().accept((Object)outter);
            }
        };
    }

    private static <T> Consumer1<Tuple2<T, Consumer1<? super T>>> release() {
        return t -> ((Consumer1)t.get2()).accept(t.get1());
    }
}

