/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.Promise;
import com.github.tonivade.purefun.core.CheckedRunnable;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Consumer2;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.effect.CallStack;
import com.github.tonivade.purefun.effect.Managed;
import com.github.tonivade.purefun.effect.PureIOConnection;
import com.github.tonivade.purefun.effect.PureIOOf;
import com.github.tonivade.purefun.effect.RIO;
import com.github.tonivade.purefun.effect.StateIO;
import com.github.tonivade.purefun.effect.URIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.EitherOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Fiber;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@HigherKind
public sealed interface PureIO<R, E, A>
extends PureIOOf<R, E, A>,
Effect<PureIO<R, E, ?>, A> {
    public static final PureIO<?, ?, Unit> UNIT = PureIO.pure(Unit.unit());

    default public Either<E, A> provide(@Nullable R env) {
        return (Either)this.runAsync(env).getOrElseThrow();
    }

    default public Future<Either<E, A>> runAsync(@Nullable R env) {
        return Future.from(PureIO.runAsync(env, this, PureIOConnection.UNCANCELLABLE));
    }

    default public Future<Either<E, A>> runAsync(@Nullable R env, Executor executor) {
        return PureIO.forked(executor).andThen(this).runAsync(env);
    }

    default public void provideAsync(@Nullable R env, Consumer1<? super Try<? extends Either<E, A>>> callback) {
        this.runAsync(env).onComplete(callback);
    }

    default public void provideAsync(@Nullable R env, Executor executor, Consumer1<? super Try<? extends Either<E, A>>> callback) {
        this.runAsync(env, executor).onComplete(callback);
    }

    default public PureIO<R, A, E> swap() {
        return this.foldM(PureIO::pure, PureIO::raiseError);
    }

    default public <B> PureIO<R, E, B> map(Function1<? super A, ? extends B> map) {
        return this.flatMap(map.andThen(PureIO::pure));
    }

    default public <B> PureIO<R, B, A> mapError(Function1<? super E, ? extends B> map) {
        return this.flatMapError(map.andThen(PureIO::raiseError));
    }

    default public <B, F> PureIO<R, F, B> bimap(Function1<? super E, ? extends F> mapError, Function1<? super A, ? extends B> map) {
        return this.foldM(mapError.andThen(PureIO::raiseError), map.andThen(PureIO::pure));
    }

    default public <B> PureIO<R, E, B> flatMap(Function1<? super A, ? extends Kind<PureIO<R, E, ?>, ? extends B>> map) {
        return this.foldM(PureIO::raiseError, map);
    }

    default public <F> PureIO<R, F, A> flatMapError(Function1<? super E, ? extends Kind<PureIO<R, F, ?>, ? extends A>> map) {
        return this.foldM(map, PureIO::pure);
    }

    default public <F, B> PureIO<R, F, B> foldM(Function1<? super E, ? extends Kind<PureIO<R, F, ?>, ? extends B>> left, Function1<? super A, ? extends Kind<PureIO<R, F, ?>, ? extends B>> right) {
        return new FlatMapped(this, left, right);
    }

    default public <B> PureIO<R, E, B> andThen(Kind<PureIO<R, E, ?>, ? extends B> next) {
        return this.flatMap(ignore -> next);
    }

    default public <B> PureIO<R, E, B> ap(Kind<PureIO<R, E, ?>, ? extends Function1<? super A, ? extends B>> apply) {
        return PureIO.parMap2(this, (Kind)apply.fix(PureIOOf::toPureIO), (v, a) -> a.apply(v));
    }

    default public <B> URIO<R, B> fold(Function1<? super E, ? extends B> mapError, Function1<? super A, ? extends B> map) {
        return new URIO<R, B>(this.foldM(mapError.andThen(PureIO::pure), map.andThen(PureIO::pure)));
    }

    default public URIO<R, A> recover(Function1<? super E, ? extends A> mapError) {
        return this.fold(mapError, Function1.identity());
    }

    default public PureIO<R, E, A> orElse(Kind<PureIO<R, E, ?>, ? extends A> other) {
        return this.foldM(Function1.cons(other), Function1.cons((Object)this));
    }

    default public <B> PureIO<R, E, Tuple2<A, B>> zip(Kind<PureIO<R, E, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Tuple::of);
    }

    default public <B> PureIO<R, E, A> zipLeft(Kind<PureIO<R, E, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.first());
    }

    default public <B> PureIO<R, E, B> zipRight(Kind<PureIO<R, E, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.second());
    }

    default public <B, C> PureIO<R, E, C> zipWith(Kind<PureIO<R, E, ?>, ? extends B> other, Function2<? super A, ? super B, ? extends C> mapper) {
        return PureIO.parMap2(this, (Kind)other.fix(PureIOOf::toPureIO), mapper);
    }

    default public PureIO<R, E, A> repeat() {
        return this.repeat(1);
    }

    default public PureIO<R, E, A> repeat(int times) {
        return PureIO.repeat(this, PureIO.unit(), times);
    }

    default public PureIO<R, E, A> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    default public PureIO<R, E, A> repeat(Duration delay, int times) {
        return PureIO.repeat(this, PureIO.sleep(delay), times);
    }

    default public PureIO<R, E, A> retry() {
        return this.retry(1);
    }

    default public PureIO<R, E, A> retry(int maxRetries) {
        return PureIO.retry(this, PureIO.unit(), maxRetries);
    }

    default public PureIO<R, E, A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    default public PureIO<R, E, A> retry(Duration delay, int maxRetries) {
        return PureIO.retry(this, PureIO.sleep(delay), maxRetries);
    }

    default public PureIO<R, E, Tuple2<Duration, A>> timed() {
        return PureIO.later(System::nanoTime).flatMap(start -> this.map(result -> Tuple.of((Object)Duration.ofNanos(System.nanoTime() - start), (Object)result)));
    }

    default public PureIO<R, E, Fiber<PureIO<R, E, ?>, A>> fork() {
        return PureIO.async((env, callback) -> {
            PureIOConnection connection = PureIOConnection.cancellable();
            Promise<Either<E, A>> promise = PureIO.runAsync(env, this, connection);
            PureIO<R, E, A> join = PureIO.fromPromise(promise);
            PureIO<R, E, Unit> cancel = PureIO.run(connection::cancel);
            callback.accept((Object)Try.success((Object)Either.right((Object)Fiber.of(join, cancel))));
        });
    }

    default public PureIO<R, E, A> timeout(Duration duration) {
        return this.timeout(Future.DEFAULT_EXECUTOR, duration);
    }

    default public PureIO<R, E, A> timeout(Executor executor, Duration duration) {
        return PureIO.racePair(executor, this, PureIO.sleep(duration)).flatMap(either -> (Kind)either.fold(ta -> ((PureIO)((Fiber)ta.get2()).cancel().fix(PureIOOf::toPureIO)).map(x -> ta.get1()), tb -> ((PureIO)((Fiber)tb.get1()).cancel().fix(PureIOOf::toPureIO)).flatMap(x -> PureIO.throwError(new TimeoutException()))));
    }

    default public <X extends Throwable> PureIO<R, X, A> refineOrDie(Class<X> type) {
        return this.flatMapError(error -> {
            if (type.isAssignableFrom(error.getClass())) {
                return PureIO.raiseError((Throwable)error);
            }
            return PureIO.throwError(new ClassCastException(String.valueOf(error.getClass()) + " not asignable to " + String.valueOf(type)));
        });
    }

    default public URIO<R, A> toURIO() {
        return new URIO<R, A>(this.mapError(error -> {
            if (error instanceof Throwable) {
                Throwable throwable = (Throwable)error;
                throw throwable;
            }
            throw new ClassCastException(String.valueOf(error.getClass()) + " is not throwable");
        }));
    }

    default public RIO<R, A> toRIO() {
        return new RIO<R, A>(this.refineOrDie(Throwable.class));
    }

    default public Managed<R, E, A> toManaged() {
        return Managed.pure(this);
    }

    default public Managed<R, E, A> toManaged(Consumer1<? super A> release) {
        return Managed.from(this, release);
    }

    public static <R, E, A> PureIO<R, E, A> accessM(Function1<? super R, ? extends Kind<PureIO<R, E, ?>, ? extends A>> map) {
        return new AccessM(value -> (Kind)((Kind)map.apply(value)).fix(PureIOOf::toPureIO));
    }

    public static <R, E, A> PureIO<R, E, A> access(Function1<? super R, ? extends A> map) {
        return PureIO.accessM(map.andThen(PureIO::pure));
    }

    public static <R, E> PureIO<R, E, R> env() {
        return PureIO.access(Function1.identity());
    }

    public static <R, E> PureIO<R, E, Unit> forked(Executor executor) {
        return PureIO.async((env, callback) -> executor.execute(() -> callback.accept((Object)Try.success((Object)Either.right((Object)Unit.unit())))));
    }

    public static <R, E, A, B, C> PureIO<R, E, C> parMap2(Kind<PureIO<R, E, ?>, ? extends A> za, Kind<PureIO<R, E, ?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return PureIO.parMap2(Future.DEFAULT_EXECUTOR, za, zb, mapper);
    }

    public static <R, E, A, B, C> PureIO<R, E, C> parMap2(Executor executor, Kind<PureIO<R, E, ?>, ? extends A> za, Kind<PureIO<R, E, ?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return PureIO.cancellable((env, callback) -> {
            PureIOConnection connection1 = PureIOConnection.cancellable();
            PureIOConnection connection2 = PureIOConnection.cancellable();
            Promise promiseA = PureIO.runAsync(env, PureIO.forked(executor).andThen(za), connection1);
            Promise promiseB = PureIO.runAsync(env, PureIO.forked(executor).andThen(zb), connection2);
            promiseA.onComplete(a -> promiseB.onComplete(b -> callback.accept((Object)Try.map2((Try)a, (Try)b, (e1, e2) -> EitherOf.toEither((Kind)Either.map2((Either)e1, (Either)e2, (Function2)mapper))))));
            return PureIO.exec(() -> {
                try {
                    connection1.cancel();
                }
                finally {
                    connection2.cancel();
                }
            });
        });
    }

    public static <R, E, A, B> PureIO<R, E, Either<A, B>> race(Kind<PureIO<R, E, ?>, ? extends A> fa, Kind<PureIO<R, E, ?>, ? extends B> fb) {
        return PureIO.race(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <R, E, A, B> PureIO<R, E, Either<A, B>> race(Executor executor, Kind<PureIO<R, E, ?>, ? extends A> fa, Kind<PureIO<R, E, ?>, ? extends B> fb) {
        return PureIO.racePair(executor, fa, fb).flatMap(either -> (Kind)either.fold(ta -> ((PureIO)((Fiber)ta.get2()).cancel().fix(PureIOOf::toPureIO)).map(x -> Either.left((Object)ta.get1())), tb -> ((PureIO)((Fiber)tb.get1()).cancel().fix(PureIOOf::toPureIO)).map(x -> Either.right((Object)tb.get2()))));
    }

    public static <R, E, A, B> PureIO<R, E, Either<Tuple2<A, Fiber<PureIO<R, E, ?>, B>>, Tuple2<Fiber<PureIO<R, E, ?>, A>, B>>> racePair(Executor executor, Kind<PureIO<R, E, ?>, ? extends A> fa, Kind<PureIO<R, E, ?>, ? extends B> fb) {
        return PureIO.cancellable((env, callback) -> {
            PureIOConnection connection1 = PureIOConnection.cancellable();
            PureIOConnection connection2 = PureIOConnection.cancellable();
            Promise promiseA = PureIO.runAsync(env, PureIO.forked(executor).andThen(fa), connection1);
            Promise promiseB = PureIO.runAsync(env, PureIO.forked(executor).andThen(fb), connection2);
            promiseA.onComplete(result -> {
                PureIO fromPromiseB = PureIO.fromPromise(promiseB);
                PureIO cancelB = PureIO.run(connection2::cancel);
                Fiber fiberB = Fiber.of(fromPromiseB, cancelB);
                callback.accept((Object)result.map(either -> either.map(a -> Either.left((Object)Tuple.of((Object)a, (Object)fiberB)))));
            });
            promiseB.onComplete(result -> {
                PureIO fromPromiseA = PureIO.fromPromise(promiseA);
                PureIO cancelA = PureIO.run(connection2::cancel);
                Fiber fiberA = Fiber.of(fromPromiseA, cancelA);
                callback.accept((Object)result.map(either -> either.map(b -> Either.right((Object)Tuple.of((Object)fiberA, (Object)b)))));
            });
            return PureIO.exec(() -> {
                try {
                    connection1.cancel();
                }
                finally {
                    connection2.cancel();
                }
            });
        });
    }

    public static <R, E, A> PureIO<R, E, A> absorb(Kind<PureIO<R, E, ?>, Either<E, A>> value) {
        return ((PureIO)value.fix(PureIOOf::toPureIO)).flatMap(either -> (Kind)either.fold(PureIO::raiseError, PureIO::pure));
    }

    public static <R, A, B> Function1<A, PureIO<R, Throwable, B>> lift(Function1<? super A, ? extends B> function) {
        return value -> PureIO.pure(function.apply(value));
    }

    public static <R, A, B> Function1<A, PureIO<R, Throwable, B>> liftOption(Function1<? super A, ? extends Option<? extends B>> function) {
        return value -> PureIO.fromOption((Option)function.apply(value));
    }

    public static <R, A, B> Function1<A, PureIO<R, Throwable, B>> liftTry(Function1<? super A, ? extends Try<? extends B>> function) {
        return value -> PureIO.fromTry((Try)function.apply(value));
    }

    public static <R, E, A, B> Function1<A, PureIO<R, E, B>> liftEither(Function1<? super A, ? extends Either<E, ? extends B>> function) {
        return value -> PureIO.fromEither((Either)function.apply(value));
    }

    public static <R, A> PureIO<R, Throwable, A> fromOption(Option<? extends A> task) {
        return PureIO.fromOption(Producer.cons(task));
    }

    public static <R, A> PureIO<R, Throwable, A> fromOption(Producer<Option<? extends A>> task) {
        return PureIO.fromEither(task.andThen(Option::toEither));
    }

    public static <R, A> PureIO<R, Throwable, A> fromTry(Try<? extends A> task) {
        return PureIO.fromTry(Producer.cons(task));
    }

    public static <R, A> PureIO<R, Throwable, A> fromTry(Producer<Try<? extends A>> task) {
        return PureIO.fromEither(task.andThen(Try::toEither));
    }

    public static <R, E, A> PureIO<R, E, A> fromEither(Either<E, ? extends A> task) {
        return PureIO.fromEither(Producer.cons(task));
    }

    public static <R, E, A> PureIO<R, E, A> fromEither(Producer<Either<E, ? extends A>> task) {
        return new Delay(task);
    }

    public static <R, E, A> PureIO<R, E, A> fromPromise(Promise<? extends Either<E, ? extends A>> promise) {
        Consumer1 callback = arg_0 -> promise.onComplete(arg_0);
        return PureIO.async((env, cb) -> callback.accept(cb));
    }

    public static <R> PureIO<R, Throwable, Unit> exec(CheckedRunnable task) {
        return new Attempt(task.asProducer());
    }

    public static <R, E> PureIO<R, E, Unit> run(Runnable task) {
        return PureIO.fromEither(() -> {
            task.run();
            return Either.right((Object)Unit.unit());
        });
    }

    public static <R, E, A> PureIO<R, E, A> pure(A value) {
        return new Pure(value);
    }

    public static <R, E, A> PureIO<R, E, A> defer(Producer<Kind<PureIO<R, E, ?>, ? extends A>> lazy) {
        return new Suspend(() -> (Kind)((Kind)lazy.get()).fix(PureIOOf::toPureIO));
    }

    public static <R, A> PureIO<R, Throwable, A> task(Producer<? extends A> task) {
        return new Attempt(task);
    }

    public static <R, E, A> PureIO<R, E, A> later(Producer<? extends A> task) {
        return PureIO.fromEither(task.andThen(Either::right));
    }

    public static <R, E, A> PureIO<R, E, A> never() {
        return PureIO.async((env, cb) -> {});
    }

    public static <R, E, A> PureIO<R, E, A> async(Consumer2<R, Consumer1<? super Try<? extends Either<E, ? extends A>>>> consumer) {
        return PureIO.cancellable(consumer.asFunction().andThen(PureIO::pure));
    }

    public static <R, E, A> PureIO<R, E, A> cancellable(Function2<R, Consumer1<? super Try<? extends Either<E, ? extends A>>>, PureIO<R, ?, Unit>> consumer) {
        return new Async(consumer);
    }

    public static <R, E, A> PureIO<R, E, A> raiseError(E error) {
        return new Failure(error);
    }

    public static <R, E, A> PureIO<R, E, A> throwError(Throwable error) {
        return new Throw(error);
    }

    public static <R, A> PureIO<R, Throwable, A> redeem(Kind<PureIO<R, Void, ?>, ? extends A> value) {
        return new Recover((PureIO)value.fix(PureIOOf::toPureIO), PartialFunction1.of((Matcher1)Matcher1.always(), PureIO::raiseError));
    }

    public static <R, E> PureIO<R, E, Unit> sleep(Duration delay) {
        return PureIO.sleep(Future.DEFAULT_EXECUTOR, delay);
    }

    public static <R, E> PureIO<R, E, Unit> sleep(Executor executor, Duration delay) {
        return PureIO.cancellable((env, callback) -> {
            Future sleep = Future.sleep((Executor)executor, (Duration)delay).onComplete(result -> callback.accept((Object)Try.success((Object)Either.right((Object)Unit.unit()))));
            return PureIO.exec(() -> sleep.cancel(true));
        });
    }

    public static <R, E, A> PureIO<R, E, Sequence<A>> traverse(Sequence<? extends Kind<PureIO<R, E, ?>, A>> sequence) {
        return PureIO.traverse(Future.DEFAULT_EXECUTOR, sequence);
    }

    public static <R, E, A> PureIO<R, E, Sequence<A>> traverse(Executor executor, Sequence<? extends Kind<PureIO<R, E, ?>, A>> sequence) {
        return (PureIO)sequence.foldLeft(PureIO.pure(ImmutableList.empty()), (xs, a) -> PureIO.parMap2(executor, xs, a, Sequence::append));
    }

    public static <R, E, A extends AutoCloseable, B> PureIO<R, E, B> bracket(Kind<PureIO<R, E, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<PureIO<R, E, ?>, ? extends B>> use) {
        return PureIO.bracket(acquire, use, AutoCloseable::close);
    }

    public static <R, E, A, B> PureIO<R, E, B> bracket(Kind<PureIO<R, E, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<PureIO<R, E, ?>, ? extends B>> use, Consumer1<? super A> release) {
        return PureIO.bracket(acquire, use, release.asFunction().andThen(PureIO::pure));
    }

    public static <R, E, A, B> PureIO<R, E, B> bracket(Kind<PureIO<R, E, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<PureIO<R, E, ?>, ? extends B>> use, Function1<? super A, ? extends Kind<PureIO<R, E, ?>, Unit>> release) {
        return PureIO.cancellable((env, callback) -> {
            PureIOConnection cancellable = PureIOConnection.cancellable();
            Promise promise = PureIO.runAsync(env, (PureIO)acquire.fix(PureIOOf::toPureIO), cancellable);
            promise.onFailure(e -> callback.accept((Object)Try.failure((Throwable)e))).onSuccess(either -> either.fold(error -> {
                callback.accept((Object)Try.success((Object)Either.left((Object)error)));
                return Unit.unit();
            }, resource -> {
                Promise runAsync = PureIO.runAsync(env, (PureIO)((Kind)use.apply(resource)).fix(PureIOOf::toPureIO), cancellable);
                runAsync.onFailure(e -> callback.accept((Object)Try.failure((Throwable)e))).onSuccess(result -> {
                    Promise run = PureIO.runAsync(env, (PureIO)((Kind)release.apply(resource)).fix(PureIOOf::toPureIO), cancellable);
                    run.onComplete(ignore -> result.fold(error -> {
                        callback.accept((Object)Try.success((Object)Either.left((Object)error)));
                        return Unit.unit();
                    }, b -> {
                        callback.accept((Object)Try.success((Object)Either.right((Object)b)));
                        return Unit.unit();
                    }));
                });
                return Unit.unit();
            }));
            return PureIO.run(cancellable::cancel);
        });
    }

    public static <R, E> PureIO<R, E, Unit> unit() {
        return UNIT;
    }

    private static <R, E, A> Promise<Either<E, A>> runAsync(@Nullable R env, PureIO<R, E, A> current, PureIOConnection connection) {
        return PureIO.runAsync(env, current, connection, new CallStack(), Promise.make());
    }

    private static <R, E, F, G, A, B, C> Promise<Either<E, A>> runAsync(@Nullable R env, Kind<PureIO<R, E, ?>, A> current, PureIOConnection connection, CallStack<R, E, A> stack, Promise<Either<E, A>> promise) {
        while (true) {
            try {
                while (true) {
                    if ((current = PureIO.unwrap(env, current, stack, Function1.identity())) instanceof Pure) {
                        Pure pure = (Pure)current;
                        return promise.succeeded((Object)Either.right(pure.value));
                    }
                    if (current instanceof Failure) {
                        Failure failure = (Failure)current;
                        return promise.succeeded((Object)Either.left(failure.error));
                    }
                    if (current instanceof Async) {
                        Async async = (Async)current;
                        return PureIO.executeAsync(env, async, connection, promise);
                    }
                    if (current instanceof FlatMapped) {
                        stack.push();
                        FlatMapped flatMapped = (FlatMapped)current;
                        Kind source = PureIO.unwrap(env, flatMapped.current, stack, b -> ((PureIO)b.fix(PureIOOf::toPureIO)).foldM(flatMapped.nextError, flatMapped.next));
                        if (source instanceof Async) {
                            Async async = (Async)source;
                            Promise nextPromise = Promise.make();
                            nextPromise.then(either -> {
                                PureIO fold = (PureIO)either.fold(error -> (PureIO)((Kind)flatMapped.nextError.apply(error)).fix(PureIOOf::toPureIO), value -> (PureIO)((Kind)flatMapped.next.apply(value)).fix(PureIOOf::toPureIO));
                                PureIO.runAsync(env, fold, connection, stack, promise);
                            });
                            PureIO.executeAsync(env, async, connection, nextPromise);
                            return promise;
                        }
                        if (source instanceof Pure) {
                            Pure pure = (Pure)source;
                            current = (Kind)((Kind)flatMapped.next.apply(pure.value)).fix(PureIOOf::toPureIO);
                            continue;
                        }
                        if (source instanceof Failure) {
                            Failure failure = (Failure)source;
                            current = (Kind)((Kind)flatMapped.nextError.apply(failure.error)).fix(PureIOOf::toPureIO);
                            continue;
                        }
                        if (!(source instanceof FlatMapped)) continue;
                        FlatMapped flatMapped2 = (FlatMapped)source;
                        current = ((PureIO)flatMapped2.current.fix(PureIOOf::toPureIO)).foldM(e -> ((PureIO)((Kind)flatMapped2.nextError.apply(e)).fix(PureIOOf::toPureIO)).foldM(flatMapped.nextError, flatMapped.next), a -> ((PureIO)((Kind)flatMapped2.next.apply(a)).fix(PureIOOf::toPureIO)).foldM(flatMapped.nextError, flatMapped.next));
                        continue;
                    }
                    stack.pop();
                }
            }
            catch (Throwable error) {
                Option<PureIO<R, E, A>> result = stack.tryHandle(error);
                if (result.isPresent()) {
                    current = (PureIO<R, F, B>)result.getOrElseThrow();
                    continue;
                }
                return promise.failed(error);
            }
            break;
        }
    }

    private static <R, E, F, A, B> Kind<PureIO<R, E, ?>, A> unwrap(@Nullable R env, Kind<PureIO<R, E, ?>, A> current, CallStack<R, F, B> stack, Function1<Kind<PureIO<R, E, ?>, ? extends A>, Kind<PureIO<R, F, ?>, ? extends B>> next) {
        while (true) {
            if (current instanceof Failure) {
                return current;
            }
            if (current instanceof Pure) {
                return current;
            }
            if (current instanceof FlatMapped) {
                return current;
            }
            if (current instanceof Async) {
                return current;
            }
            if (current instanceof Throw) {
                Throw throwError = (Throw)current;
                return (Kind)stack.sneakyThrow(throwError.error);
            }
            if (current instanceof Recover) {
                Recover recover = (Recover)current;
                stack.add(recover.mapper.andThen(next));
                current = recover.current;
                continue;
            }
            if (current instanceof AccessM) {
                AccessM accessM = (AccessM)current;
                current = PureIO.accessM(env, accessM);
                continue;
            }
            if (!(current instanceof Suspend)) break;
            Suspend suspend = (Suspend)current;
            current = (Kind)((Kind)suspend.lazy.get()).fix(PureIOOf::toPureIO);
        }
        if (current instanceof Delay) {
            Delay delay = (Delay)current;
            Either value = (Either)delay.task.get();
            return (Kind)value.fold(PureIO::raiseError, PureIO::pure);
        }
        if (current instanceof Attempt) {
            Attempt attempt = (Attempt)current;
            Either either = (Either)attempt.current.liftEither().get();
            return (Kind)either.fold(PureIO::raiseError, PureIO::pure);
        }
        throw new IllegalStateException("not supported: " + String.valueOf(current));
    }

    public static <R, E, A> Kind<PureIO<R, E, ?>, A> accessM(@Nullable R env, AccessM<R, E, A> accessM) {
        return (Kind)((Kind)accessM.function.apply(env)).fix(PureIOOf::toPureIO);
    }

    private static <R, E, A> Promise<Either<E, A>> executeAsync(@Nullable R env, Async<R, E, A> current, PureIOConnection connection, Promise<Either<E, A>> promise) {
        if (connection.isCancellable() && !connection.updateState((Operator1<StateIO>)((Operator1)StateIO::startingNow)).isRunnable()) {
            return promise.cancel();
        }
        PureIO.setCancelToken(env, current, connection, promise);
        promise.thenRun(() -> connection.setCancelToken(UNIT));
        if (connection.isCancellable() && connection.updateState((Operator1<StateIO>)((Operator1)StateIO::notStartingNow)).isCancellingNow()) {
            connection.cancelNow();
        }
        return promise;
    }

    private static <R, E, A> void setCancelToken(@Nullable R env, Async<R, E, A> current, PureIOConnection connection, Promise<Either<E, A>> promise) {
        connection.setCancelToken((PureIO)current.callback.apply(env, result -> promise.tryComplete(result.map(EitherOf::toEither))));
    }

    private static <R, E, A> PureIO<R, E, A> repeat(PureIO<R, E, A> self, PureIO<R, E, Unit> pause, int times) {
        return self.foldM(PureIO::raiseError, value -> {
            if (times > 0) {
                return pause.andThen(PureIO.repeat(self, pause, times - 1));
            }
            return PureIO.pure(value);
        });
    }

    private static <R, E, A> PureIO<R, E, A> retry(PureIO<R, E, A> self, PureIO<R, E, Unit> pause, int maxRetries) {
        return self.foldM(error -> {
            if (maxRetries > 0) {
                return pause.andThen(PureIO.retry(self, pause.repeat(), maxRetries - 1));
            }
            return PureIO.raiseError(error);
        }, PureIO::pure);
    }

    public static final class FlatMapped<R, E, A, F, B>
    implements PureIO<R, F, B> {
        private final Kind<PureIO<R, E, ?>, A> current;
        private final Function1<? super E, ? extends Kind<PureIO<R, F, ?>, ? extends B>> nextError;
        private final Function1<? super A, ? extends Kind<PureIO<R, F, ?>, ? extends B>> next;

        private FlatMapped(PureIO<R, E, A> current, Function1<? super E, ? extends Kind<PureIO<R, F, ?>, ? extends B>> nextError, Function1<? super A, ? extends Kind<PureIO<R, F, ?>, ? extends B>> next) {
            this.current = (Kind)Precondition.checkNonNull(current);
            this.nextError = (Function1)Precondition.checkNonNull(nextError);
            this.next = (Function1)Precondition.checkNonNull(next);
        }

        public String toString() {
            return "FlatMapped(" + String.valueOf(this.current) + ", ?, ?)";
        }
    }

    public static final class AccessM<R, E, A>
    implements PureIO<R, E, A> {
        private final Function1<? super R, ? extends Kind<PureIO<R, E, ?>, ? extends A>> function;

        private AccessM(Function1<? super R, ? extends Kind<PureIO<R, E, ?>, ? extends A>> function) {
            this.function = (Function1)Precondition.checkNonNull(function);
        }

        public String toString() {
            return "AccessM(?)";
        }
    }

    public static final class Delay<R, E, A>
    implements PureIO<R, E, A> {
        private final Producer<Either<E, ? extends A>> task;

        private Delay(Producer<Either<E, ? extends A>> task) {
            this.task = (Producer)Precondition.checkNonNull(task);
        }

        public String toString() {
            return "Delay(?)";
        }
    }

    public static final class Attempt<R, E, A>
    implements PureIO<R, E, A> {
        private final Producer<? extends A> current;

        private Attempt(Producer<? extends A> current) {
            this.current = (Producer)Precondition.checkNonNull(current);
        }

        public String toString() {
            return "Attempt(" + String.valueOf(this.current) + ")";
        }
    }

    public static final class Pure<R, E, A>
    implements PureIO<R, E, A> {
        private final A value;

        private Pure(A value) {
            this.value = Precondition.checkNonNull(value);
        }

        public String toString() {
            return "Pure(" + String.valueOf(this.value) + ")";
        }
    }

    public static final class Suspend<R, E, A>
    implements PureIO<R, E, A> {
        private final Producer<Kind<PureIO<R, E, ?>, ? extends A>> lazy;

        private Suspend(Producer<Kind<PureIO<R, E, ?>, ? extends A>> lazy) {
            this.lazy = (Producer)Precondition.checkNonNull(lazy);
        }

        public String toString() {
            return "Suspend(?)";
        }
    }

    public static final class Async<R, E, A>
    implements PureIO<R, E, A> {
        private final Function2<R, Consumer1<? super Try<? extends Either<E, ? extends A>>>, PureIO<R, ?, Unit>> callback;

        private Async(Function2<R, Consumer1<? super Try<? extends Either<E, ? extends A>>>, PureIO<R, ?, Unit>> callback) {
            this.callback = (Function2)Precondition.checkNonNull(callback);
        }

        public String toString() {
            return "Async(?)";
        }
    }

    public static final class Failure<R, E, A>
    implements PureIO<R, E, A> {
        private final E error;

        private Failure(E error) {
            this.error = Precondition.checkNonNull(error);
        }

        public String toString() {
            return "Failure(" + String.valueOf(this.error) + ")";
        }
    }

    public static final class Throw<R, E, A>
    implements PureIO<R, E, A> {
        private final Throwable error;

        private Throw(Throwable error) {
            this.error = (Throwable)Precondition.checkNonNull((Object)error);
        }

        public String toString() {
            return "Throw(" + String.valueOf(this.error) + ")";
        }
    }

    public static final class Recover<R, E, A>
    implements PureIO<R, E, A> {
        private final PureIO<R, Void, A> current;
        private final PartialFunction1<? super Throwable, ? extends PureIO<R, E, ? extends A>> mapper;

        private Recover(PureIO<R, Void, A> current, PartialFunction1<? super Throwable, ? extends PureIO<R, E, ? extends A>> mapper) {
            this.current = (PureIO)Precondition.checkNonNull(current);
            this.mapper = (PartialFunction1)Precondition.checkNonNull(mapper);
        }

        public String toString() {
            return "Recover(" + String.valueOf(this.current) + ", ?)";
        }
    }
}

