/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.StateIO;
import java.util.concurrent.atomic.AtomicReference;

sealed interface PureIOConnection {
    public static final PureIOConnection UNCANCELLABLE = new Uncancellable();

    public boolean isCancellable();

    public void setCancelToken(PureIO<?, ?, Unit> var1);

    public void cancelNow();

    public void cancel();

    public StateIO updateState(Operator1<StateIO> var1);

    public static PureIOConnection cancellable() {
        return new Cancellable();
    }

    public static final class Cancellable
    implements PureIOConnection {
        private PureIO<?, ?, Unit> cancelToken = PureIO.UNIT;
        private final AtomicReference<StateIO> state = new AtomicReference<StateIO>(StateIO.INITIAL);

        private Cancellable() {
        }

        @Override
        public boolean isCancellable() {
            return true;
        }

        @Override
        public void setCancelToken(PureIO<?, ?, Unit> cancel) {
            this.cancelToken = (PureIO)Precondition.checkNonNull(cancel);
        }

        @Override
        public void cancelNow() {
            this.cancelToken.runAsync(null);
        }

        @Override
        public void cancel() {
            if (this.state.getAndUpdate(StateIO::cancellingNow).isCancelable()) {
                this.cancelNow();
                this.state.set(StateIO.CANCELLED);
            }
        }

        @Override
        public StateIO updateState(Operator1<StateIO> update) {
            return this.state.updateAndGet(arg_0 -> update.apply(arg_0));
        }
    }

    public static final class Uncancellable
    implements PureIOConnection {
        private Uncancellable() {
        }

        @Override
        public boolean isCancellable() {
            return false;
        }

        @Override
        public void setCancelToken(PureIO<?, ?, Unit> cancel) {
        }

        @Override
        public void cancelNow() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public StateIO updateState(Operator1<StateIO> update) {
            return StateIO.INITIAL;
        }
    }
}

