/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.core.CheckedRunnable;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Consumer2;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Recoverable;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.effect.EIO;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.PureIOOf;
import com.github.tonivade.purefun.effect.RIOOf;
import com.github.tonivade.purefun.effect.URIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Fiber;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

@HigherKind
public final class RIO<R, A>
implements RIOOf<R, A>,
Effect<RIO<R, ?>, A>,
Recoverable {
    private static final RIO<?, Unit> UNIT = new RIO(PureIO.unit());
    private final PureIO<R, Throwable, A> instance;

    RIO(PureIO<R, Throwable, A> value) {
        this.instance = (PureIO)Precondition.checkNonNull(value);
    }

    public Try<A> safeRunSync(R env) {
        return Try.fromEither(this.instance.provide(env));
    }

    public PureIO<R, Throwable, A> toPureIO() {
        return this.instance;
    }

    public <E> EIO<E, A> toEIO() {
        return new EIO<Throwable, A>(this.instance);
    }

    public URIO<R, A> toURIO() {
        return this.recover(arg_0 -> ((RIO)this).sneakyThrow(arg_0));
    }

    public Future<A> runAsync(R env) {
        return this.instance.runAsync(env).flatMap(e -> (Kind)e.fold(Future::failure, Future::success));
    }

    public Future<A> runAsync(R env, Executor executor) {
        return RIO.forked(executor).andThen(this).runAsync(env);
    }

    public void safeRunAsync(R env, Consumer1<? super Try<? extends A>> callback) {
        this.instance.provideAsync(env, result -> callback.accept((Object)result.flatMap(Try::fromEither)));
    }

    public <B> RIO<R, B> map(Function1<? super A, ? extends B> map) {
        return new RIO<R, A>(this.instance.map((Function1)map));
    }

    public <B> RIO<R, B> flatMap(Function1<? super A, ? extends Kind<RIO<R, ?>, ? extends B>> map) {
        return new RIO<R, A>(this.instance.flatMap(x -> {
            RIO apply = (RIO)map.andThen(RIOOf::toRIO).apply(x);
            return apply.instance;
        }));
    }

    public <B> RIO<R, B> andThen(Kind<RIO<R, ?>, ? extends B> next) {
        return new RIO<R, A>(this.instance.andThen(((RIO)next.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance));
    }

    public <B> RIO<R, B> ap(Kind<RIO<R, ?>, ? extends Function1<? super A, ? extends B>> apply) {
        return new RIO<R, A>(this.instance.ap(((RIO)apply.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance));
    }

    public URIO<R, A> recover(Function1<? super Throwable, ? extends A> mapError) {
        return this.fold(mapError, Function1.identity());
    }

    public <X extends Throwable> URIO<R, A> recoverWith(Class<X> type, Function1<? super X, ? extends A> function) {
        return this.recover(cause -> {
            if (type.isAssignableFrom(cause.getClass())) {
                return function.apply(cause);
            }
            return this.sneakyThrow((Throwable)cause);
        });
    }

    public <B> URIO<R, B> fold(Function1<? super Throwable, ? extends B> mapError, Function1<? super A, ? extends B> map) {
        return new URIO(this.instance.foldM(mapError.andThen(PureIO::pure), map.andThen(PureIO::pure)));
    }

    public <B> RIO<R, B> foldM(Function1<? super Throwable, ? extends Kind<RIO<R, ?>, ? extends B>> mapError, Function1<? super A, ? extends Kind<RIO<R, ?>, ? extends B>> map) {
        return new RIO(this.instance.foldM(error -> ((RIO)mapError.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)()).apply((Object)error)).instance, value -> ((RIO)map.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)()).apply((Object)value)).instance));
    }

    public RIO<R, A> orElse(Kind<RIO<R, ?>, ? extends A> other) {
        return this.foldM(Function1.cons(other), Function1.cons((Object)this));
    }

    public <B> RIO<R, Tuple2<A, B>> zip(Kind<RIO<R, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Tuple::of);
    }

    public <B> RIO<R, A> zipLeft(Kind<RIO<R, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.first());
    }

    public <B> RIO<R, B> zipRight(Kind<RIO<R, ?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.second());
    }

    public <B, C> RIO<R, C> zipWith(Kind<RIO<R, ?>, ? extends B> other, Function2<? super A, ? super B, ? extends C> mapper) {
        return RIO.parMap2(this, (Kind)other.fix(RIOOf::toRIO), mapper);
    }

    public RIO<R, Fiber<RIO<R, ?>, A>> fork() {
        return new RIO<R, A>(this.instance.fork().map(f -> f.mapK(new FunctionK<PureIO<R, Throwable, ?>, RIO<R, ?>>(this){

            public <T> RIO<R, T> apply(Kind<PureIO<R, Throwable, ?>, ? extends T> from) {
                return new RIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })));
    }

    public RIO<R, A> timeout(Duration duration) {
        return this.timeout(Future.DEFAULT_EXECUTOR, duration);
    }

    public RIO<R, A> timeout(Executor executor, Duration duration) {
        return RIO.racePair(executor, this, RIO.sleep(duration)).flatMap(either -> (Kind)either.fold(ta -> ((RIO)((Fiber)ta.get2()).cancel().fix(RIOOf::toRIO)).map(x -> ta.get1()), tb -> ((RIO)((Fiber)tb.get1()).cancel().fix(RIOOf::toRIO)).flatMap(x -> RIO.raiseError(new TimeoutException()))));
    }

    public RIO<R, A> repeat() {
        return this.repeat(1);
    }

    public RIO<R, A> repeat(int times) {
        return new RIO<R, A>(this.instance.repeat(times));
    }

    public RIO<R, A> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public RIO<R, A> repeat(Duration delay, int times) {
        return new RIO<R, A>(this.instance.repeat(delay, times));
    }

    public RIO<R, A> retry() {
        return this.retry(1);
    }

    public RIO<R, A> retry(int maxRetries) {
        return new RIO<R, A>(this.instance.retry(maxRetries));
    }

    public RIO<R, A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public RIO<R, A> retry(Duration delay, int maxRetries) {
        return new RIO<R, A>(this.instance.retry(delay, maxRetries));
    }

    public RIO<R, Tuple2<Duration, A>> timed() {
        return new RIO<R, A>(this.instance.timed());
    }

    public static <R> RIO<R, Unit> forked(Executor executor) {
        return RIO.async((env, callback) -> executor.execute(() -> callback.accept((Object)Try.success((Object)Unit.unit()))));
    }

    public static <R, A> RIO<R, A> accessM(Function1<? super R, ? extends Kind<RIO<R, ?>, ? extends A>> map) {
        return new RIO(PureIO.accessM(map.andThen(RIOOf::toRIO).andThen(RIO::toPureIO)));
    }

    public static <R, A> RIO<R, A> access(Function1<? super R, ? extends A> map) {
        return RIO.accessM(map.andThen(RIO::pure));
    }

    public static <R> RIO<R, R> env() {
        return RIO.access(Function1.identity());
    }

    public static <R, A> RIO<R, A> absorb(RIO<R, Either<Throwable, A>> value) {
        return new RIO(PureIO.absorb(value.instance));
    }

    public static <R, A, B, C> RIO<R, C> parMap2(Kind<RIO<R, ?>, ? extends A> za, Kind<RIO<R, ?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return RIO.parMap2(Future.DEFAULT_EXECUTOR, za, zb, mapper);
    }

    public static <R, A, B, C> RIO<R, C> parMap2(Executor executor, Kind<RIO<R, ?>, ? extends A> za, Kind<RIO<R, ?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return new RIO(PureIO.parMap2(executor, ((RIO)za.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance, ((RIO)zb.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance, mapper));
    }

    public static <R, A, B> RIO<R, Either<A, B>> race(Kind<RIO<R, ?>, ? extends A> fa, Kind<RIO<R, ?>, ? extends B> fb) {
        return RIO.race(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <R, A, B> RIO<R, Either<A, B>> race(Executor executor, Kind<RIO<R, ?>, ? extends A> fa, Kind<RIO<R, ?>, ? extends B> fb) {
        return RIO.racePair(executor, fa, fb).flatMap(either -> (Kind)either.fold(ta -> ((RIO)((Fiber)ta.get2()).cancel().fix(RIOOf::toRIO)).map(x -> Either.left((Object)ta.get1())), tb -> ((RIO)((Fiber)tb.get1()).cancel().fix(RIOOf::toRIO)).map(x -> Either.right((Object)tb.get2()))));
    }

    public static <R, A, B> RIO<R, Either<Tuple2<A, Fiber<RIO<R, ?>, B>>, Tuple2<Fiber<RIO<R, ?>, A>, B>>> racePair(Executor executor, Kind<RIO<R, ?>, ? extends A> fa, Kind<RIO<R, ?>, ? extends B> fb) {
        PureIO instance1 = (PureIO)((RIO)fa.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance.fix(PureIOOf::toPureIO);
        PureIO instance2 = (PureIO)((RIO)fb.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance.fix(PureIOOf::toPureIO);
        return new RIO<R, A>(PureIO.racePair(executor, instance1, instance2).map(either -> either.bimap(a -> a.map2(f -> f.mapK(new FunctionK<PureIO<R, Throwable, ?>, RIO<R, ?>>(){

            public <T> RIO<R, T> apply(Kind<PureIO<R, Throwable, ?>, ? extends T> from) {
                return new RIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })), b -> b.map1(f -> f.mapK(new FunctionK<PureIO<R, Throwable, ?>, RIO<R, ?>>(){

            public <T> RIO<R, T> apply(Kind<PureIO<R, Throwable, ?>, ? extends T> from) {
                return new RIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })))));
    }

    public static <R> RIO<R, Unit> sleep(Duration delay) {
        return RIO.sleep(Future.DEFAULT_EXECUTOR, delay);
    }

    public static <R> RIO<R, Unit> sleep(Executor executor, Duration delay) {
        return new RIO(PureIO.sleep(executor, delay));
    }

    public static <R, A, B> Function1<A, RIO<R, B>> lift(Function1<? super A, ? extends B> function) {
        return value -> RIO.task(() -> function.apply(value));
    }

    public static <R, A, B> Function1<A, RIO<R, B>> liftOption(Function1<? super A, ? extends Option<? extends B>> function) {
        return value -> RIO.fromOption((Option)function.apply(value));
    }

    public static <R, A, B> Function1<A, RIO<R, B>> liftTry(Function1<? super A, ? extends Try<? extends B>> function) {
        return value -> RIO.fromTry((Try)function.apply(value));
    }

    public static <R, A, B> Function1<A, RIO<R, B>> liftEither(Function1<? super A, ? extends Either<Throwable, ? extends B>> function) {
        return value -> RIO.fromEither((Either)function.apply(value));
    }

    public static <R, A> RIO<R, A> fromOption(Option<? extends A> task) {
        return RIO.fromOption(Producer.cons(task));
    }

    public static <R, A> RIO<R, A> fromOption(Producer<Option<? extends A>> task) {
        return RIO.fromEither(task.andThen(Option::toEither));
    }

    public static <R, A> RIO<R, A> fromTry(Try<? extends A> task) {
        return RIO.fromTry(Producer.cons(task));
    }

    public static <R, A> RIO<R, A> fromTry(Producer<Try<? extends A>> task) {
        return new RIO(PureIO.fromTry(task));
    }

    public static <R, A> RIO<R, A> fromEither(Either<Throwable, ? extends A> task) {
        return RIO.fromEither(Producer.cons(task));
    }

    public static <R, A> RIO<R, A> fromEither(Producer<Either<Throwable, ? extends A>> task) {
        return new RIO(PureIO.fromEither(task));
    }

    public static <R> RIO<R, Unit> exec(CheckedRunnable task) {
        return new RIO(PureIO.exec(task));
    }

    public static <R, A> RIO<R, A> pure(A value) {
        return new RIO(PureIO.pure(value));
    }

    public static <R, A> RIO<R, A> raiseError(Throwable throwable) {
        return new RIO(PureIO.raiseError(throwable));
    }

    public static <R, A> RIO<R, A> defer(Producer<Kind<RIO<R, ?>, ? extends A>> lazy) {
        return new RIO(PureIO.defer(() -> ((RIO)lazy.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)()).get()).instance));
    }

    public static <R, A> RIO<R, A> task(Producer<? extends A> task) {
        return new RIO(PureIO.task(task));
    }

    public static <R, A> RIO<R, A> never() {
        return RIO.async((env, cb) -> {});
    }

    public static <R, A> RIO<R, A> async(Consumer2<R, Consumer1<? super Try<? extends A>>> consumer) {
        return new RIO(PureIO.async((env, cb1) -> consumer.accept(env, result -> cb1.accept((Object)result.map(Either::right)))));
    }

    public static <R, A> RIO<R, A> cancellable(Function2<R, Consumer1<? super Try<? extends A>>, RIO<R, Unit>> consumer) {
        return new RIO(PureIO.cancellable((env, cb1) -> (PureIO)consumer.andThen(RIO::toPureIO).apply(env, result -> cb1.accept((Object)result.map(Either::right)))));
    }

    public static <R, A> RIO<R, Sequence<A>> traverse(Sequence<? extends Kind<RIO<R, ?>, A>> sequence) {
        return RIO.traverse(Future.DEFAULT_EXECUTOR, sequence);
    }

    public static <R, A> RIO<R, Sequence<A>> traverse(Executor executor, Sequence<? extends Kind<RIO<R, ?>, A>> sequence) {
        return (RIO)sequence.foldLeft(RIO.pure(ImmutableList.empty()), (xs, a) -> RIO.parMap2(executor, xs, a, Sequence::append));
    }

    public static <R, A extends AutoCloseable, B> RIO<R, B> bracket(Kind<RIO<R, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<RIO<R, ?>, ? extends B>> use) {
        return new RIO(PureIO.bracket(((RIO)acquire.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance, resource -> ((RIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)()).apply((Object)resource)).instance));
    }

    public static <R, A, B> RIO<R, B> bracket(Kind<RIO<R, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<RIO<R, ?>, ? extends B>> use, Consumer1<? super A> release) {
        return new RIO(PureIO.bracket(((RIO)acquire.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance, resource -> ((RIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)()).apply((Object)resource)).instance, release));
    }

    public static <R, A, B> RIO<R, B> bracket(Kind<RIO<R, ?>, ? extends A> acquire, Function1<? super A, ? extends Kind<RIO<R, ?>, ? extends B>> use, Function1<? super A, ? extends Kind<RIO<R, ?>, Unit>> release) {
        return new RIO(PureIO.bracket(((RIO)acquire.fix((Function<Kind, RIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)())).instance, resource -> ((RIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toRIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.RIO<R, ?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/RIO;)()).apply((Object)resource)).instance, release.andThen(RIOOf::toRIO).andThen(RIO::toPureIO)));
    }

    public static <R> RIO<R, Unit> unit() {
        return UNIT;
    }
}

