/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.core.CheckedRunnable;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Recoverable;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.effect.EIO;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.PureIOOf;
import com.github.tonivade.purefun.effect.RIO;
import com.github.tonivade.purefun.effect.TaskOf;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Fiber;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

@HigherKind
public final class Task<A>
implements TaskOf<A>,
Effect<Task<?>, A>,
Recoverable {
    private static final Task<Unit> UNIT = new Task<Unit>(PureIO.unit());
    private final PureIO<Void, Throwable, A> instance;

    Task(PureIO<Void, Throwable, A> value) {
        this.instance = (PureIO)Precondition.checkNonNull(value);
    }

    public <R> PureIO<R, Throwable, A> toPureIO() {
        return this.instance;
    }

    public EIO<Throwable, A> toEIO() {
        return new EIO<Throwable, A>(this.instance);
    }

    public <R> RIO<R, A> toURIO() {
        return new RIO<Void, A>(this.instance);
    }

    public UIO<A> toUIO() {
        return this.recover(arg_0 -> ((Task)this).sneakyThrow(arg_0));
    }

    public Try<A> safeRunSync() {
        return Try.fromEither(this.instance.provide(null));
    }

    public Future<A> runAsync() {
        return this.instance.runAsync(null).flatMap(e -> (Kind)e.fold(Future::failure, Future::success));
    }

    public Future<A> runAsync(Executor executor) {
        return Task.forked(executor).andThen(this).runAsync();
    }

    public void safeRunAsync(Consumer1<? super Try<? extends A>> callback) {
        this.instance.provideAsync(null, result -> callback.accept((Object)result.flatMap(Try::fromEither)));
    }

    public <B> Task<B> map(Function1<? super A, ? extends B> map) {
        return this.flatMap((Function1)Task.lift(map));
    }

    public <B> Task<B> flatMap(Function1<? super A, ? extends Kind<Task<?>, ? extends B>> map) {
        return new Task<A>(this.instance.flatMap(value -> {
            Task apply = (Task)map.andThen(TaskOf::toTask).apply(value);
            return apply.instance;
        }));
    }

    public <B> Task<B> andThen(Kind<Task<?>, ? extends B> next) {
        return new Task<A>(this.instance.andThen(((Task)next.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance));
    }

    public <B> Task<B> ap(Kind<Task<?>, ? extends Function1<? super A, ? extends B>> apply) {
        return new Task<A>(this.instance.ap(((Task)apply.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance));
    }

    public <B> Task<B> foldM(Function1<? super Throwable, ? extends Kind<Task<?>, ? extends B>> mapError, Function1<? super A, ? extends Kind<Task<?>, ? extends B>> map) {
        return new Task(this.instance.foldM(error -> ((Task)mapError.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)()).apply((Object)error)).instance, value -> ((Task)map.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)()).apply((Object)value)).instance));
    }

    public <B> UIO<B> fold(Function1<? super Throwable, ? extends B> mapError, Function1<? super A, ? extends B> map) {
        return new UIO<B>(this.instance.fold(mapError, map).toPureIO());
    }

    public <X extends Throwable> UIO<A> recoverWith(Class<X> type, Function1<? super X, ? extends A> function) {
        return this.recover(cause -> {
            if (type.isAssignableFrom(cause.getClass())) {
                return function.apply(cause);
            }
            return this.sneakyThrow((Throwable)cause);
        });
    }

    public UIO<A> recover(Function1<? super Throwable, ? extends A> mapError) {
        return new UIO<A>(this.instance.recover(mapError).toPureIO());
    }

    public Task<A> orElse(Kind<Task<?>, ? extends A> other) {
        return new Task<A>(this.instance.orElse(((Task)other.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance));
    }

    public <B> Task<Tuple2<A, B>> zip(Kind<Task<?>, ? extends B> other) {
        return this.zipWith((Kind)other, Tuple::of);
    }

    public <B> Task<A> zipLeft(Kind<Task<?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.first());
    }

    public <B> Task<B> zipRight(Kind<Task<?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.second());
    }

    public <B, C> Task<C> zipWith(Kind<Task<?>, ? extends B> other, Function2<? super A, ? super B, ? extends C> mapper) {
        return Task.parMap2(this, (Kind)other.fix(TaskOf::toTask), mapper);
    }

    public Task<Fiber<Task<?>, A>> fork() {
        return new Task(this.instance.fork().map(f -> f.mapK(new FunctionK<PureIO<Void, Throwable, ?>, Task<?>>(this){

            public <T> Task<T> apply(Kind<PureIO<Void, Throwable, ?>, ? extends T> from) {
                return new Task((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })));
    }

    public Task<A> timeout(Duration duration) {
        return this.timeout(Future.DEFAULT_EXECUTOR, duration);
    }

    public Task<A> timeout(Executor executor, Duration duration) {
        return Task.racePair(executor, this, Task.sleep(duration)).flatMap(either -> (Kind)either.fold(ta -> ((Task)((Fiber)ta.get2()).cancel().fix(TaskOf::toTask)).map(x -> ta.get1()), tb -> ((Task)((Fiber)tb.get1()).cancel().fix(TaskOf::toTask)).flatMap(x -> Task.raiseError(new TimeoutException()))));
    }

    public Task<A> repeat() {
        return this.repeat(1);
    }

    public Task<A> repeat(int times) {
        return new Task<A>(this.instance.repeat(times));
    }

    public Task<A> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public Task<A> repeat(Duration delay, int times) {
        return new Task<A>(this.instance.repeat(delay, times));
    }

    public Task<A> retry() {
        return this.retry(1);
    }

    public Task<A> retry(int maxRetries) {
        return new Task<A>(this.instance.retry(maxRetries));
    }

    public Task<A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public Task<A> retry(Duration delay, int maxRetries) {
        return new Task<A>(this.instance.retry(delay, maxRetries));
    }

    public Task<Tuple2<Duration, A>> timed() {
        return new Task<Tuple2<Duration, A>>(this.instance.timed());
    }

    public static Task<Unit> forked(Executor executor) {
        return Task.async(callback -> executor.execute(() -> callback.accept((Object)Try.success((Object)Unit.unit()))));
    }

    public static <A, B, C> Task<C> parMap2(Kind<Task<?>, ? extends A> za, Kind<Task<?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return Task.parMap2(Future.DEFAULT_EXECUTOR, za, zb, mapper);
    }

    public static <A, B, C> Task<C> parMap2(Executor executor, Kind<Task<?>, ? extends A> za, Kind<Task<?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return new Task<C>(PureIO.parMap2(executor, ((Task)za.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance, ((Task)zb.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance, mapper));
    }

    public static <A, B> Task<Either<A, B>> race(Kind<Task<?>, ? extends A> fa, Kind<Task<?>, ? extends B> fb) {
        return Task.race(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <A, B> Task<Either<A, B>> race(Executor executor, Kind<Task<?>, ? extends A> fa, Kind<Task<?>, ? extends B> fb) {
        return Task.racePair(executor, fa, fb).flatMap(either -> (Kind)either.fold(ta -> ((Task)((Fiber)ta.get2()).cancel().fix(TaskOf::toTask)).map(x -> Either.left((Object)ta.get1())), tb -> ((Task)((Fiber)tb.get1()).cancel().fix(TaskOf::toTask)).map(x -> Either.right((Object)tb.get2()))));
    }

    public static <A, B> Task<Either<Tuple2<A, Fiber<Task<?>, B>>, Tuple2<Fiber<Task<?>, A>, B>>> racePair(Executor executor, Kind<Task<?>, ? extends A> fa, Kind<Task<?>, ? extends B> fb) {
        PureIO instance1 = (PureIO)((Task)fa.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance.fix(PureIOOf::toPureIO);
        PureIO instance2 = (PureIO)((Task)fb.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance.fix(PureIOOf::toPureIO);
        return new Task(PureIO.racePair(executor, instance1, instance2).map(either -> either.bimap(a -> a.map2(f -> f.mapK(new FunctionK<PureIO<Void, Throwable, ?>, Task<?>>(){

            public <T> Task<T> apply(Kind<PureIO<Void, Throwable, ?>, ? extends T> from) {
                return new Task((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })), b -> b.map1(f -> f.mapK(new FunctionK<PureIO<Void, Throwable, ?>, Task<?>>(){

            public <T> Task<T> apply(Kind<PureIO<Void, Throwable, ?>, ? extends T> from) {
                return new Task((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })))));
    }

    public static <A> Task<A> absorb(Task<Either<Throwable, A>> value) {
        return new Task(PureIO.absorb(value.instance));
    }

    public static <A, B> Function1<A, Task<B>> lift(Function1<? super A, ? extends B> function) {
        return PureIO.lift(function).andThen(Task::new);
    }

    public static <A, B> Function1<A, Task<B>> liftOption(Function1<? super A, ? extends Option<? extends B>> function) {
        return value -> Task.fromOption((Option)function.apply(value));
    }

    public static <A, B> Function1<A, Task<B>> liftTry(Function1<? super A, ? extends Try<? extends B>> function) {
        return value -> Task.fromTry((Try)function.apply(value));
    }

    public static <A, B> Function1<A, Task<B>> liftEither(Function1<? super A, ? extends Either<Throwable, ? extends B>> function) {
        return value -> Task.fromEither((Either)function.apply(value));
    }

    public static <A> Task<A> fromOption(Option<? extends A> task) {
        return Task.fromOption(Producer.cons(task));
    }

    public static <A> Task<A> fromOption(Producer<Option<? extends A>> task) {
        return Task.fromEither(task.andThen(Option::toEither));
    }

    public static <A> Task<A> fromTry(Try<? extends A> task) {
        return Task.fromTry(Producer.cons(task));
    }

    public static <A> Task<A> fromTry(Producer<Try<? extends A>> task) {
        return Task.fromEither(task.andThen(Try::toEither));
    }

    public static <A> Task<A> fromEither(Either<Throwable, ? extends A> task) {
        return Task.fromEither(Producer.cons(task));
    }

    public static <A> Task<A> fromEither(Producer<Either<Throwable, ? extends A>> task) {
        return new Task<A>(PureIO.fromEither(task));
    }

    public static Task<Unit> sleep(Duration delay) {
        return Task.sleep(Future.DEFAULT_EXECUTOR, delay);
    }

    public static Task<Unit> sleep(Executor executor, Duration delay) {
        return new Task<Unit>(PureIO.sleep(executor, delay));
    }

    public static Task<Unit> exec(CheckedRunnable task) {
        return new Task<Unit>(PureIO.exec(task));
    }

    public static <A> Task<A> pure(A value) {
        return new Task<A>(PureIO.pure(value));
    }

    public static <A> Task<A> defer(Producer<? extends Kind<Task<?>, ? extends A>> lazy) {
        return new Task(PureIO.defer(() -> ((Task)lazy.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)()).get()).instance));
    }

    public static <A> Task<A> task(Producer<? extends A> task) {
        return new Task<A>(PureIO.task(task));
    }

    public static <A> Task<A> never() {
        return Task.async(cb -> {});
    }

    public static <A> Task<A> async(Consumer1<Consumer1<? super Try<? extends A>>> consumer) {
        return new Task(PureIO.async((env, cb1) -> consumer.accept(result -> cb1.accept((Object)result.map(Either::right)))));
    }

    public static <A> Task<A> asyncF(Function1<Consumer1<? super Try<? extends A>>, Task<Unit>> consumer) {
        return new Task(PureIO.cancellable((env, cb1) -> (PureIO)consumer.andThen(Task::toPureIO).apply(result -> cb1.accept((Object)result.map(Either::right)))));
    }

    public static <A> Task<A> raiseError(Throwable error) {
        return new Task(PureIO.raiseError(error));
    }

    public static <A> Task<Sequence<A>> traverse(Sequence<? extends Kind<Task<?>, A>> sequence) {
        return Task.traverse(Future.DEFAULT_EXECUTOR, sequence);
    }

    public static <A> Task<Sequence<A>> traverse(Executor executor, Sequence<? extends Kind<Task<?>, A>> sequence) {
        return (Task)sequence.foldLeft(Task.pure(ImmutableList.empty()), (xs, a) -> Task.parMap2(executor, xs, a, Sequence::append));
    }

    public static <A extends AutoCloseable, B> Task<B> bracket(Kind<Task<?>, ? extends A> acquire, Function1<? super A, ? extends Kind<Task<?>, ? extends B>> use) {
        return new Task(PureIO.bracket(((Task)acquire.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance, resource -> ((Task)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)()).apply((Object)resource)).instance));
    }

    public static <A, B> Task<B> bracket(Kind<Task<?>, ? extends A> acquire, Function1<? super A, ? extends Kind<Task<?>, ? extends B>> use, Consumer1<? super A> release) {
        return new Task(PureIO.bracket(((Task)acquire.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance, resource -> ((Task)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)()).apply((Object)resource)).instance, release));
    }

    public static <A, B> Task<B> bracket(Kind<Task<?>, ? extends A> acquire, Function1<? super A, ? extends Kind<Task<?>, ? extends B>> use, Function1<? super A, ? extends Kind<Task<?>, Unit>> release) {
        return new Task(PureIO.bracket(((Task)acquire.fix((Function<Kind, Task>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)())).instance, resource -> ((Task)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toTask(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.Task<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/Task;)()).apply((Object)resource)).instance, release.andThen(TaskOf::toTask).andThen(Task::toPureIO)));
    }

    public static Task<Unit> unit() {
        return UNIT;
    }
}

