/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.Promise;
import com.github.tonivade.purefun.core.CheckedRunnable;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Recoverable;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.effect.EIO;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.PureIOOf;
import com.github.tonivade.purefun.effect.RIO;
import com.github.tonivade.purefun.effect.Ref;
import com.github.tonivade.purefun.effect.Task;
import com.github.tonivade.purefun.effect.UIOOf;
import com.github.tonivade.purefun.effect.URIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Fiber;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

@HigherKind
public final class UIO<A>
implements UIOOf<A>,
Effect<UIO<?>, A>,
Recoverable {
    private static final UIO<Unit> UNIT = new UIO<Unit>(PureIO.unit());
    private final PureIO<Void, Void, A> instance;

    UIO(PureIO<Void, Void, A> value) {
        this.instance = (PureIO)Precondition.checkNonNull(value);
    }

    public Future<A> runAsync() {
        return this.instance.runAsync(null).map(Either::getRight);
    }

    public Future<A> runAsync(Executor executor) {
        return UIO.forked(executor).andThen(this).runAsync();
    }

    public A unsafeRunSync() {
        return (A)this.instance.provide(null).get();
    }

    public Try<A> safeRunSync() {
        return Try.of(this::unsafeRunSync);
    }

    public <R, E> PureIO<R, E, A> toPureIO() {
        return this.instance;
    }

    public <E> EIO<E, A> toEIO() {
        return new EIO<Void, A>(this.instance);
    }

    public <R> RIO<R, A> toRIO() {
        return new RIO(PureIO.redeem(this.instance));
    }

    public <R> URIO<R, A> toURIO() {
        return new URIO<Void, A>(this.instance);
    }

    public Task<A> toTask() {
        return new Task(PureIO.redeem(this.instance));
    }

    public void safeRunAsync(Consumer1<? super Try<? extends A>> callback) {
        this.safeRunAsync(Future.DEFAULT_EXECUTOR, callback);
    }

    public void safeRunAsync(Executor executor, Consumer1<? super Try<? extends A>> callback) {
        this.instance.provideAsync(null, executor, x -> callback.accept((Object)x.map(Either::getRight)));
    }

    public <B> UIO<B> map(Function1<? super A, ? extends B> map) {
        return new UIO<A>(this.instance.map((Function1)map));
    }

    public <B> UIO<B> flatMap(Function1<? super A, ? extends Kind<UIO<?>, ? extends B>> map) {
        return new UIO<A>(this.instance.flatMap(x -> {
            UIO apply = (UIO)map.andThen(UIOOf::toUIO).apply(x);
            return apply.instance;
        }));
    }

    public <B> UIO<B> andThen(Kind<UIO<?>, ? extends B> next) {
        return new UIO<A>(this.instance.andThen(((UIO)next.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance));
    }

    public <B> UIO<B> ap(Kind<UIO<?>, ? extends Function1<? super A, ? extends B>> apply) {
        return new UIO<A>(this.instance.ap(((UIO)apply.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance));
    }

    public UIO<A> recover(Function1<? super Throwable, ? extends A> mapError) {
        return this.redeem(mapError, Function1.identity());
    }

    public <X extends Throwable> UIO<A> recoverWith(Class<X> type, Function1<? super X, ? extends A> function) {
        return this.recover(cause -> {
            if (type.isAssignableFrom(cause.getClass())) {
                return function.apply(cause);
            }
            return this.sneakyThrow((Throwable)cause);
        });
    }

    public <B> UIO<B> redeem(Function1<? super Throwable, ? extends B> mapError, Function1<? super A, ? extends B> map) {
        return this.redeemWith(mapError.andThen(UIO::pure), map.andThen(UIO::pure));
    }

    public <B> UIO<B> redeemWith(Function1<? super Throwable, ? extends Kind<UIO<?>, ? extends B>> mapError, Function1<? super A, ? extends Kind<UIO<?>, ? extends B>> map) {
        return new UIO(PureIO.redeem(this.instance).foldM(error -> ((UIO)mapError.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)()).apply((Object)error)).instance, value -> ((UIO)map.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)()).apply((Object)value)).instance));
    }

    public <B> UIO<Tuple2<A, B>> zip(Kind<UIO<?>, ? extends B> other) {
        return this.zipWith((Kind)other, Tuple::of);
    }

    public <B> UIO<A> zipLeft(Kind<UIO<?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.first());
    }

    public <B> UIO<B> zipRight(Kind<UIO<?>, ? extends B> other) {
        return this.zipWith((Kind)other, Function2.second());
    }

    public <B, C> UIO<C> zipWith(Kind<UIO<?>, ? extends B> other, Function2<? super A, ? super B, ? extends C> mapper) {
        return UIO.parMap2(this, (Kind)other.fix(UIOOf::toUIO), mapper);
    }

    public UIO<Fiber<UIO<?>, A>> fork() {
        return new UIO(this.instance.fork().map(f -> f.mapK(new FunctionK<PureIO<Void, Void, ?>, UIO<?>>(this){

            public <T> UIO<T> apply(Kind<PureIO<Void, Void, ?>, ? extends T> from) {
                return new UIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })));
    }

    public UIO<A> timeout(Duration duration) {
        return this.timeout(Future.DEFAULT_EXECUTOR, duration);
    }

    public UIO<A> timeout(Executor executor, Duration duration) {
        return UIO.racePair(executor, this, UIO.sleep(duration)).flatMap(either -> (Kind)either.fold(ta -> ((UIO)((Fiber)ta.get2()).cancel().fix(UIOOf::toUIO)).map(x -> ta.get1()), tb -> ((UIO)((Fiber)tb.get1()).cancel().fix(UIOOf::toUIO)).flatMap(x -> UIO.raiseError(new TimeoutException()))));
    }

    public UIO<A> repeat() {
        return this.repeat(1);
    }

    public UIO<A> repeat(int times) {
        return UIO.repeat(this, UIO.unit(), times);
    }

    public UIO<A> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public UIO<A> repeat(Duration delay, int times) {
        return UIO.repeat(this, UIO.sleep(delay), times);
    }

    public UIO<A> retry() {
        return this.retry(1);
    }

    public UIO<A> retry(int maxRetries) {
        return UIO.retry(this, UIO.unit(), maxRetries);
    }

    public UIO<A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public UIO<A> retry(Duration delay, int maxRetries) {
        return UIO.retry(this, UIO.sleep(delay), maxRetries);
    }

    public UIO<Tuple2<Duration, A>> timed() {
        return new UIO<Tuple2<Duration, A>>(this.instance.timed());
    }

    public static UIO<Unit> forked(Executor executor) {
        return UIO.async(callback -> executor.execute(() -> callback.accept((Object)Try.success((Object)Unit.unit()))));
    }

    public static <A, B, C> UIO<C> parMap2(Kind<UIO<?>, ? extends A> za, Kind<UIO<?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return UIO.parMap2(Future.DEFAULT_EXECUTOR, za, zb, mapper);
    }

    public static <A, B, C> UIO<C> parMap2(Executor executor, Kind<UIO<?>, ? extends A> za, Kind<UIO<?>, ? extends B> zb, Function2<? super A, ? super B, ? extends C> mapper) {
        return new UIO<C>(PureIO.parMap2(executor, ((UIO)za.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance, ((UIO)zb.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance, mapper));
    }

    public static <A, B> UIO<Either<A, B>> race(Kind<UIO<?>, ? extends A> fa, Kind<UIO<?>, ? extends B> fb) {
        return UIO.race(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <A, B> UIO<Either<A, B>> race(Executor executor, Kind<UIO<?>, ? extends A> fa, Kind<UIO<?>, ? extends B> fb) {
        return UIO.racePair(executor, fa, fb).flatMap(either -> (Kind)either.fold(ta -> ((UIO)((Fiber)ta.get2()).cancel().fix(UIOOf::toUIO)).map(x -> Either.left((Object)ta.get1())), tb -> ((UIO)((Fiber)tb.get1()).cancel().fix(UIOOf::toUIO)).map(x -> Either.right((Object)tb.get2()))));
    }

    public static <A, B> UIO<Either<Tuple2<A, Fiber<UIO<?>, B>>, Tuple2<Fiber<UIO<?>, A>, B>>> racePair(Executor executor, Kind<UIO<?>, ? extends A> fa, Kind<UIO<?>, ? extends B> fb) {
        PureIO instance1 = (PureIO)((UIO)fa.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance.fix(PureIOOf::toPureIO);
        PureIO instance2 = (PureIO)((UIO)fb.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance.fix(PureIOOf::toPureIO);
        return new UIO(PureIO.racePair(executor, instance1, instance2).map(either -> either.bimap(a -> a.map2(f -> f.mapK(new FunctionK<PureIO<Void, Void, ?>, UIO<?>>(){

            public <T> UIO<T> apply(Kind<PureIO<Void, Void, ?>, ? extends T> from) {
                return new UIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })), b -> b.map1(f -> f.mapK(new FunctionK<PureIO<Void, Void, ?>, UIO<?>>(){

            public <T> UIO<T> apply(Kind<PureIO<Void, Void, ?>, ? extends T> from) {
                return new UIO((PureIO)from.fix(PureIOOf::toPureIO));
            }
        })))));
    }

    public static <A, B> Function1<A, UIO<B>> lift(Function1<? super A, ? extends B> function) {
        return value -> UIO.task(() -> function.apply(value));
    }

    public static <A, B> Function1<A, UIO<B>> liftOption(Function1<? super A, ? extends Option<? extends B>> function) {
        return value -> UIO.fromOption((Option)function.apply(value));
    }

    public static <A, B> Function1<A, UIO<B>> liftTry(Function1<? super A, ? extends Try<? extends B>> function) {
        return value -> UIO.fromTry((Try)function.apply(value));
    }

    public static <A, B> Function1<A, UIO<B>> liftEither(Function1<? super A, ? extends Either<Throwable, ? extends B>> function) {
        return value -> UIO.fromEither((Either)function.apply(value));
    }

    public static UIO<Unit> sleep(Duration delay) {
        return UIO.sleep(Future.DEFAULT_EXECUTOR, delay);
    }

    public static UIO<Unit> sleep(Executor executor, Duration delay) {
        return UIO.fold(PureIO.sleep(executor, delay));
    }

    public static UIO<Unit> exec(CheckedRunnable task) {
        return UIO.fold(PureIO.exec(task));
    }

    public static <A> UIO<A> pure(A value) {
        return new UIO<A>(PureIO.pure(value));
    }

    public static <A> UIO<A> raiseError(Throwable throwable) {
        return new UIO(PureIO.fromEither(() -> {
            throw throwable;
        }));
    }

    public static <A> UIO<A> defer(Producer<Kind<UIO<?>, ? extends A>> lazy) {
        return new UIO(PureIO.defer(() -> ((UIO)lazy.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)()).get()).instance));
    }

    public static <A> UIO<A> task(Producer<? extends A> task) {
        return UIO.fold(PureIO.task(task));
    }

    public static <T> UIO<T> fromOption(Option<? extends T> task) {
        return UIO.fromEither(task.toEither());
    }

    public static <T> UIO<T> fromTry(Try<? extends T> task) {
        return UIO.fromEither(task.toEither());
    }

    public static <T> UIO<T> fromEither(Either<Throwable, ? extends T> task) {
        return (UIO)task.fold(UIO::raiseError, UIO::pure);
    }

    public static <T> UIO<T> fromPromise(Promise<? extends T> promise) {
        Consumer1 consumer = arg_0 -> promise.onComplete(arg_0);
        return UIO.async(consumer);
    }

    public static <A> UIO<A> never() {
        return UIO.async(cb -> {});
    }

    public static <A> UIO<A> async(Consumer1<Consumer1<? super Try<? extends A>>> consumer) {
        return UIO.fold(PureIO.async((env, cb1) -> consumer.accept(result -> cb1.accept((Object)result.map(Either::right)))));
    }

    public static <A> UIO<A> cancellable(Function1<Consumer1<? super Try<? extends A>>, UIO<Unit>> consumer) {
        return UIO.fold(PureIO.cancellable((env, cb1) -> (PureIO)consumer.andThen(UIO::toPureIO).apply(result -> cb1.accept((Object)result.map(Either::right)))));
    }

    public static <A, T> UIO<Function1<A, UIO<T>>> memoize(Function1<A, UIO<T>> function) {
        return UIO.memoize(Future.DEFAULT_EXECUTOR, function);
    }

    public static <A, T> UIO<Function1<A, UIO<T>>> memoize(Executor executor, Function1<A, UIO<T>> function) {
        UIO<Ref<ImmutableMap>> ref = Ref.make(ImmutableMap.empty());
        return ref.map(r -> {
            Function1 result = a -> r.modify(map -> (Tuple2)map.get(a).fold(() -> {
                Promise promise = Promise.make();
                ((UIO)function.apply(a)).safeRunAsync(executor, arg_0 -> ((Promise)promise).tryComplete(arg_0));
                return Tuple.of(UIO.fromPromise(promise), (Object)map.put(a, (Object)promise));
            }, promise -> Tuple.of(UIO.fromPromise(promise), (Object)map)));
            return result.andThen(io -> io.flatMap(Function1.identity()));
        });
    }

    public static <A> UIO<Sequence<A>> traverse(Sequence<? extends Kind<UIO<?>, A>> sequence) {
        return UIO.traverse(Future.DEFAULT_EXECUTOR, sequence);
    }

    public static <A> UIO<Sequence<A>> traverse(Executor executor, Sequence<? extends Kind<UIO<?>, A>> sequence) {
        return (UIO)sequence.foldLeft(UIO.pure(ImmutableList.empty()), (xs, a) -> UIO.parMap2(executor, xs, a, Sequence::append));
    }

    public static <A extends AutoCloseable, B> UIO<B> bracket(Kind<UIO<?>, ? extends A> acquire, Function1<? super A, ? extends Kind<UIO<?>, ? extends B>> use) {
        return UIO.fold(PureIO.bracket(PureIO.redeem(((UIO)acquire.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance), resource -> PureIO.redeem(((UIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)()).apply((Object)resource)).instance)));
    }

    public static <A, B> UIO<B> bracket(Kind<UIO<?>, ? extends A> acquire, Function1<? super A, ? extends Kind<UIO<?>, ? extends B>> use, Consumer1<? super A> release) {
        return UIO.fold(PureIO.bracket(PureIO.redeem(((UIO)acquire.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance), resource -> PureIO.redeem(((UIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)()).apply((Object)resource)).instance), release));
    }

    public static <A, B> UIO<B> bracket(Kind<UIO<?>, ? extends A> acquire, Function1<? super A, ? extends Kind<UIO<?>, ? extends B>> use, Function1<? super A, ? extends Kind<UIO<?>, Unit>> release) {
        return UIO.fold(PureIO.bracket(PureIO.redeem(((UIO)acquire.fix((Function<Kind, UIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)())).instance), resource -> PureIO.redeem(((UIO)use.andThen((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toUIO(com.github.tonivade.purefun.Kind<com.github.tonivade.purefun.effect.UIO<?>, ? extends A> ), (Lcom/github/tonivade/purefun/Kind;)Lcom/github/tonivade/purefun/effect/UIO;)()).apply((Object)resource)).instance), release.andThen(UIOOf::toUIO).andThen(UIO::toPureIO)));
    }

    public static UIO<Unit> unit() {
        return UNIT;
    }

    private static <A> UIO<A> fold(PureIO<Void, Throwable, A> zio) {
        return new UIO(zio.foldM(error -> UIO.raiseError((Throwable)error).instance, value -> UIO.pure(value).instance));
    }

    private static <T> UIO<T> repeat(UIO<T> self, UIO<Unit> pause, int times) {
        return self.redeemWith(UIO::raiseError, value -> {
            if (times > 0) {
                return pause.andThen(UIO.repeat(self, pause, times - 1));
            }
            return UIO.pure(value);
        });
    }

    private static <T> UIO<T> retry(UIO<T> self, UIO<Unit> pause, int maxRetries) {
        return self.redeemWith(error -> {
            if (maxRetries > 0) {
                return pause.andThen(UIO.retry(self, (UIO<Unit>)pause.repeat(), maxRetries - 1));
            }
            return UIO.raiseError(error);
        }, UIO::pure);
    }
}

