/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect.util;

import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.effect.URIO;
import java.time.Duration;
import java.time.OffsetDateTime;

public interface PureClock {
    public <R extends PureClock> Service<R> clock();

    public static <R extends PureClock> URIO<R, Long> currentTime() {
        return URIO.accessM(env -> env.clock().currentTime());
    }

    public static <R extends PureClock> URIO<R, OffsetDateTime> currentDateTime() {
        return URIO.accessM(env -> env.clock().currentDateTime());
    }

    public static <R extends PureClock> URIO<R, Unit> sleep(Duration duration) {
        return URIO.accessM(env -> env.clock().sleep(duration));
    }

    public static PureClock live() {
        return new PureClock(){

            @Override
            public <R extends PureClock> Service<R> clock() {
                return new Service<R>(this){

                    @Override
                    public URIO<R, Long> currentTime() {
                        return URIO.task(System::currentTimeMillis);
                    }

                    @Override
                    public URIO<R, OffsetDateTime> currentDateTime() {
                        return URIO.task(OffsetDateTime::now);
                    }

                    @Override
                    public URIO<R, Unit> sleep(Duration duration) {
                        return URIO.exec(() -> Thread.sleep(duration.toMillis()));
                    }
                };
            }
        };
    }

    public static interface Service<R extends PureClock> {
        public URIO<R, Long> currentTime();

        public URIO<R, OffsetDateTime> currentDateTime();

        public URIO<R, Unit> sleep(Duration var1);
    }
}

