/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect.util;

import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.NonEmptyList;
import com.github.tonivade.purefun.effect.RIO;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Queue;

public interface PureConsole {
    public <R extends PureConsole> Service<R> console();

    public static <R extends PureConsole> RIO<R, String> readln() {
        return RIO.accessM(env -> env.console().readln());
    }

    public static <R extends PureConsole> RIO<R, Unit> println(String text) {
        return RIO.accessM(env -> env.console().println(text));
    }

    public static PureConsole test(final Queue<String> input, final Queue<String> output) {
        return new PureConsole(){

            @Override
            public <R extends PureConsole> Service<R> console() {
                return new Service<R>(){

                    @Override
                    public RIO<R, String> readln() {
                        return RIO.task(input::poll);
                    }

                    @Override
                    public RIO<R, Unit> println(String text) {
                        return RIO.exec(() -> output.offer(text));
                    }
                };
            }
        };
    }

    public static PureConsole live() {
        return new PureConsole(){

            @Override
            public <R extends PureConsole> Service<R> console() {
                return new Service<R>(this){

                    @Override
                    public RIO<R, String> readln() {
                        return RIO.task(() -> this.reader().readLine());
                    }

                    @Override
                    public RIO<R, Unit> println(String text) {
                        return RIO.exec(() -> this.writer().println(text));
                    }

                    private BufferedReader reader() {
                        return new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                    }

                    private PrintWriter writer() {
                        return new PrintWriter(System.out, true, StandardCharsets.UTF_8);
                    }
                };
            }
        };
    }

    public static interface Service<R extends PureConsole> {
        public RIO<R, String> readln();

        public RIO<R, Unit> println(String var1);

        default public RIO<R, Unit> println(Object text, Object ... args) {
            return this.println(NonEmptyList.of((Object)text, (Object[])args).join(","));
        }

        default public RIO<R, Unit> printf(String template, Object ... args) {
            return this.println(String.format(template, args));
        }
    }
}

