/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect.util;

import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.effect.URIO;
import com.github.tonivade.purefun.effect.util.PureRandom;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PureRandomImpl
implements PureRandom {
    private static final String PRINTABLE_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final Random random;

    PureRandomImpl(Random random) {
        this.random = (Random)Precondition.checkNonNull((Object)random);
    }

    @Override
    public <R extends PureRandom> PureRandom.Service<R> random() {
        return new PureRandom.Service<R>(){

            @Override
            public URIO<R, Integer> nextInt() {
                return URIO.task(PureRandomImpl.this.random::nextInt);
            }

            @Override
            public URIO<R, Long> nextLong() {
                return URIO.task(PureRandomImpl.this.random::nextLong);
            }

            @Override
            public URIO<R, Float> nextFloat() {
                return URIO.task(PureRandomImpl.this.random::nextFloat);
            }

            @Override
            public URIO<R, Double> nextDouble() {
                return URIO.task(PureRandomImpl.this.random::nextDouble);
            }

            @Override
            public URIO<R, Character> nextChar() {
                return URIO.task(this::randomChar);
            }

            @Override
            public URIO<R, String> nextString(int length) {
                return URIO.task(() -> this.randomString(length));
            }

            private Character randomChar() {
                return Character.valueOf(PureRandomImpl.PRINTABLE_CHARS.charAt(PureRandomImpl.this.random.nextInt(PureRandomImpl.PRINTABLE_CHARS.length())));
            }

            private String randomString(int length) {
                return IntStream.range(0, length).mapToObj(x -> this.randomChar()).map(Object::toString).collect(Collectors.joining());
            }
        };
    }
}

