/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.free;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Operator2;
import com.github.tonivade.purefun.Precondition;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.free.CofreeOf;
import com.github.tonivade.purefun.type.Eval;
import com.github.tonivade.purefun.type.EvalOf;
import com.github.tonivade.purefun.type.Eval_;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.Functor;
import com.github.tonivade.purefun.typeclasses.Monoid;
import com.github.tonivade.purefun.typeclasses.Traverse;

@HigherKind
public final class Cofree<F extends Witness, A>
implements CofreeOf<F, A> {
    private final Functor<F> functor;
    private final A head;
    private final Eval<Kind<F, Cofree<F, A>>> tail;

    private Cofree(Functor<F> functor, A head, Eval<Kind<F, Cofree<F, A>>> tail) {
        this.functor = (Functor)Precondition.checkNonNull(functor);
        this.head = Precondition.checkNonNull(head);
        this.tail = (Eval)Precondition.checkNonNull(tail);
    }

    public A extract() {
        return this.head;
    }

    public Kind<F, Cofree<F, A>> tailForced() {
        return (Kind)this.tail.value();
    }

    public Cofree<F, A> runTail() {
        return Cofree.of(this.functor, this.head, Eval.now((Object)this.tail.value()));
    }

    public Cofree<F, A> run() {
        return Cofree.of(this.functor, this.head, Eval.now((Object)this.transformTail(Cofree::run).value()));
    }

    public <B> Cofree<F, B> map(Function1<A, B> mapper) {
        return this.transform(mapper, c -> c.map(mapper));
    }

    public <B> Cofree<F, B> coflatMap(Function1<Cofree<F, A>, B> mapper) {
        return Cofree.of(this.functor, mapper.apply((Object)this), this.transformTail(c -> c.coflatMap(mapper)));
    }

    public <B> Eval<B> fold(Applicative<Eval_> applicative, Traverse<F> traverse, Function2<A, Kind<F, B>, Eval<B>> mapper) {
        Eval eval = (Eval)traverse.traverse(applicative, this.tailForced(), c -> c.fold(applicative, traverse, mapper)).fix(EvalOf::narrowK);
        return eval.flatMap(fb -> (Eval)mapper.apply(this.extract(), fb));
    }

    public <B> Eval<B> reduce(Applicative<Eval_> applicative, Traverse<F> traverse, Function1<A, B> initial, Operator2<B> combine) {
        return this.fold(applicative, traverse, (a, fb) -> Eval.later(() -> traverse.fold(Monoid.of((Object)initial.apply(a), (Operator2)combine), fb)));
    }

    public Eval<String> reduceToString(Applicative<Eval_> applicative, Traverse<F> traverse, Operator2<String> join) {
        return this.reduce(applicative, traverse, String::valueOf, join);
    }

    public <B> Cofree<F, B> transform(Function1<A, B> headMap, Function1<Cofree<F, A>, Cofree<F, B>> tailMap) {
        return Cofree.of(this.functor, this.transformHead(headMap), this.transformTail(tailMap));
    }

    private <B> B transformHead(Function1<A, B> headMap) {
        return (B)headMap.apply(this.head);
    }

    private <B> Eval<Kind<F, Cofree<F, B>>> transformTail(Function1<Cofree<F, A>, Cofree<F, B>> tailMap) {
        return this.tail.map(t -> this.functor.map(t, tailMap));
    }

    public static <F extends Witness, A> Cofree<F, A> unfold(Functor<F> functor, A head, Function1<A, Kind<F, A>> unfold) {
        return Cofree.of(functor, head, Eval.later(() -> functor.map((Kind)unfold.apply(head), a -> Cofree.unfold(functor, a, unfold))));
    }

    public static <F extends Witness, A> Cofree<F, A> of(Functor<F> functor, A head, Eval<Kind<F, Cofree<F, A>>> tail) {
        return new Cofree<F, A>(functor, head, tail);
    }
}

