/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.free;

import com.github.tonivade.purefun.Equal;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Precondition;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.free.EitherKOf;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.typeclasses.Comonad;
import com.github.tonivade.purefun.typeclasses.Contravariant;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Functor;
import java.io.Serializable;
import java.util.Objects;

@HigherKind
public final class EitherK<F extends Witness, G extends Witness, T>
implements EitherKOf<F, G, T>,
Serializable {
    private static final long serialVersionUID = -2305737717835278018L;
    private static final Equal<EitherK<?, ?, ?>> EQUAL = Equal.of().comparing(eitherK -> eitherK.either);
    private final Either<Kind<F, T>, Kind<G, T>> either;

    private EitherK(Either<Kind<F, T>, Kind<G, T>> either) {
        this.either = (Either)Precondition.checkNonNull(either);
    }

    public <R> EitherK<F, G, R> map(Functor<F> functorF, Functor<G> functorG, Function1<T, R> mapper) {
        return new EitherK<F, G, T>(this.either.bimap(functorF.lift(mapper), functorG.lift(mapper)));
    }

    public <X extends Witness> EitherK<F, X, T> mapK(FunctionK<G, X> mapper) {
        return new EitherK<F, G, T>(this.either.map(arg_0 -> mapper.apply(arg_0)));
    }

    public <X extends Witness> EitherK<X, G, T> mapLeftK(FunctionK<F, X> mapper) {
        return new EitherK<F, G, T>(this.either.mapLeft(arg_0 -> mapper.apply(arg_0)));
    }

    public <R extends Witness> Kind<R, T> foldK(FunctionK<F, R> left, FunctionK<G, R> right) {
        return (Kind)this.either.fold(arg_0 -> left.apply(arg_0), arg_0 -> right.apply(arg_0));
    }

    public <R> EitherK<F, G, R> coflatMap(Comonad<F> comonadF, Comonad<G> comonadG, Function1<EitherK<F, G, T>, R> mapper) {
        return new EitherK<F, G, T>(this.either.bimap(a -> comonadF.coflatMap(a, x -> mapper.apply(EitherK.left(x))), a -> comonadG.coflatMap(a, x -> mapper.apply(EitherK.right(x)))));
    }

    public T extract(Comonad<F> comonadF, Comonad<G> comonadG) {
        return (T)this.either.fold(arg_0 -> comonadF.extract(arg_0), arg_0 -> comonadG.extract(arg_0));
    }

    public <R> EitherK<F, G, R> contramap(Contravariant<F> contravariantF, Contravariant<G> contravariantG, Function1<R, T> contramap) {
        return new EitherK<F, G, T>(this.either.bimap(x -> contravariantF.contramap(x, contramap), x -> contravariantG.contramap(x, contramap)));
    }

    public EitherK<G, F, T> swap() {
        return new EitherK<F, G, T>(this.either.swap());
    }

    public boolean isLeft() {
        return this.either.isLeft();
    }

    public boolean isRight() {
        return this.either.isRight();
    }

    public Kind<F, T> getLeft() {
        return (Kind)this.either.getLeft();
    }

    public Kind<G, T> getRight() {
        return (Kind)this.either.getRight();
    }

    public static <F extends Witness, G extends Witness, T> EitherK<F, G, T> left(Kind<F, T> left) {
        return new EitherK<F, G, T>(Either.left(left));
    }

    public static <F extends Witness, G extends Witness, T> EitherK<F, G, T> right(Kind<G, T> right) {
        return new EitherK<F, G, T>(Either.right(right));
    }

    public int hashCode() {
        return Objects.hash(this.either);
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public String toString() {
        return "EitherK(" + this.either + ')';
    }
}

