/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.free;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Precondition;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.free.FreeMonad;
import com.github.tonivade.purefun.free.FreeOf;
import com.github.tonivade.purefun.free.Free_;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Functor;
import com.github.tonivade.purefun.typeclasses.InjectK;
import com.github.tonivade.purefun.typeclasses.Monad;

@HigherKind
public abstract class Free<F extends Witness, A>
implements FreeOf<F, A> {
    private Free() {
    }

    public static <F extends Witness, T> Free<F, T> pure(T value) {
        return new Pure(value);
    }

    public static <F extends Witness, T> Free<F, T> liftF(Kind<F, T> value) {
        return new Suspend(value);
    }

    public static <F extends Witness, G extends Witness, T> Free<G, T> inject(InjectK<F, G> inject, Kind<F, T> value) {
        return Free.liftF(inject.inject(value));
    }

    public static <F extends Witness, T> Free<F, T> defer(Producer<Free<F, T>> value) {
        Free<F, Unit> pure = Free.pure(Unit.unit());
        return pure.flatMap(ignore -> (Free)value.get());
    }

    public static <F extends Witness> Monad<Kind<Free_, F>> monadF() {
        return FreeMonad.INSTANCE;
    }

    public static <F extends Witness, G extends Witness> FunctionK<F, Kind<Free_, G>> functionKF(final FunctionK<F, G> functionK) {
        return new FunctionK<F, Kind<Free_, G>>(){

            public <T> Free<G, T> apply(Kind<F, T> from) {
                return Free.liftF(functionK.apply(from));
            }
        };
    }

    public <R> Free<F, R> map(Function1<A, R> map) {
        return this.flatMap(map.andThen(Free::pure));
    }

    public abstract <R> Free<F, R> flatMap(Function1<A, Free<F, R>> var1);

    public abstract Either<Kind<F, Free<F, A>>, A> resume(Functor<F> var1);

    public abstract Free<F, A> step();

    public <R> Free<F, R> andThen(Free<F, R> next) {
        return this.flatMap(ignore -> next);
    }

    public <G extends Witness> Kind<G, A> foldMap(Monad<G> monad, FunctionK<F, G> interpreter) {
        return monad.tailRecM((Object)this, value -> value.step().foldStep(monad, interpreter));
    }

    protected abstract <G extends Witness> Kind<G, Either<Free<F, A>, A>> foldStep(Monad<G> var1, FunctionK<F, G> var2);

    public static final class FlatMapped<F extends Witness, X, A, B>
    extends Free<F, B> {
        private final Free<F, A> value;
        private final Function1<A, Free<F, B>> next;

        private FlatMapped(Free<F, A> value, Function1<A, Free<F, B>> next) {
            this.value = (Free)Precondition.checkNonNull(value);
            this.next = (Function1)Precondition.checkNonNull(next);
        }

        @Override
        public <C> Free<F, C> flatMap(Function1<B, Free<F, C>> map) {
            return new FlatMapped<F, X, A, B>(this.value, free -> new FlatMapped<F, X, A, B>((Free)this.next.apply(free), map));
        }

        @Override
        public Either<Kind<F, Free<F, B>>, B> resume(Functor<F> functor) {
            if (this.value instanceof Suspend) {
                Suspend suspend = (Suspend)this.value;
                return Either.left((Object)functor.map(suspend.value, this.next));
            }
            if (this.value instanceof Pure) {
                Pure pure = (Pure)this.value;
                return ((Free)this.next.apply(pure.value)).resume(functor);
            }
            FlatMapped flatMapped = (FlatMapped)this.value;
            return flatMapped.value.flatMap(x -> ((Free)flatMapped.next.apply(x)).flatMap(this.next)).resume(functor);
        }

        @Override
        public Free<F, B> step() {
            if (this.value instanceof FlatMapped) {
                FlatMapped flatMapped = (FlatMapped)this.value;
                return flatMapped.value.flatMap(x -> ((Free)flatMapped.next.apply(x)).flatMap(this.next)).step();
            }
            if (this.value instanceof Pure) {
                Pure pure = (Pure)this.value;
                return ((Free)this.next.apply(pure.value)).step();
            }
            return this;
        }

        @Override
        protected <G extends Witness> Kind<G, Either<Free<F, B>, B>> foldStep(Monad<G> monad, FunctionK<F, G> interpreter) {
            return monad.map(this.value.foldMap(monad, interpreter), this.next.andThen(Either::left));
        }
    }

    public static final class Suspend<F extends Witness, A>
    extends Free<F, A> {
        private final Kind<F, A> value;

        private Suspend(Kind<F, A> value) {
            this.value = (Kind)Precondition.checkNonNull(value);
        }

        @Override
        public <B> Free<F, B> flatMap(Function1<A, Free<F, B>> map) {
            return new FlatMapped(this, map);
        }

        @Override
        public Either<Kind<F, Free<F, A>>, A> resume(Functor<F> functor) {
            return Either.left((Object)functor.map(this.value, Free::pure));
        }

        @Override
        public Free<F, A> step() {
            return this;
        }

        @Override
        protected <G extends Witness> Kind<G, Either<Free<F, A>, A>> foldStep(Monad<G> monad, FunctionK<F, G> interpreter) {
            return monad.map(interpreter.apply(this.value), Either::right);
        }
    }

    public static final class Pure<F extends Witness, A>
    extends Free<F, A> {
        private final A value;

        private Pure(A value) {
            this.value = Precondition.checkNonNull(value);
        }

        @Override
        public <B> Free<F, B> flatMap(Function1<A, Free<F, B>> map) {
            return new FlatMapped(this, map);
        }

        @Override
        public Either<Kind<F, Free<F, A>>, A> resume(Functor<F> functor) {
            return Either.right(this.value);
        }

        @Override
        public Free<F, A> step() {
            return this;
        }

        @Override
        protected <G extends Witness> Kind<G, Either<Free<F, A>, A>> foldStep(Monad<G> monad, FunctionK<F, G> interpreter) {
            return monad.pure((Object)Either.right(this.value));
        }
    }
}

