/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.free;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Precondition;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.free.Free;
import com.github.tonivade.purefun.free.FreeApOf;
import com.github.tonivade.purefun.free.FreeAp_;
import com.github.tonivade.purefun.free.FreeApplicative;
import com.github.tonivade.purefun.free.FreeOf;
import com.github.tonivade.purefun.type.Const;
import com.github.tonivade.purefun.type.ConstOf;
import com.github.tonivade.purefun.type.Const_;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import java.util.Collections;
import java.util.LinkedList;

@HigherKind
public abstract class FreeAp<F extends Witness, A>
implements FreeApOf<F, A> {
    private FreeAp() {
    }

    public abstract <B> FreeAp<F, B> map(Function1<A, B> var1);

    public <B> FreeAp<F, B> ap(FreeAp<F, Function1<A, B>> apply) {
        if (apply instanceof Pure) {
            Pure pure = (Pure)apply;
            return this.map((Function1)pure.value);
        }
        return FreeAp.apply(this, apply);
    }

    public Kind<F, A> fold(Applicative<F> applicative) {
        return this.foldMap(FunctionK.identity(), applicative);
    }

    public <G extends Witness> FreeAp<G, A> compile(FunctionK<F, G> transformer) {
        return (FreeAp)this.foldMap(FreeAp.functionKF(transformer), FreeAp.applicativeF()).fix(FreeApOf::narrowK);
    }

    public <G extends Witness> FreeAp<G, A> flatCompile(FunctionK<F, Kind<FreeAp_, G>> functionK, Applicative<Kind<FreeAp_, G>> applicative) {
        return (FreeAp)this.foldMap(functionK, applicative).fix(FreeApOf::narrowK);
    }

    public <M> M analyze(FunctionK<F, Kind<Const_, M>> functionK, Applicative<Kind<Const_, M>> applicative) {
        return (M)((Const)this.foldMap(functionK, applicative).fix(ConstOf::narrowK)).get();
    }

    public Free<F, A> monad() {
        return (Free)this.foldMap((FunctionK)Free.functionKF(FunctionK.identity()), (Applicative)Free.monadF()).fix(FreeOf::narrowK);
    }

    public <G extends Witness> Kind<G, A> foldMap(FunctionK<F, G> functionK, Applicative<G> applicative) {
        Kind<G, A> argT;
        block6: {
            Kind res;
            LinkedList<FreeAp> argsF = new LinkedList<FreeAp>(Collections.singletonList(this));
            LinkedList fns = new LinkedList();
            while (true) {
                FreeAp argF;
                if ((argF = (FreeAp)argsF.pollFirst()) instanceof Apply) {
                    Apply ap;
                    int lengthInitial = argsF.size();
                    do {
                        ap = (Apply)argF;
                        argsF.addFirst(ap.value);
                    } while ((argF = ap.apply) instanceof Apply);
                    int argc = argsF.size() - lengthInitial;
                    fns.addFirst(new CurriedFunction(FreeAp.foldArg(argF, functionK, applicative), argc));
                    continue;
                }
                argT = FreeAp.foldArg(argF, functionK, applicative);
                if (fns.isEmpty()) break block6;
                CurriedFunction function = (CurriedFunction)fns.pollFirst();
                res = applicative.ap(argT, function.value);
                if (function.remaining > 1) {
                    fns.addFirst(new CurriedFunction(res, function.remaining - 1));
                    continue;
                }
                if (fns.size() > 0) {
                    do {
                        function = (CurriedFunction)fns.pollFirst();
                        res = applicative.ap(res, function.value);
                        if (function.remaining <= 1) continue;
                        fns.addFirst(new CurriedFunction(res, function.remaining - 1));
                    } while (function.remaining == 1 && fns.size() > 0);
                }
                if (fns.size() == 0) break;
            }
            return res;
        }
        return argT;
    }

    public static <F extends Witness, T> FreeAp<F, T> pure(T value) {
        return new Pure(value);
    }

    public static <F extends Witness, T> FreeAp<F, T> lift(Kind<F, T> value) {
        return new Lift(value);
    }

    public static <F extends Witness, T, R> FreeAp<F, R> apply(FreeAp<F, T> value, FreeAp<F, Function1<T, R>> mapper) {
        return new Apply(value, mapper);
    }

    public static <F extends Witness, G extends Witness> FunctionK<F, Kind<FreeAp_, G>> functionKF(final FunctionK<F, G> functionK) {
        return new FunctionK<F, Kind<FreeAp_, G>>(){

            public <T> FreeAp<G, T> apply(Kind<F, T> from) {
                return FreeAp.lift(functionK.apply(from));
            }
        };
    }

    public static <F extends Witness> Applicative<Kind<FreeAp_, F>> applicativeF() {
        return FreeApplicative.INSTANCE;
    }

    private static <F extends Witness, G extends Witness, A> Kind<G, A> foldArg(FreeAp<F, A> argF, FunctionK<F, G> transformation, Applicative<G> applicative) {
        if (argF instanceof Pure) {
            return applicative.pure(((Pure)argF).value);
        }
        if (argF instanceof Lift) {
            return transformation.apply(((Lift)argF).value);
        }
        throw new IllegalStateException();
    }

    private static final class CurriedFunction<G extends Witness, A, B> {
        private final Kind<G, Function1<A, B>> value;
        private final int remaining;

        CurriedFunction(Kind<G, Function1<A, B>> value, int remaining) {
            this.value = (Kind)Precondition.checkNonNull(value);
            this.remaining = remaining;
        }
    }

    private static final class Apply<F extends Witness, A, B>
    extends FreeAp<F, B> {
        private final FreeAp<F, A> value;
        private final FreeAp<F, Function1<A, B>> apply;

        private Apply(FreeAp<F, A> value, FreeAp<F, Function1<A, B>> apply) {
            this.value = (FreeAp)Precondition.checkNonNull(value);
            this.apply = (FreeAp)Precondition.checkNonNull(apply);
        }

        @Override
        public <C> FreeAp<F, C> map(Function1<B, C> mapper) {
            return Apply.apply(this, Apply.pure(mapper));
        }

        public String toString() {
            return "Apply(" + this.value + ", ...)";
        }
    }

    private static final class Lift<F extends Witness, A>
    extends FreeAp<F, A> {
        private final Kind<F, A> value;

        private Lift(Kind<F, A> value) {
            this.value = (Kind)Precondition.checkNonNull(value);
        }

        @Override
        public <B> FreeAp<F, B> map(Function1<A, B> mapper) {
            return Lift.apply(this, Lift.pure(mapper));
        }

        public String toString() {
            return "Lift(" + this.value + ')';
        }
    }

    private static final class Pure<F extends Witness, A>
    extends FreeAp<F, A> {
        private final A value;

        private Pure(A value) {
            this.value = Precondition.checkNonNull(value);
        }

        @Override
        public <B> FreeAp<F, B> map(Function1<A, B> mapper) {
            return Pure.pure(mapper.apply(this.value));
        }

        public String toString() {
            return "Pure(" + this.value + ')';
        }
    }
}

