/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.free;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Precondition;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.free.TrampolineModule;
import com.github.tonivade.purefun.free.TrampolineOf;

@HigherKind
public interface Trampoline<T>
extends TrampolineOf<T> {
    public Trampoline<T> apply();

    public boolean complete();

    public T get();

    default public <R> Trampoline<R> map(Function1<T, R> map) {
        return (Trampoline)TrampolineModule.resume(this).fold(next -> Trampoline.more(() -> next.map(map)), value -> Trampoline.done(map.apply(value)));
    }

    default public <R> Trampoline<R> flatMap(Function1<T, Trampoline<R>> map) {
        return (Trampoline)TrampolineModule.resume(this).fold(next -> Trampoline.more(() -> next.flatMap(map)), arg_0 -> map.apply(arg_0));
    }

    default public <R> R fold(Function1<Trampoline<T>, R> more, Function1<T, R> done) {
        return (R)(this.complete() ? done.apply(this.get()) : more.apply(this.apply()));
    }

    default public T run() {
        return TrampolineModule.iterate(this).get();
    }

    public TrampolineModule module();

    public static <T> Trampoline<T> done(T value) {
        return new Done(value);
    }

    public static <T> Trampoline<T> more(Producer<Trampoline<T>> next) {
        return new More(next);
    }

    public static final class More<T>
    implements Trampoline<T> {
        private final Producer<Trampoline<T>> next;

        private More(Producer<Trampoline<T>> next) {
            this.next = (Producer)Precondition.checkNonNull(next);
        }

        @Override
        public boolean complete() {
            return false;
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Trampoline<T> apply() {
            return (Trampoline)this.next.get();
        }

        @Override
        public TrampolineModule module() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Done<T>
    implements Trampoline<T> {
        private final T value;

        private Done(T value) {
            this.value = Precondition.checkNonNull(value);
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Trampoline<T> apply() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TrampolineModule module() {
            throw new UnsupportedOperationException();
        }
    }
}

