/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.free;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.free.FreeMonad;
import com.github.tonivade.purefun.free.FreeOf;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.InjectK;
import com.github.tonivade.purefun.typeclasses.Monad;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

@HigherKind
public sealed interface Free<F extends Kind<F, ?>, A>
extends FreeOf<F, A>,
Bindable<Free<F, ?>, A> {
    public static <F extends Kind<F, ?>, T> Free<F, T> pure(T value) {
        return new Pure(value);
    }

    public static <F extends Kind<F, ?>, T> Free<F, T> liftF(Kind<F, ? extends T> value) {
        return new Suspend<F, T>(value);
    }

    public static <F extends Kind<F, ?>, G extends Kind<G, ?>, T> Free<G, T> inject(InjectK<F, G> inject, Kind<F, T> value) {
        return Free.liftF(inject.inject(value));
    }

    public static <F extends Kind<F, ?>, T> Free<F, T> defer(Producer<? extends Free<F, ? extends T>> value) {
        Free<F, Unit> pure = Free.pure(Unit.unit());
        return pure.flatMap(value.asFunction());
    }

    public static <F extends Kind<F, ?>> Monad<Free<F, ?>> monadF() {
        return FreeMonad.INSTANCE;
    }

    public static <F extends Kind<F, ?>, G extends Kind<G, ?>> FunctionK<F, Free<G, ?>> functionKF(final FunctionK<F, G> functionK) {
        return new FunctionK<F, Free<G, ?>>(){

            public <T> Free<G, T> apply(Kind<F, ? extends T> from) {
                return Free.liftF(functionK.apply(from));
            }
        };
    }

    default public <R> Free<F, R> map(Function1<? super A, ? extends R> map) {
        return this.flatMap(map.andThen(Free::pure));
    }

    public <R> Free<F, R> flatMap(Function1<? super A, ? extends Kind<Free<F, ?>, ? extends R>> var1);

    default public <R> Free<F, R> andThen(Kind<Free<F, ?>, ? extends R> next) {
        return this.flatMap(ignore -> next);
    }

    default public <G extends Kind<G, ?>> Kind<G, A> foldMap(Monad<G> monad, FunctionK<F, G> interpreter) {
        return monad.tailRecM((Object)this, value -> value.foldStep(monad, interpreter));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <G extends Kind<G, ?>> Kind<G, Either<Free<F, A>, A>> foldStep(Monad<G> monad, FunctionK<F, G> interpreter) {
        Kind kind;
        Free free = this;
        Objects.requireNonNull(free);
        Free free2 = free;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pure.class, Suspend.class, FlatMapped.class}, (Object)free2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                Pure pure = (Pure)free2;
                try {
                    Object a;
                    value = a = pure.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                kind = monad.pure((Object)Either.right(value));
                return kind;
            }
            case 1: {
                Kind value;
                Suspend suspend = (Suspend)free2;
                {
                    Kind kind2;
                    value = kind2 = suspend.value();
                }
                kind = monad.map(interpreter.apply(value), Either::right);
                return kind;
            }
            case 2: 
        }
        FlatMapped flatMapped = (FlatMapped)free2;
        kind = flatMapped.foldStep(monad, interpreter);
        return kind;
    }

    public record Pure<F extends Kind<F, ?>, A>(A value) implements Free<F, A>
    {
        public Pure {
            Precondition.checkNonNull(value);
        }

        @Override
        public <B> Free<F, B> flatMap(Function1<? super A, ? extends Kind<Free<F, ?>, ? extends B>> map) {
            return new FlatMapped(this, map);
        }
    }

    public record Suspend<F extends Kind<F, ?>, A>(Kind<F, ? extends A> value) implements Free<F, A>
    {
        public Suspend {
            Precondition.checkNonNull(value);
        }

        @Override
        public <B> Free<F, B> flatMap(Function1<? super A, ? extends Kind<Free<F, ?>, ? extends B>> map) {
            return new FlatMapped(this, map);
        }
    }

    public record FlatMapped<F extends Kind<F, ?>, A, B>(Free<F, ? extends A> value, Function1<? super A, ? extends Kind<Free<F, ?>, ? extends B>> next) implements Free<F, B>
    {
        public FlatMapped {
            Precondition.checkNonNull(value);
            Precondition.checkNonNull(next);
        }

        @Override
        public <C> Free<F, C> flatMap(Function1<? super B, ? extends Kind<Free<F, ?>, ? extends C>> map) {
            return new FlatMapped<F, A, B>(this.value, free -> new FlatMapped<F, A, B>((Free)this.next.andThen(FreeOf::toFree).apply(free), map));
        }

        @Override
        private <G extends Kind<G, ?>> Kind<G, Either<Free<F, B>, B>> foldStep(Monad<G> monad, FunctionK<F, G> interpreter) {
            Kind<G, ? extends A> foldMap = this.value.foldMap(monad, interpreter);
            Function1 andThen = this.next.andThen(FreeOf::toFree);
            return monad.map(foldMap, andThen.andThen(Either::left));
        }
    }
}

