/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.runtimes;

import com.github.tonivade.purefun.monad.IO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;

public final class ConsoleExecutor {
    private final StringBuilder input = new StringBuilder();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();

    public ConsoleExecutor read(String string) {
        this.input.append(string).append('\n');
        return this;
    }

    public String getOutput() {
        return new String(this.output.toByteArray(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(IO<T> program) {
        InputStream savedInput = System.in;
        PrintStream savedOutput = System.out;
        try {
            System.setIn(this.mockInput());
            System.setOut(this.mockOutput());
            Object object = program.unsafeRunSync();
            return (T)object;
        }
        finally {
            System.setIn(savedInput);
            System.setOut(savedOutput);
        }
    }

    private PrintStream mockOutput() {
        return new PrintStream(this.output);
    }

    private ByteArrayInputStream mockInput() {
        return new ByteArrayInputStream(this.input.toString().getBytes(StandardCharsets.UTF_8));
    }
}

