/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.instances;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Eq;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.data.SequenceOf;
import com.github.tonivade.purefun.instances.SequenceAlternative;
import com.github.tonivade.purefun.instances.SequenceApplicative;
import com.github.tonivade.purefun.instances.SequenceFoldable;
import com.github.tonivade.purefun.instances.SequenceFunctor;
import com.github.tonivade.purefun.instances.SequenceMonad;
import com.github.tonivade.purefun.instances.SequenceMonoid;
import com.github.tonivade.purefun.instances.SequenceMonoidK;
import com.github.tonivade.purefun.instances.SequenceSemigroup;
import com.github.tonivade.purefun.instances.SequenceSemigroupK;
import com.github.tonivade.purefun.instances.SequenceTraverse;
import com.github.tonivade.purefun.typeclasses.Alternative;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.Foldable;
import com.github.tonivade.purefun.typeclasses.Functor;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.purefun.typeclasses.Monoid;
import com.github.tonivade.purefun.typeclasses.MonoidK;
import com.github.tonivade.purefun.typeclasses.Semigroup;
import com.github.tonivade.purefun.typeclasses.SemigroupK;
import com.github.tonivade.purefun.typeclasses.Traverse;

public interface SequenceInstances {
    public static <T> Eq<Kind<Sequence<?>, T>> eq(Eq<T> eqElement) {
        return (a, b) -> {
            Sequence seq1 = SequenceOf.toSequence((Kind)a);
            Sequence seq2 = SequenceOf.toSequence((Kind)b);
            return seq1.size() == seq2.size() && Sequence.zip((Sequence)seq1, (Sequence)seq2).allMatch(tuple -> eqElement.eqv(tuple.get1(), tuple.get2()));
        };
    }

    public static <T> Semigroup<Sequence<T>> semigroup() {
        return SequenceSemigroup.INSTANCE;
    }

    public static <T> Monoid<Sequence<T>> monoid() {
        return SequenceMonoid.INSTANCE;
    }

    public static SemigroupK<Sequence<?>> semigroupK() {
        return SequenceSemigroupK.INSTANCE;
    }

    public static MonoidK<Sequence<?>> monoidK() {
        return SequenceMonoidK.INSTANCE;
    }

    public static Functor<Sequence<?>> functor() {
        return SequenceFunctor.INSTANCE;
    }

    public static Applicative<Sequence<?>> applicative() {
        return SequenceApplicative.INSTANCE;
    }

    public static Monad<Sequence<?>> monad() {
        return SequenceMonad.INSTANCE;
    }

    public static Alternative<Sequence<?>> alternative() {
        return SequenceAlternative.INSTANCE;
    }

    public static Traverse<Sequence<?>> traverse() {
        return SequenceTraverse.INSTANCE;
    }

    public static Foldable<Sequence<?>> foldable() {
        return SequenceFoldable.INSTANCE;
    }
}

