/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.instances;

import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.effect.Task;
import com.github.tonivade.purefun.instances.TaskApplicative;
import com.github.tonivade.purefun.instances.TaskAsync;
import com.github.tonivade.purefun.instances.TaskConcurrent;
import com.github.tonivade.purefun.instances.TaskConsole;
import com.github.tonivade.purefun.instances.TaskFunctor;
import com.github.tonivade.purefun.instances.TaskMonad;
import com.github.tonivade.purefun.instances.TaskMonadDefer;
import com.github.tonivade.purefun.instances.TaskMonadError;
import com.github.tonivade.purefun.instances.TaskMonadThrow;
import com.github.tonivade.purefun.instances.TaskRuntime;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.Async;
import com.github.tonivade.purefun.typeclasses.Concurrent;
import com.github.tonivade.purefun.typeclasses.Console;
import com.github.tonivade.purefun.typeclasses.Functor;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import com.github.tonivade.purefun.typeclasses.MonadError;
import com.github.tonivade.purefun.typeclasses.MonadThrow;
import com.github.tonivade.purefun.typeclasses.Reference;
import com.github.tonivade.purefun.typeclasses.Resource;
import com.github.tonivade.purefun.typeclasses.Runtime;
import java.util.concurrent.Executor;

public interface TaskInstances {
    public static Functor<Task<?>> functor() {
        return TaskFunctor.INSTANCE;
    }

    public static Applicative<Task<?>> applicative() {
        return TaskApplicative.INSTANCE;
    }

    public static Monad<Task<?>> monad() {
        return TaskMonad.INSTANCE;
    }

    public static MonadError<Task<?>, Throwable> monadError() {
        return TaskMonadError.INSTANCE;
    }

    public static MonadThrow<Task<?>> monadThrow() {
        return TaskMonadThrow.INSTANCE;
    }

    public static MonadDefer<Task<?>> monadDefer() {
        return TaskMonadDefer.INSTANCE;
    }

    public static Async<Task<?>> async() {
        return TaskAsync.INSTANCE;
    }

    public static Concurrent<Task<?>> concurrent() {
        return TaskConcurrent.instance(Future.DEFAULT_EXECUTOR);
    }

    public static Concurrent<Task<?>> concurrent(Executor executor) {
        return TaskConcurrent.instance(executor);
    }

    public static <A> Reference<Task<?>, A> ref(A value) {
        return Reference.of(TaskInstances.monadDefer(), value);
    }

    public static <A extends AutoCloseable> Resource<Task<?>, A> resource(Task<A> acquire) {
        return TaskInstances.resource(acquire, AutoCloseable::close);
    }

    public static <A> Resource<Task<?>, A> resource(Task<A> acquire, Consumer1<A> release) {
        return Resource.from(TaskInstances.monadDefer(), acquire, release);
    }

    public static Console<Task<?>> console() {
        return TaskConsole.INSTANCE;
    }

    public static Runtime<Task<?>> runtime() {
        return TaskRuntime.INSTANCE;
    }
}

