/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.instances;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.instances.ValidationPure;
import com.github.tonivade.purefun.type.Validation;
import com.github.tonivade.purefun.type.ValidationOf;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.Semigroup;

interface ValidationApplicative<E>
extends ValidationPure<E>,
Applicative<Validation<E, ?>> {
    public static <E> ValidationApplicative<E> instance(Semigroup<E> semigroup) {
        return () -> semigroup;
    }

    public Semigroup<E> semigroup();

    default public <T, R> Validation<E, R> ap(Kind<Validation<E, ?>, ? extends T> value, Kind<Validation<E, ?>, ? extends Function1<? super T, ? extends R>> apply) {
        Validation validation = (Validation)value.fix(ValidationOf::toValidation);
        Validation validationF = (Validation)apply.fix(ValidationOf::toValidation);
        if (validation.isValid() && validationF.isValid()) {
            return Validation.valid((Object)((Function1)validationF.get()).apply(validation.get()));
        }
        if (validation.isInvalid() && validationF.isValid()) {
            return Validation.invalid((Object)validation.getError());
        }
        if (validation.isValid() && validationF.isInvalid()) {
            return Validation.invalid((Object)validationF.getError());
        }
        return Validation.invalid((Object)this.semigroup().combine(validation.getError(), validationF.getError()));
    }
}

