/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.instances;

import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.instances.IOApplicative;
import com.github.tonivade.purefun.instances.IOAsync;
import com.github.tonivade.purefun.instances.IOConcurrent;
import com.github.tonivade.purefun.instances.IOConsole;
import com.github.tonivade.purefun.instances.IOFunctor;
import com.github.tonivade.purefun.instances.IOMonad;
import com.github.tonivade.purefun.instances.IOMonadDefer;
import com.github.tonivade.purefun.instances.IOMonadError;
import com.github.tonivade.purefun.instances.IOMonadThrow;
import com.github.tonivade.purefun.instances.IORuntime;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.typeclasses.Applicative;
import com.github.tonivade.purefun.typeclasses.Async;
import com.github.tonivade.purefun.typeclasses.Concurrent;
import com.github.tonivade.purefun.typeclasses.Console;
import com.github.tonivade.purefun.typeclasses.Functor;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import com.github.tonivade.purefun.typeclasses.MonadError;
import com.github.tonivade.purefun.typeclasses.MonadThrow;
import com.github.tonivade.purefun.typeclasses.Runtime;
import com.github.tonivade.purefun.typeclasses.Timer;
import java.util.concurrent.Executor;

public interface IOInstances {
    public static Functor<IO<?>> functor() {
        return IOFunctor.INSTANCE;
    }

    public static Applicative<IO<?>> applicative() {
        return IOInstances.applicative(Future.DEFAULT_EXECUTOR);
    }

    public static Applicative<IO<?>> applicative(Executor executor) {
        return IOApplicative.instance(executor);
    }

    public static Monad<IO<?>> monad() {
        return IOMonad.INSTANCE;
    }

    public static MonadError<IO<?>, Throwable> monadError() {
        return IOMonadError.INSTANCE;
    }

    public static MonadThrow<IO<?>> monadThrow() {
        return IOMonadThrow.INSTANCE;
    }

    public static Timer<IO<?>> timer() {
        return IOMonadDefer.INSTANCE;
    }

    public static MonadDefer<IO<?>> monadDefer() {
        return IOMonadDefer.INSTANCE;
    }

    public static Async<IO<?>> async() {
        return IOAsync.INSTANCE;
    }

    public static Concurrent<IO<?>> concurrent() {
        return IOInstances.concurrent(Future.DEFAULT_EXECUTOR);
    }

    public static Concurrent<IO<?>> concurrent(Executor executor) {
        return IOConcurrent.instance(executor);
    }

    public static Console<IO<?>> console() {
        return IOConsole.INSTANCE;
    }

    public static Runtime<IO<?>> runtime() {
        return IORuntime.INSTANCE;
    }
}

