/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.instances;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.instances.EffectEMonadError;
import com.github.tonivade.purefun.instances.EffectRMonad;
import com.github.tonivade.purefun.instances.EffectRMonadError;
import com.github.tonivade.purefun.instances.EffectRMonadReader;
import com.github.tonivade.purefun.instances.StateTInstances;
import com.github.tonivade.purefun.transformer.EitherT;
import com.github.tonivade.purefun.transformer.EitherTOf;
import com.github.tonivade.purefun.transformer.Kleisli;
import com.github.tonivade.purefun.transformer.KleisliOf;
import com.github.tonivade.purefun.transformer.StateT;
import com.github.tonivade.purefun.transformer.StateTOf;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.purefun.typeclasses.MonadError;
import com.github.tonivade.purefun.typeclasses.MonadReader;
import com.github.tonivade.purefun.typeclasses.MonadState;
import java.util.function.Function;

public class MonadMTL<F extends Kind<F, ?>, S, R, E>
implements Monad<EffectS<F, S, R, E, ?>>,
MonadError<EffectS<F, S, R, E, ?>, E>,
MonadState<EffectS<F, S, R, E, ?>, S>,
MonadReader<EffectS<F, S, R, E, ?>, R> {
    private final Monad<F> monad;
    private final MonadError<EffectE<F, E, ?>, E> monadErrorE;
    private final Monad<EffectR<F, R, E, ?>> monadR;
    private final MonadError<StateT<EffectR<F, R, E, ?>, S, ?>, E> monadErrorS;
    private final MonadReader<StateT<EffectR<F, R, E, ?>, S, ?>, R> monadReaderS;
    private final MonadState<StateT<EffectR<F, R, E, ?>, S, ?>, S> monadStateS;

    public MonadMTL(Monad<F> monad) {
        this.monad = (Monad)Precondition.checkNonNull(monad);
        this.monadErrorE = new EffectEMonadError(monad);
        this.monadR = new EffectRMonad(monad);
        this.monadErrorS = StateTInstances.monadError(new EffectRMonadError(monad));
        this.monadReaderS = StateTInstances.monadReader(new EffectRMonadReader(monad));
        this.monadStateS = StateTInstances.monadState(this.monadR);
    }

    public <A> EffectS<F, S, R, E, A> pure(A value) {
        return new EffectS(this.monadStateS.pure(value));
    }

    public <A, B> EffectS<F, S, R, E, B> flatMap(Kind<EffectS<F, S, R, E, ?>, ? extends A> value, Function1<? super A, ? extends Kind<EffectS<F, S, R, E, ?>, ? extends B>> map) {
        return new EffectS(this.monadStateS.flatMap(((EffectS)value.fix(EffectS::toEffectS)).value(), x -> ((EffectS)((Kind)map.apply(x)).fix(EffectS::toEffectS)).value()));
    }

    public EffectS<F, S, R, E, S> get() {
        return new EffectS(this.monadStateS.get());
    }

    public EffectS<F, S, R, E, Unit> set(S state) {
        return new EffectS(this.monadStateS.set(state));
    }

    public <A> EffectS<F, S, R, E, A> raiseError(E error) {
        return new EffectS(this.monadErrorS.raiseError(error));
    }

    public <A> EffectS<F, S, R, E, A> handleErrorWith(Kind<EffectS<F, S, R, E, ?>, A> value, Function1<? super E, ? extends Kind<EffectS<F, S, R, E, ?>, ? extends A>> handler) {
        return new EffectS(this.monadErrorS.handleErrorWith(((EffectS)value.fix(EffectS::toEffectS)).value(), error -> ((EffectS)((Kind)handler.apply(error)).fix(EffectS::toEffectS)).value()));
    }

    public EffectS<F, S, R, E, R> ask() {
        return new EffectS(this.monadReaderS.ask());
    }

    public <A> EffectE<F, E, A> effectE(Kind<F, Either<E, A>> value) {
        return new EffectE(EitherT.of(this.monad, value));
    }

    public <A> EffectR<F, R, E, A> effectR(EffectE<F, E, A> effect0) {
        return new EffectR(Kleisli.of(this.monadErrorE, config -> effect0));
    }

    public <A> EffectS<F, S, R, E, A> effectS(EffectR<F, R, E, A> effect1) {
        return new EffectS(StateT.state(this.monadR, state -> this.monadR.map((Kind)effect1, x -> Tuple.of((Object)state, (Object)x))));
    }

    public <A> EffectS<F, S, R, E, A> effect(Kind<F, Either<E, A>> value) {
        return this.effectS(this.effectR(this.effectE(value)));
    }

    public static final class EffectS<F extends Kind<F, ?>, S, R, E, A>
    implements Kind<EffectS<F, S, R, E, ?>, A> {
        private final StateT<EffectR<F, R, E, ?>, S, A> value;

        public EffectS(Kind<StateT<EffectR<F, R, E, ?>, S, ?>, A> value) {
            this.value = (StateT)value.fix(StateTOf::toStateT);
        }

        public StateT<EffectR<F, R, E, ?>, S, A> value() {
            return this.value;
        }

        public EffectR<F, R, E, Tuple2<S, A>> run(S state) {
            return (EffectR)this.value.run(state).fix(EffectR::toEffectR);
        }

        public EffectE<F, E, Tuple2<S, A>> run(S state, R env) {
            return this.run(state).run(env);
        }

        public static <F extends Kind<F, ?>, S, R, E, A> EffectS<F, S, R, E, A> toEffectS(Kind<EffectS<F, S, R, E, ?>, ? extends A> hkt) {
            return (EffectS)hkt;
        }
    }

    public static final class EffectE<F extends Kind<F, ?>, E, A>
    implements Kind<EffectE<F, E, ?>, A> {
        private final EitherT<F, E, A> value;

        public EffectE(Kind<EitherT<F, E, ?>, A> value) {
            this.value = (EitherT)value.fix(EitherTOf::toEitherT);
        }

        public EitherT<F, E, A> value() {
            return this.value;
        }

        public Kind<F, Either<E, A>> run() {
            return this.value.value();
        }

        public <R extends Kind<F, Either<E, A>>> R run(Function<Kind<F, ? extends Either<E, A>>, R> fixer) {
            return (R)this.run().fix(fixer);
        }

        public static <F extends Kind<F, ?>, E, A> EffectE<F, E, A> toEffectE(Kind<EffectE<F, E, ?>, ? extends A> hkt) {
            return (EffectE)hkt;
        }
    }

    public static final class EffectR<F extends Kind<F, ?>, R, E, A>
    implements Kind<EffectR<F, R, E, ?>, A> {
        private final Kleisli<EffectE<F, E, ?>, R, A> value;

        public EffectR(Kind<Kleisli<EffectE<F, E, ?>, R, ?>, A> value) {
            this.value = (Kleisli)value.fix(KleisliOf::toKleisli);
        }

        public Kleisli<EffectE<F, E, ?>, R, A> value() {
            return this.value;
        }

        public EffectE<F, E, A> run(R config) {
            return (EffectE)this.value.run(config).fix(EffectE::toEffectE);
        }

        public static <F extends Kind<F, ?>, R, E, A> EffectR<F, R, E, A> toEffectR(Kind<EffectR<F, R, E, ?>, ? extends A> hkt) {
            return (EffectR)hkt;
        }
    }
}

