/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.runtimes;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.effect.PureIO;
import com.github.tonivade.purefun.effect.RIO;
import com.github.tonivade.purefun.effect.Task;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.URIO;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Try;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;

public final class ConsoleExecutor {
    private final StringBuilder input = new StringBuilder();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();

    public ConsoleExecutor read(String string) {
        this.input.append(string).append('\n');
        return this;
    }

    public String getOutput() {
        return this.output.toString(StandardCharsets.UTF_8);
    }

    public <R, E, T> Function1<R, Either<E, T>> run(PureIO<R, E, T> program) {
        return env -> (Either)this.run(() -> program.provide(env));
    }

    public <R, T> Function1<R, Try<T>> run(RIO<R, T> program) {
        return env -> (Try)this.run(() -> program.safeRunSync(env));
    }

    public <R, T> Function1<R, T> run(URIO<R, T> program) {
        return env -> this.run(() -> program.unsafeRunSync(env));
    }

    public <T> T run(IO<T> program) {
        return this.run(() -> program.unsafeRunSync());
    }

    public <T> T run(UIO<T> program) {
        return this.run(() -> program.unsafeRunSync());
    }

    public <T> Try<T> run(Task<T> program) {
        return (Try)this.run(() -> program.safeRunSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Producer<T> program) {
        InputStream savedInput = System.in;
        PrintStream savedOutput = System.out;
        try {
            System.setIn(this.mockInput());
            System.setOut(this.mockOutput());
            Object object = program.get();
            return (T)object;
        }
        finally {
            System.setIn(savedInput);
            System.setOut(savedOutput);
        }
    }

    private PrintStream mockOutput() {
        return new PrintStream(this.output);
    }

    private ByteArrayInputStream mockInput() {
        return new ByteArrayInputStream(this.input.toString().getBytes(StandardCharsets.UTF_8));
    }
}

