/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Recoverable;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.StackItem;
import com.github.tonivade.purefun.type.Option;

final class CallStack<T>
implements Recoverable {
    @Nullable
    private StackItem<T> top = new StackItem();

    CallStack() {
    }

    public void push() {
        if (this.top != null) {
            this.top.push();
        }
    }

    public void pop() {
        if (this.top == null) {
            return;
        }
        if (this.top.count() > 0) {
            this.top.pop();
        } else {
            this.top = this.top.prev();
        }
    }

    public void add(PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>> mapError) {
        if (this.top == null) {
            return;
        }
        if (this.top.count() > 0) {
            this.top.pop();
            this.top = new StackItem<T>(this.top);
        }
        this.top.add(mapError);
    }

    public Option<IO<T>> tryHandle(Throwable error) {
        while (this.top != null) {
            this.top.reset();
            Option<IO<T>> result = this.top.tryHandle(error);
            if (result.isPresent()) {
                return result;
            }
            this.top = this.top.prev();
        }
        return Option.none();
    }
}

