/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.Promise;
import com.github.tonivade.purefun.core.CheckedRunnable;
import com.github.tonivade.purefun.core.Consumer1;
import com.github.tonivade.purefun.core.Effect;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Recoverable;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.monad.CallStack;
import com.github.tonivade.purefun.monad.IOConnection;
import com.github.tonivade.purefun.monad.IOOf;
import com.github.tonivade.purefun.monad.Ref;
import com.github.tonivade.purefun.monad.StateIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Fiber;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@HigherKind
public sealed interface IO<T>
extends IOOf<T>,
Effect<IO<?>, T>,
Recoverable {
    public static final IO<Unit> UNIT = IO.pure(Unit.unit());

    default public Future<T> runAsync() {
        return Future.from(IO.runAsync(this, IOConnection.UNCANCELLABLE));
    }

    default public Future<T> runAsync(Executor executor) {
        return IO.forked(executor).andThen(this).runAsync();
    }

    default public T unsafeRunSync() {
        return (T)this.safeRunSync().getOrElseThrow();
    }

    default public Try<T> safeRunSync() {
        return this.runAsync().await();
    }

    default public void safeRunAsync(Consumer1<? super Try<? extends T>> callback) {
        this.safeRunAsync(Future.DEFAULT_EXECUTOR, callback);
    }

    default public void safeRunAsync(Executor executor, Consumer1<? super Try<? extends T>> callback) {
        this.runAsync(executor).onComplete(callback);
    }

    default public <R> IO<R> map(Function1<? super T, ? extends R> map) {
        return this.flatMap(map.andThen(IO::pure));
    }

    default public <R> IO<R> flatMap(Function1<? super T, ? extends Kind<IO<?>, ? extends R>> map) {
        return new FlatMapped(this, map);
    }

    default public <R> IO<R> andThen(Kind<IO<?>, ? extends R> after) {
        return this.flatMap(ignore -> after);
    }

    default public <R> IO<R> ap(Kind<IO<?>, ? extends Function1<? super T, ? extends R>> apply) {
        return IO.parMap2(Future.DEFAULT_EXECUTOR, this, apply, (v, a) -> a.apply(v));
    }

    default public IO<Try<T>> attempt() {
        return this.map(Try::success).recover(Try::failure);
    }

    default public IO<Either<Throwable, T>> either() {
        return this.attempt().map(Try::toEither);
    }

    default public <L, R> IO<Either<L, R>> either(Function1<? super Throwable, ? extends L> mapError, Function1<? super T, ? extends R> mapper) {
        return this.either().map(either -> either.bimap(mapError, mapper));
    }

    default public <R> IO<R> redeem(Function1<? super Throwable, ? extends R> mapError, Function1<? super T, ? extends R> mapper) {
        return this.attempt().map(result -> result.fold(mapError, mapper));
    }

    default public <R> IO<R> redeemWith(Function1<? super Throwable, ? extends Kind<IO<?>, ? extends R>> mapError, Function1<? super T, ? extends Kind<IO<?>, ? extends R>> mapper) {
        return this.attempt().flatMap(result -> (Kind)result.fold(mapError, mapper));
    }

    default public IO<T> recover(Function1<? super Throwable, ? extends T> mapError) {
        return this.recoverWith(PartialFunction1.of((Matcher1)Matcher1.always(), (Function1)mapError.andThen(IO::pure)));
    }

    default public <X extends Throwable> IO<T> recover(Class<X> type, Function1<? super X, ? extends T> function) {
        return this.recoverWith(PartialFunction1.of(error -> error.getClass().equals(type), t -> (IO)function.andThen(IO::pure).apply(t)));
    }

    default public IO<T> recoverWith(PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>> mapper) {
        return new Recover(this, mapper.andThen(IOOf::toIO));
    }

    default public IO<Tuple2<Duration, T>> timed() {
        return IO.task(System::nanoTime).flatMap(start -> this.map(result -> Tuple.of((Object)Duration.ofNanos(System.nanoTime() - start), (Object)result)));
    }

    default public IO<Fiber<IO<?>, T>> fork() {
        return IO.async(callback -> {
            IOConnection connection = IOConnection.cancellable();
            Promise<T> promise = IO.runAsync(this, connection);
            IO<T> join = IO.fromPromise(promise);
            IO<Unit> cancel = IO.exec(connection::cancel);
            callback.accept((Object)Try.success((Object)Fiber.of(join, cancel)));
        });
    }

    default public IO<T> timeout(Duration duration) {
        return this.timeout(Future.DEFAULT_EXECUTOR, duration);
    }

    default public IO<T> timeout(Executor executor, Duration duration) {
        return IO.racePair(executor, this, IO.sleep(duration)).flatMap(either -> (Kind)either.fold(ta -> ((IO)((Fiber)ta.get2()).cancel().fix(IOOf::toIO)).map(x -> ta.get1()), tb -> ((IO)((Fiber)tb.get1()).cancel().fix(IOOf::toIO)).flatMap(x -> IO.raiseError(new TimeoutException()))));
    }

    default public IO<T> repeat() {
        return this.repeat(1);
    }

    default public IO<T> repeat(int times) {
        return IO.repeat(this, IO.unit(), times);
    }

    default public IO<T> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    default public IO<T> repeat(Duration delay, int times) {
        return IO.repeat(this, IO.sleep(delay), times);
    }

    default public IO<T> retry() {
        return this.retry(1);
    }

    default public IO<T> retry(int maxRetries) {
        return IO.retry(this, IO.unit(), maxRetries);
    }

    default public IO<T> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    default public IO<T> retry(Duration delay, int maxRetries) {
        return IO.retry(this, IO.sleep(delay), maxRetries);
    }

    public static <T> IO<T> pure(T value) {
        return new Pure<T>(value);
    }

    public static <A, B> IO<Either<A, B>> race(Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb) {
        return IO.race(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <A, B> IO<Either<A, B>> race(Executor executor, Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb) {
        return IO.racePair(executor, fa, fb).flatMap(either -> (Kind)either.fold(ta -> ((IO)((Fiber)ta.get2()).cancel().fix(IOOf::toIO)).map(x -> Either.left((Object)ta.get1())), tb -> ((IO)((Fiber)tb.get1()).cancel().fix(IOOf::toIO)).map(x -> Either.right((Object)tb.get2()))));
    }

    public static <A, B> IO<Either<Tuple2<A, Fiber<IO<?>, B>>, Tuple2<Fiber<IO<?>, A>, B>>> racePair(Executor executor, Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb) {
        return IO.cancellable(callback -> {
            IOConnection connection1 = IOConnection.cancellable();
            IOConnection connection2 = IOConnection.cancellable();
            Promise promiseA = IO.runAsync(IO.forked(executor).andThen(fa), connection1);
            Promise promiseB = IO.runAsync(IO.forked(executor).andThen(fb), connection2);
            promiseA.onComplete(result -> callback.accept((Object)result.map(a -> Either.left((Object)Tuple.of((Object)a, (Object)Fiber.of(IO.fromPromise(promiseB), IO.exec(connection2::cancel)))))));
            promiseB.onComplete(result -> callback.accept((Object)result.map(b -> Either.right((Object)Tuple.of((Object)Fiber.of(IO.fromPromise(promiseA), IO.exec(connection1::cancel)), (Object)b)))));
            return IO.exec(() -> {
                try {
                    connection1.cancel();
                }
                finally {
                    connection2.cancel();
                }
            });
        });
    }

    public static <T> IO<T> raiseError(Throwable error) {
        return new Failure(error);
    }

    public static <T> IO<T> delay(Duration delay, Producer<? extends T> lazy) {
        return IO.sleep(delay).andThen(IO.task(lazy));
    }

    public static <T> IO<T> suspend(Producer<? extends Kind<IO<?>, ? extends T>> lazy) {
        return new Suspend(() -> ((Kind)lazy.get()).fix(IOOf::toIO));
    }

    public static <T, R> Function1<T, IO<R>> lift(Function1<T, R> task) {
        return task.andThen(IO::pure);
    }

    public static <A, B> Function1<A, IO<B>> liftOption(Function1<? super A, ? extends Option<? extends B>> function) {
        return value -> IO.fromOption((Option)function.apply(value));
    }

    public static <A, B> Function1<A, IO<B>> liftTry(Function1<? super A, ? extends Try<? extends B>> function) {
        return value -> IO.fromTry((Try)function.apply(value));
    }

    public static <A, B> Function1<A, IO<B>> liftEither(Function1<? super A, ? extends Either<Throwable, ? extends B>> function) {
        return value -> IO.fromEither((Either)function.apply(value));
    }

    public static <T> IO<T> fromOption(Option<? extends T> task) {
        return IO.fromEither(task.toEither());
    }

    public static <T> IO<T> fromTry(Try<? extends T> task) {
        return IO.fromEither(task.toEither());
    }

    public static <T> IO<T> fromEither(Either<Throwable, ? extends T> task) {
        return (IO)task.fold(IO::raiseError, IO::pure);
    }

    public static <T> IO<T> fromPromise(Promise<? extends T> promise) {
        Consumer1 callback = arg_0 -> promise.onComplete(arg_0);
        return IO.async(callback);
    }

    public static <T> IO<T> fromCompletableFuture(CompletableFuture<? extends T> promise) {
        return IO.fromPromise(Promise.from(promise));
    }

    public static IO<Unit> sleep(Duration duration) {
        return IO.sleep(Future.DEFAULT_EXECUTOR, duration);
    }

    public static IO<Unit> sleep(Executor executor, Duration duration) {
        return IO.cancellable(callback -> {
            Future sleep = Future.sleep((Executor)executor, (Duration)duration).onComplete(result -> callback.accept((Object)Try.success((Object)Unit.unit())));
            return IO.exec(() -> sleep.cancel(true));
        });
    }

    public static IO<Unit> exec(CheckedRunnable task) {
        return IO.task(task.asProducer());
    }

    public static <T> IO<T> task(Producer<? extends T> producer) {
        return new Delay<T>(producer);
    }

    public static <T> IO<T> never() {
        return IO.async(callback -> {});
    }

    public static IO<Unit> forked() {
        return IO.forked(Future.DEFAULT_EXECUTOR);
    }

    public static IO<Unit> forked(Executor executor) {
        return IO.async(callback -> executor.execute(() -> callback.accept((Object)Try.success((Object)Unit.unit()))));
    }

    public static <T> IO<T> async(Consumer1<Consumer1<? super Try<? extends T>>> callback) {
        return IO.cancellable(callback.asFunction().andThen(IO::pure));
    }

    public static <T> IO<T> cancellable(Function1<Consumer1<? super Try<? extends T>>, Kind<IO<?>, Unit>> callback) {
        return new Async(callback);
    }

    public static <A, T> IO<Function1<A, IO<T>>> memoize(Function1<A, IO<T>> function) {
        return IO.memoize(Future.DEFAULT_EXECUTOR, function);
    }

    public static <A, T> IO<Function1<A, IO<T>>> memoize(Executor executor, Function1<A, IO<T>> function) {
        IO<Ref<ImmutableMap>> ref = Ref.make(ImmutableMap.empty());
        return ref.map(r -> {
            Function1 result = a -> r.modify(map -> (Tuple2)map.get(a).fold(() -> {
                Promise promise = Promise.make();
                ((IO)function.apply(a)).safeRunAsync(executor, arg_0 -> ((Promise)promise).tryComplete(arg_0));
                return Tuple.of(IO.fromPromise(promise), (Object)map.put(a, (Object)promise));
            }, promise -> Tuple.of(IO.fromPromise(promise), (Object)map)));
            return result.andThen(io -> io.flatMap(Function1.identity()));
        });
    }

    public static IO<Unit> unit() {
        return UNIT;
    }

    public static <T, R> IO<R> bracket(Kind<IO<?>, ? extends T> acquire, Function1<? super T, ? extends Kind<IO<?>, ? extends R>> use, Function1<? super T, ? extends Kind<IO<?>, Unit>> release) {
        return IO.cancellable(callback -> {
            IOConnection cancellable = IOConnection.cancellable();
            Promise promise = IO.runAsync(acquire, cancellable);
            promise.onFailure(error -> callback.accept((Object)Try.failure((Throwable)error))).onSuccess(resource -> IO.runAsync((Kind)use.apply(resource), cancellable).onComplete(result -> IO.runAsync((Kind)release.apply(resource), cancellable).onComplete(ignore -> callback.accept(result))));
            return IO.exec(cancellable::cancel);
        });
    }

    public static <T, R> IO<R> bracket(Kind<IO<?>, ? extends T> acquire, Function1<? super T, ? extends Kind<IO<?>, ? extends R>> use, Consumer1<? super T> release) {
        return IO.bracket(acquire, use, release.asFunction().andThen(IO::pure));
    }

    public static <T extends AutoCloseable, R> IO<R> bracket(Kind<IO<?>, ? extends T> acquire, Function1<? super T, ? extends Kind<IO<?>, ? extends R>> use) {
        return IO.bracket(acquire, use, AutoCloseable::close);
    }

    public static IO<Unit> sequence(Sequence<? extends Kind<IO<?>, ?>> sequence) {
        Kind initial = IO.unit().kind();
        return ((IO)((Kind)sequence.foldLeft((Object)initial, (a, b) -> ((IO)a.fix(IOOf::toIO)).andThen((Kind)b))).fix(IOOf::toIO)).andThen(IO.unit());
    }

    public static <A> IO<Sequence<A>> traverse(Sequence<? extends Kind<IO<?>, A>> sequence) {
        return IO.traverse(Future.DEFAULT_EXECUTOR, sequence);
    }

    public static <A> IO<Sequence<A>> traverse(Executor executor, Sequence<? extends Kind<IO<?>, A>> sequence) {
        return (IO)sequence.foldLeft(IO.pure(ImmutableList.empty()), (xs, a) -> IO.parMap2(executor, xs, a, Sequence::append));
    }

    public static <A, B, C> IO<C> parMap2(Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb, Function2<? super A, ? super B, ? extends C> mapper) {
        return IO.parMap2(Future.DEFAULT_EXECUTOR, fa, fb, mapper);
    }

    public static <A, B, C> IO<C> parMap2(Executor executor, Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb, Function2<? super A, ? super B, ? extends C> mapper) {
        return IO.cancellable(callback -> {
            IOConnection connection1 = IOConnection.cancellable();
            IOConnection connection2 = IOConnection.cancellable();
            Promise promiseA = IO.runAsync(IO.forked(executor).andThen(fa), connection1);
            Promise promiseB = IO.runAsync(IO.forked(executor).andThen(fb), connection2);
            promiseA.onComplete(a -> promiseB.onComplete(b -> callback.accept((Object)Try.map2((Try)a, (Try)b, (Function2)mapper))));
            return IO.exec(() -> {
                try {
                    connection1.cancel();
                }
                finally {
                    connection2.cancel();
                }
            });
        });
    }

    public static <A, B> IO<Tuple2<A, B>> tuple(Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb) {
        return IO.tuple(Future.DEFAULT_EXECUTOR, fa, fb);
    }

    public static <A, B> IO<Tuple2<A, B>> tuple(Executor executor, Kind<IO<?>, ? extends A> fa, Kind<IO<?>, ? extends B> fb) {
        return IO.parMap2(executor, fa, fb, Tuple::of);
    }

    private static <T> Promise<T> runAsync(Kind<IO<?>, T> current, IOConnection connection) {
        return IO.runAsync(current, connection, new CallStack(), Promise.make());
    }

    private static <T, U, V> Promise<T> runAsync(Kind<IO<?>, T> current, IOConnection connection, CallStack<T> stack, Promise<T> promise) {
        while (true) {
            try {
                while (true) {
                    if ((current = IO.unwrap(current, stack, Function1.identity())) instanceof Pure) {
                        Pure pure = (Pure)current;
                        return promise.succeeded(pure.value);
                    }
                    if (current instanceof Async) {
                        Async async = (Async)current;
                        return IO.executeAsync(async, connection, promise);
                    }
                    if (current instanceof FlatMapped) {
                        stack.push();
                        FlatMapped flatMapped = (FlatMapped)current;
                        IO source = (IO)IO.unwrap(flatMapped.current, stack, u -> ((IO)u.fix(IOOf::toIO)).flatMap(flatMapped.next)).fix(IOOf::toIO);
                        if (source instanceof Async) {
                            Async async = (Async)source;
                            Promise nextPromise = Promise.make();
                            nextPromise.then(u -> IO.runAsync(((Kind)flatMapped.next.apply(u)).fix(IOOf::toIO), connection, stack, promise));
                            IO.executeAsync(async, connection, nextPromise);
                            return promise;
                        }
                        if (source instanceof Pure) {
                            Pure pure = (Pure)source;
                            current = ((Kind)flatMapped.next.apply(pure.value)).fix(IOOf::toIO);
                            continue;
                        }
                        if (!(source instanceof FlatMapped)) continue;
                        FlatMapped flatMapped2 = (FlatMapped)source;
                        current = ((IO)flatMapped2.current.fix(IOOf::toIO)).flatMap(a -> ((IO)((Kind)flatMapped2.next.apply(a)).fix(IOOf::toIO)).flatMap(flatMapped.next));
                        continue;
                    }
                    stack.pop();
                }
            }
            catch (Throwable error) {
                Option<IO<T>> result = stack.tryHandle(error);
                if (result.isPresent()) {
                    current = (Kind)result.getOrElseThrow();
                    continue;
                }
                return promise.failed(error);
            }
            break;
        }
    }

    private static <T, U> Kind<IO<?>, T> unwrap(Kind<IO<?>, T> current, CallStack<U> stack, Function1<Kind<IO<?>, ? extends T>, Kind<IO<?>, ? extends U>> next) {
        while (true) {
            if (current instanceof Failure) {
                Failure failure = (Failure)current;
                return (Kind)stack.sneakyThrow(failure.error);
            }
            if (current instanceof Recover) {
                Recover recover = (Recover)current;
                stack.add(recover.mapper.andThen(next));
                current = recover.current;
                continue;
            }
            if (!(current instanceof Suspend)) break;
            Suspend suspend = (Suspend)current;
            current = ((Kind)suspend.lazy.get()).fix(IOOf::toIO);
        }
        if (current instanceof Delay) {
            Delay delay = (Delay)current;
            return IO.pure(delay.task.get());
        }
        if (current instanceof Pure) {
            return current;
        }
        if (current instanceof FlatMapped) {
            return current;
        }
        if (current instanceof Async) {
            return current;
        }
        throw new IllegalStateException();
    }

    private static <T> Promise<T> executeAsync(Async<T> current, IOConnection connection, Promise<T> promise) {
        if (connection.isCancellable() && !connection.updateState((Operator1<StateIO>)((Operator1)StateIO::startingNow)).isRunnable()) {
            return promise.cancel();
        }
        connection.setCancelToken((Kind)current.callback.apply(arg_0 -> promise.tryComplete(arg_0)));
        promise.thenRun(() -> connection.setCancelToken(UNIT));
        if (connection.isCancellable() && connection.updateState((Operator1<StateIO>)((Operator1)StateIO::notStartingNow)).isCancellingNow()) {
            connection.cancelNow();
        }
        return promise;
    }

    private static <T> IO<T> repeat(IO<T> self, IO<Unit> pause, int times) {
        return self.redeemWith(IO::raiseError, value -> {
            if (times > 0) {
                return pause.andThen(IO.repeat(self, pause, times - 1));
            }
            return IO.pure(value);
        });
    }

    private static <T> IO<T> retry(IO<T> self, IO<Unit> pause, int maxRetries) {
        return self.redeemWith(error -> {
            if (maxRetries > 0) {
                return pause.andThen(IO.retry(self, (IO<Unit>)pause.repeat(), maxRetries - 1));
            }
            return IO.raiseError(error);
        }, IO::pure);
    }

    public static final class FlatMapped<T, R>
    implements IO<R> {
        private final Kind<IO<?>, ? extends T> current;
        private final Function1<? super T, ? extends Kind<IO<?>, ? extends R>> next;

        private FlatMapped(IO<? extends T> current, Function1<? super T, ? extends Kind<IO<?>, ? extends R>> next) {
            this.current = (Kind)Precondition.checkNonNull(current);
            this.next = (Function1)Precondition.checkNonNull(next);
        }

        public String toString() {
            return "FlatMapped(" + String.valueOf(this.current) + ", ?)";
        }
    }

    public static final class Recover<T>
    implements IO<T> {
        private final Kind<IO<?>, T> current;
        private final PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>> mapper;

        private Recover(IO<T> current, PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>> mapper) {
            this.current = (Kind)Precondition.checkNonNull(current);
            this.mapper = (PartialFunction1)Precondition.checkNonNull(mapper);
        }

        public String toString() {
            return "Recover(" + String.valueOf(this.current) + ", ?)";
        }
    }

    public static final class Pure<T>
    implements IO<T> {
        private final T value;

        private Pure(T value) {
            this.value = Precondition.checkNonNull(value);
        }

        public String toString() {
            return "Pure(" + String.valueOf(this.value) + ")";
        }
    }

    public static final class Failure<T>
    implements IO<T>,
    Recoverable {
        private final Throwable error;

        private Failure(Throwable error) {
            this.error = (Throwable)Precondition.checkNonNull((Object)error);
        }

        public String toString() {
            return "Failure(" + String.valueOf(this.error) + ")";
        }
    }

    public static final class Suspend<T>
    implements IO<T> {
        private final Producer<? extends Kind<IO<?>, ? extends T>> lazy;

        private Suspend(Producer<? extends Kind<IO<?>, ? extends T>> lazy) {
            this.lazy = (Producer)Precondition.checkNonNull(lazy);
        }

        public String toString() {
            return "Suspend(?)";
        }
    }

    public static final class Delay<T>
    implements IO<T> {
        private final Producer<? extends T> task;

        private Delay(Producer<? extends T> task) {
            this.task = (Producer)Precondition.checkNonNull(task);
        }

        public String toString() {
            return "Delay(?)";
        }
    }

    public static final class Async<T>
    implements IO<T> {
        private final Function1<Consumer1<? super Try<? extends T>>, Kind<IO<?>, Unit>> callback;

        private Async(Function1<Consumer1<? super Try<? extends T>>, Kind<IO<?>, Unit>> callback) {
            this.callback = (Function1)Precondition.checkNonNull(callback);
        }

        public String toString() {
            return "Async(?)";
        }
    }
}

