/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.IOOf;
import com.github.tonivade.purefun.monad.StateIO;
import java.util.concurrent.atomic.AtomicReference;

sealed interface IOConnection {
    public static final IOConnection UNCANCELLABLE = new Uncancellable();

    public boolean isCancellable();

    public void setCancelToken(Kind<IO<?>, Unit> var1);

    public void cancelNow();

    public void cancel();

    public StateIO updateState(Operator1<StateIO> var1);

    public static IOConnection cancellable() {
        return new Cancellable();
    }

    public static final class Cancellable
    implements IOConnection {
        private Kind<IO<?>, Unit> cancelToken = IO.UNIT;
        private final AtomicReference<StateIO> state = new AtomicReference<StateIO>(StateIO.INITIAL);

        private Cancellable() {
        }

        @Override
        public boolean isCancellable() {
            return true;
        }

        @Override
        public void setCancelToken(Kind<IO<?>, Unit> cancel) {
            this.cancelToken = (Kind)Precondition.checkNonNull(cancel);
        }

        @Override
        public void cancelNow() {
            ((IO)this.cancelToken.fix(IOOf::toIO)).runAsync();
        }

        @Override
        public void cancel() {
            if (this.state.getAndUpdate(StateIO::cancellingNow).isCancelable()) {
                this.cancelNow();
                this.state.set(StateIO.CANCELLED);
            }
        }

        @Override
        public StateIO updateState(Operator1<StateIO> update) {
            return this.state.updateAndGet(arg_0 -> update.apply(arg_0));
        }
    }

    public static final class Uncancellable
    implements IOConnection {
        private Uncancellable() {
        }

        @Override
        public boolean isCancellable() {
            return false;
        }

        @Override
        public void setCancelToken(Kind<IO<?>, Unit> cancel) {
        }

        @Override
        public void cancelNow() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public StateIO updateState(Operator1<StateIO> update) {
            return StateIO.INITIAL;
        }
    }
}

