/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.type.Option;
import java.util.concurrent.atomic.AtomicReference;

public final class Ref<A> {
    private final AtomicReference<A> value;

    private Ref(A value) {
        this.value = new AtomicReference<Object>(Precondition.checkNonNull(value));
    }

    public IO<A> get() {
        return IO.task(this::safeGet);
    }

    public IO<Unit> set(A newValue) {
        return IO.exec(() -> this.value.set(newValue));
    }

    public <B> IO<B> modify(Function1<A, Tuple2<B, A>> change) {
        return IO.task(() -> {
            boolean loop = true;
            Object result = null;
            while (loop) {
                A current = this.safeGet();
                Tuple2 tuple = (Tuple2)change.apply(current);
                result = tuple.get1();
                loop = !this.value.compareAndSet(current, tuple.get2());
            }
            return Option.of(result).getOrElseThrow();
        });
    }

    public IO<Unit> lazySet(A newValue) {
        return IO.task(() -> {
            this.value.lazySet(newValue);
            return Unit.unit();
        });
    }

    public IO<A> getAndSet(A newValue) {
        return IO.task(() -> this.value.getAndSet(newValue));
    }

    public IO<A> updateAndGet(Operator1<A> update) {
        return IO.task(() -> this.value.updateAndGet(arg_0 -> ((Operator1)update).apply(arg_0)));
    }

    public IO<A> getAndUpdate(Operator1<A> update) {
        return IO.task(() -> this.value.getAndUpdate(arg_0 -> ((Operator1)update).apply(arg_0)));
    }

    public static <A> IO<Ref<A>> make(A value) {
        return IO.pure(Ref.of(value));
    }

    public static <A> Ref<A> of(A value) {
        return new Ref<A>(value);
    }

    public String toString() {
        return String.format("Ref(%s)", this.value.get());
    }

    private A safeGet() {
        return this.value.get();
    }
}

