/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.IOOf;
import com.github.tonivade.purefun.type.Option;
import java.util.ArrayDeque;
import java.util.Deque;

final class StackItem<T> {
    private int count = 0;
    private final Deque<PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>>> recover = new ArrayDeque();
    @Nullable
    private final StackItem<T> prev;

    public StackItem() {
        this(null);
    }

    public StackItem(@Nullable StackItem<T> prev) {
        this.prev = prev;
    }

    @Nullable
    public StackItem<T> prev() {
        return this.prev;
    }

    public int count() {
        return this.count;
    }

    public void push() {
        ++this.count;
    }

    public void pop() {
        --this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public void add(PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>> mapError) {
        this.recover.addFirst(mapError);
    }

    public Option<IO<T>> tryHandle(Throwable error) {
        while (!this.recover.isEmpty()) {
            PartialFunction1<? super Throwable, ? extends Kind<IO<?>, ? extends T>> mapError = this.recover.removeFirst();
            if (!mapError.isDefinedAt((Object)error)) continue;
            return Option.some((Object)((IO)((Kind)mapError.apply((Object)error)).fix(IOOf::toIO)));
        }
        return Option.none();
    }
}

