/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.monad.StateOf;

@FunctionalInterface
@HigherKind
public interface State<S, A>
extends StateOf<S, A>,
Bindable<State<S, ?>, A> {
    public Tuple2<S, A> run(S var1);

    default public <R> State<S, R> map(Function1<? super A, ? extends R> mapper) {
        return this.flatMap(value -> State.pure(mapper.apply(value)));
    }

    default public <R> State<S, R> flatMap(Function1<? super A, ? extends Kind<State<S, ?>, ? extends R>> mapper) {
        return state -> {
            Tuple2<Object, A> run = this.run(state);
            State narrowK = (State)mapper.andThen(StateOf::toState).apply(run.get2());
            return narrowK.run(run.get1());
        };
    }

    default public <R> State<S, R> andThen(Kind<State<S, ?>, ? extends R> next) {
        return this.flatMap(ignore -> next);
    }

    default public A eval(S state) {
        return (A)this.run(state).get2();
    }

    default public S runS(S state) {
        return (S)this.run(state).get1();
    }

    public static <S, A> State<S, A> state(Function1<S, Tuple2<S, A>> runState) {
        return arg_0 -> runState.apply(arg_0);
    }

    public static <S, A> State<S, A> pure(A value) {
        return state -> Tuple2.of((Object)state, (Object)value);
    }

    public static <S> State<S, S> get() {
        return state -> Tuple2.of((Object)state, (Object)state);
    }

    public static <S> State<S, Unit> set(S value) {
        return state -> Tuple2.of((Object)value, (Object)Unit.unit());
    }

    public static <S> State<S, Unit> modify(Operator1<S> mapper) {
        return state -> Tuple2.of((Object)mapper.apply(state), (Object)Unit.unit());
    }

    public static <S, A> State<S, A> inspect(Function1<? super S, ? extends A> mapper) {
        return state -> Tuple2.of((Object)state, (Object)mapper.apply(state));
    }

    public static <S, A> State<S, Sequence<A>> traverse(Sequence<State<S, A>> states) {
        return (State)states.foldLeft(State.pure(ImmutableList.empty()), (sa, sb) -> State.map2(sa, sb, Sequence::append));
    }

    public static <S, A, B, C> State<S, C> map2(State<S, ? extends A> sa, State<S, ? extends B> sb, Function2<? super A, ? super B, ? extends C> mapper) {
        return sa.flatMap(a -> sb.map(b -> ((Function1)mapper.curried().apply(a)).apply(b)));
    }
}

