/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

final class StateIO {
    public static final StateIO INITIAL = new StateIO(false, false, false);
    public static final StateIO CANCELLED = new StateIO(true, false, false);
    private final boolean isCancelled;
    private final boolean cancellingNow;
    private final boolean startingNow;

    public StateIO(boolean isCancelled, boolean cancellingNow, boolean startingNow) {
        this.isCancelled = isCancelled;
        this.cancellingNow = cancellingNow;
        this.startingNow = startingNow;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isCancellingNow() {
        return this.cancellingNow;
    }

    public boolean isStartingNow() {
        return this.startingNow;
    }

    public StateIO cancellingNow() {
        return new StateIO(this.isCancelled, true, this.startingNow);
    }

    public StateIO startingNow() {
        return new StateIO(this.isCancelled, this.cancellingNow, true);
    }

    public StateIO notStartingNow() {
        return new StateIO(this.isCancelled, this.cancellingNow, false);
    }

    public boolean isCancelable() {
        return !this.isCancelled && !this.cancellingNow && !this.startingNow;
    }

    public boolean isRunnable() {
        return !this.isCancelled && !this.cancellingNow;
    }
}

