/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.monad.WriterOf;
import com.github.tonivade.purefun.typeclasses.Monoid;

@HigherKind
public interface Writer<L, A>
extends WriterOf<L, A>,
Bindable<Writer<L, ?>, A> {
    public Monoid<L> monoid();

    public Tuple2<L, A> value();

    default public A getValue() {
        return (A)this.value().get2();
    }

    default public L getLog() {
        return (L)this.value().get1();
    }

    default public <B> Writer<L, B> map(Function1<? super A, ? extends B> mapper) {
        return this.bimap(this.monoid(), Function1.identity(), mapper);
    }

    default public <R> Writer<R, A> mapLog(Monoid<R> monoidR, Function1<? super L, ? extends R> mapper) {
        return this.bimap(monoidR, mapper, Function1.identity());
    }

    default public Writer<L, A> append(L log2) {
        return this.mapLog(this.monoid(), log1 -> this.monoid().combine(log1, log2));
    }

    default public Writer<L, A> reset() {
        return this.mapLog(this.monoid(), Function1.cons((Object)this.monoid().zero()));
    }

    default public <V, R> Writer<V, R> bimap(Monoid<V> monoidV, Function1<? super L, ? extends V> mapper1, Function1<? super A, ? extends R> mapper2) {
        return Writer.writer(monoidV, this.value().map(mapper1, mapper2));
    }

    default public <B> Writer<L, B> flatMap(Function1<? super A, ? extends Kind<Writer<L, ?>, ? extends B>> mapper) {
        Writer apply = (Writer)mapper.andThen(WriterOf::toWriter).apply(this.value().get2());
        Tuple2 combine = this.value().map1(log -> this.monoid().combine(log, apply.getLog()));
        return Writer.writer(this.monoid(), Tuple.of((Object)combine.get1(), apply.getValue()));
    }

    default public <R> Writer<L, R> andThen(Kind<Writer<L, ?>, ? extends R> next) {
        return this.flatMap(ignore -> next);
    }

    public static <L, A> Writer<L, A> pure(Monoid<L> monoid, A value) {
        return Writer.writer(monoid, Tuple.of((Object)monoid.zero(), value));
    }

    public static <L, A> Writer<L, A> writer(final Monoid<L> monoid, final Tuple2<L, A> value) {
        return new Writer<L, A>(){

            @Override
            public Monoid<L> monoid() {
                return monoid;
            }

            @Override
            public Tuple2<L, A> value() {
                return value;
            }
        };
    }
}

