/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.stream;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.stream.Nil;
import com.github.tonivade.purefun.stream.PureStream;
import com.github.tonivade.purefun.stream.PureStreamOf;
import com.github.tonivade.purefun.stream.Suspend;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.MonadDefer;

public final class Cons<F extends Kind<F, ?>, T>
implements PureStream<F, T> {
    private final MonadDefer<F> monad;
    private final Kind<F, T> head;
    private final PureStream<F, T> tail;

    Cons(MonadDefer<F> monad, Kind<F, T> head, PureStream<F, T> tail) {
        this.monad = (MonadDefer)Precondition.checkNonNull(monad);
        this.head = (Kind)Precondition.checkNonNull(head);
        this.tail = (PureStream)Precondition.checkNonNull(tail);
    }

    @Override
    public Kind<F, Option<T>> headOption() {
        return this.monad.map(this.head, Option::some);
    }

    @Override
    public Kind<F, Option<Tuple2<Kind<F, T>, PureStream<F, T>>>> split() {
        return this.monad.pure((Object)Option.some((Object)Tuple.of(this.head, this.tail)));
    }

    @Override
    public PureStream<F, T> concat(PureStream<F, ? extends T> other) {
        return this.suspend(() -> this.cons(this.head, this.tail.concat(other)));
    }

    @Override
    public PureStream<F, T> append(Kind<F, ? extends T> other) {
        return this.suspend(() -> this.cons(this.head, this.tail.append(other)));
    }

    @Override
    public PureStream<F, T> prepend(Kind<F, ? extends T> other) {
        return this.suspend(() -> this.cons(Kind.narrowK((Kind)other), this.tail.prepend(this.head)));
    }

    @Override
    public PureStream<F, T> take(int n) {
        return n > 0 ? this.suspend(() -> this.cons(this.head, this.tail.take(n - 1))) : this.empty();
    }

    @Override
    public PureStream<F, T> drop(int n) {
        return n > 0 ? this.suspend(() -> this.tail.drop(n - 1)) : this;
    }

    @Override
    public PureStream<F, T> takeWhile(Matcher1<? super T> matcher) {
        return this.suspendF(() -> this.monad.map(this.head, t -> matcher.match(t) ? this.cons(this.head, this.tail.takeWhile(matcher)) : this.empty()));
    }

    @Override
    public PureStream<F, T> dropWhile(Matcher1<? super T> matcher) {
        return this.suspendF(() -> this.monad.map(this.head, t -> matcher.match(t) ? this.tail.dropWhile(matcher) : this));
    }

    @Override
    public PureStream<F, T> filter(Matcher1<? super T> matcher) {
        return this.suspendF(() -> this.monad.map(this.head, t -> matcher.match(t) ? this.cons(this.head, this.tail.filter(matcher)) : this.tail.filter(matcher)));
    }

    @Override
    public <R> PureStream<F, R> collect(PartialFunction1<? super T, ? extends R> partial) {
        return this.suspendF(() -> this.monad.map(this.head, t -> partial.isDefinedAt(t) ? this.cons(this.monad.map(this.head, arg_0 -> ((PartialFunction1)partial).apply(arg_0)), this.tail.collect(partial)) : this.tail.collect(partial)));
    }

    @Override
    public <R> Kind<F, R> foldLeft(R begin, Function2<? super R, ? super T, ? extends R> combinator) {
        return this.monad.flatMap(this.head, h -> this.tail.foldLeft(combinator.apply(begin, h), combinator));
    }

    @Override
    public <R> Kind<F, R> foldRight(Kind<F, ? extends R> begin, Function2<? super T, ? super Kind<F, ? extends R>, ? extends Kind<F, ? extends R>> combinator) {
        return this.monad.flatMap(this.head, h -> this.tail.foldRight((Kind)combinator.apply(h, (Object)begin), combinator));
    }

    @Override
    public Kind<F, Boolean> exists(Matcher1<? super T> matcher) {
        return this.foldRight(this.monad.pure((Object)false), (t, acc) -> matcher.match(t) ? this.monad.pure((Object)true) : acc);
    }

    @Override
    public Kind<F, Boolean> forall(Matcher1<? super T> matcher) {
        return this.foldRight(this.monad.pure((Object)true), (t, acc) -> matcher.match(t) ? acc : this.monad.pure((Object)false));
    }

    @Override
    public <R> PureStream<F, R> map(Function1<? super T, ? extends R> map) {
        return this.suspend(() -> this.cons(this.monad.map(this.head, map), this.suspend(() -> this.tail.map(map))));
    }

    @Override
    public <R> PureStream<F, R> mapEval(Function1<? super T, ? extends Kind<F, ? extends R>> mapper) {
        return this.suspend(() -> this.cons(this.monad.flatMap(this.head, mapper), this.suspend(() -> this.tail.mapEval(mapper))));
    }

    @Override
    public <R> PureStream<F, R> flatMap(Function1<? super T, ? extends Kind<PureStream<F, ?>, ? extends R>> map) {
        return this.suspendF(() -> this.monad.map(this.monad.map(this.head, map.andThen(PureStreamOf::toPureStream)), s -> s.concat(this.tail.flatMap(map))));
    }

    @Override
    public PureStream<F, T> repeat() {
        return this.concat(this.suspend(this::repeat));
    }

    @Override
    public PureStream<F, T> intersperse(Kind<F, ? extends T> value) {
        return this.suspend(() -> this.cons(this.head, this.suspend(() -> this.cons(Kind.narrowK((Kind)value), this.tail.intersperse(value)))));
    }

    private <R> PureStream<F, R> cons(Kind<F, R> h, PureStream<F, R> t) {
        return new Cons<F, R>(this.monad, h, t);
    }

    private <R> PureStream<F, R> suspend(Producer<PureStream<F, R>> stream) {
        return this.suspendF(stream.map(arg_0 -> this.monad.pure(arg_0)));
    }

    private <R> PureStream<F, R> suspendF(Producer<Kind<F, PureStream<F, R>>> stream) {
        return new Suspend(this.monad, this.monad.defer(stream));
    }

    private PureStream<F, T> empty() {
        return new Nil(this.monad);
    }
}

