/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.stream;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.stream.Cons;
import com.github.tonivade.purefun.stream.Nil;
import com.github.tonivade.purefun.stream.PureStreamOf;
import com.github.tonivade.purefun.stream.Suspend;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import java.util.Arrays;
import java.util.stream.Stream;

@HigherKind
public sealed interface PureStream<F extends Kind<F, ?>, T>
extends PureStreamOf<F, T>,
Bindable<PureStream<F, ?>, T>
permits Cons, Suspend, Nil {
    default public PureStream<F, T> head() {
        return this.take(1);
    }

    default public PureStream<F, T> tail() {
        return this.drop(1);
    }

    public Kind<F, Option<T>> headOption();

    public Kind<F, Option<Tuple2<Kind<F, T>, PureStream<F, T>>>> split();

    public PureStream<F, T> concat(PureStream<F, ? extends T> var1);

    public PureStream<F, T> append(Kind<F, ? extends T> var1);

    public PureStream<F, T> prepend(Kind<F, ? extends T> var1);

    public PureStream<F, T> take(int var1);

    public PureStream<F, T> drop(int var1);

    public PureStream<F, T> filter(Matcher1<? super T> var1);

    public PureStream<F, T> takeWhile(Matcher1<? super T> var1);

    public PureStream<F, T> dropWhile(Matcher1<? super T> var1);

    default public PureStream<F, T> filterNot(Matcher1<? super T> matcher) {
        return this.filter(matcher.negate());
    }

    public <R> PureStream<F, R> collect(PartialFunction1<? super T, ? extends R> var1);

    public <R> Kind<F, R> foldLeft(R var1, Function2<? super R, ? super T, ? extends R> var2);

    public <R> Kind<F, R> foldRight(Kind<F, ? extends R> var1, Function2<? super T, ? super Kind<F, ? extends R>, ? extends Kind<F, ? extends R>> var2);

    public <R> PureStream<F, R> map(Function1<? super T, ? extends R> var1);

    public <R> PureStream<F, R> flatMap(Function1<? super T, ? extends Kind<PureStream<F, ?>, ? extends R>> var1);

    default public <R> PureStream<F, R> andThen(Kind<PureStream<F, ?>, ? extends R> next) {
        return this.flatMap(ignore -> next);
    }

    public <R> PureStream<F, R> mapEval(Function1<? super T, ? extends Kind<F, ? extends R>> var1);

    public PureStream<F, T> repeat();

    public PureStream<F, T> intersperse(Kind<F, ? extends T> var1);

    public Kind<F, Boolean> exists(Matcher1<? super T> var1);

    public Kind<F, Boolean> forall(Matcher1<? super T> var1);

    default public <G extends Kind<G, ?>, R> PureStream<G, R> through(Function1<PureStream<F, T>, PureStream<G, R>> function) {
        return (PureStream)function.apply((Object)this);
    }

    default public Kind<F, Sequence<T>> asSequence() {
        return this.foldLeft(ImmutableList.empty(), Sequence::append);
    }

    default public Kind<F, String> asString() {
        return this.foldLeft("", (acc, a) -> acc + String.valueOf(a));
    }

    default public Kind<F, Unit> drain() {
        return this.foldLeft(Unit.unit(), (acc, a) -> acc);
    }

    default public <R> PureStream<F, R> mapReplace(Kind<F, ? extends R> next) {
        return this.mapEval(ignore -> next);
    }

    public static <F extends Kind<F, ?>> Of<F> of(MonadDefer<F> monad) {
        return () -> monad;
    }

    public static <F extends Kind<F, ?>> Of<F> of(Class<F> type) {
        return PureStream.of(Instances.monadDefer(type, (Object[])new Object[0]));
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>> Of<F> of(F ... reified) {
        return PureStream.of(Instances.monadDefer(reified));
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> empty(F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).empty();
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> pure(T value, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).pure(value);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> cons(T head, PureStream<F, ? extends T> tail, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).cons(head, tail);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> suspend(Producer<? extends PureStream<F, ? extends T>> lazy, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).suspend(lazy);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> eval(Kind<F, ? extends T> value, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).eval(value);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> from(Iterable<? extends T> iterable, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).from(iterable);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> from(Stream<? extends T> stream, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).from(stream);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> from(Sequence<? extends T> sequence, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).from(sequence);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T, S> PureStream<F, T> unfold(S seed, Function1<? super S, Option<Tuple2<? extends T, ? extends S>>> function, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).unfold(seed, function);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> iterate(T seed, Operator1<T> generator, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).iterate(seed, generator);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, T> PureStream<F, T> iterate(Producer<? extends T> generator, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).iterate(generator);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, A, B, R> PureStream<F, R> zipWith(PureStream<F, ? extends A> s1, PureStream<F, ? extends B> s2, Function2<? super A, ? super B, ? extends R> combinator, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).zipWith(s1, s2, combinator);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, A, B> PureStream<F, Tuple2<A, B>> zip(PureStream<F, ? extends A> s1, PureStream<F, ? extends B> s2, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).zip(s1, s2);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, A> PureStream<F, Tuple2<A, Integer>> zipWithIndex(PureStream<F, ? extends A> stream, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).zipWithIndex(stream);
    }

    @SafeVarargs
    public static <F extends Kind<F, ?>, A> PureStream<F, A> merge(PureStream<F, A> s1, PureStream<F, A> s2, F ... reified) {
        return PureStream.of(Instances.monadDefer(reified)).merge(s1, s2);
    }

    public static interface Of<F extends Kind<F, ?>> {
        public MonadDefer<F> monadDefer();

        default public <T> PureStream<F, T> empty() {
            return new Nil(this.monadDefer());
        }

        default public <T> PureStream<F, T> of(T ... values) {
            return this.from(Arrays.stream(values));
        }

        default public <T> PureStream<F, T> pure(T value) {
            return this.eval(this.monadDefer().pure(value));
        }

        default public <T> PureStream<F, T> cons(T head, PureStream<F, ? extends T> tail) {
            return this.pure(head).concat(tail);
        }

        default public <T> PureStream<F, T> suspend(Producer<? extends PureStream<F, ? extends T>> lazy) {
            return new Suspend(this.monadDefer(), this.monadDefer().defer(lazy.andThen(PureStreamOf::toPureStream).map(arg_0 -> this.monadDefer().pure(arg_0))));
        }

        default public <T> PureStream<F, T> eval(Kind<F, ? extends T> value) {
            return new Cons<F, T>(this.monadDefer(), Kind.narrowK(value), this.empty());
        }

        default public <T> PureStream<F, T> from(Iterable<? extends T> iterable) {
            return this.from(Sequence.asStream(iterable.iterator()));
        }

        default public <T> PureStream<F, T> from(Stream<? extends T> stream) {
            return this.from((Sequence<? extends T>)ImmutableList.from(stream));
        }

        default public <T> PureStream<F, T> from(Sequence<? extends T> sequence) {
            return (PureStream)sequence.foldLeft(this.empty(), (acc, a) -> acc.append(this.monadDefer().pure(a)));
        }

        default public <T, S> PureStream<F, T> unfold(S seed, Function1<? super S, Option<Tuple2<? extends T, ? extends S>>> function) {
            return this.suspend(() -> this.doUnfold(seed, function));
        }

        default public <T> PureStream<F, T> iterate(T seed, Operator1<T> generator) {
            return this.cons(seed, this.suspend(() -> this.iterate(generator.apply(seed), generator)));
        }

        default public <T> PureStream<F, T> iterate(Producer<? extends T> generator) {
            return this.unfold(Unit.unit(), unit -> Option.of((Producer)generator).map(next -> Tuple.of((Object)next, (Object)unit)));
        }

        default public <A, B, R> PureStream<F, R> zipWith(PureStream<F, ? extends A> s1, PureStream<F, ? extends B> s2, Function2<? super A, ? super B, ? extends R> combinator) {
            return new Suspend(this.monadDefer(), this.monadDefer().defer(() -> this.monadDefer().mapN(s1.split(), s2.split()).apply((op1, op2) -> {
                Option result = Option.map2((Option)op1, (Option)op2, (t1, t2) -> {
                    Kind head = this.monadDefer().mapN((Kind)t1.get1(), (Kind)t2.get1()).apply(combinator);
                    PureStream tail = this.zipWith((PureStream)t1.get2(), (PureStream)t2.get2(), combinator);
                    return new Cons(this.monadDefer(), head, tail);
                });
                return (PureStream)result.getOrElse(this::empty);
            })));
        }

        default public <A, B> PureStream<F, Tuple2<A, B>> zip(PureStream<F, ? extends A> s1, PureStream<F, ? extends B> s2) {
            return this.zipWith(s1, s2, Tuple2::of);
        }

        default public <A> PureStream<F, Tuple2<A, Integer>> zipWithIndex(PureStream<F, ? extends A> stream) {
            return this.zip(stream, this.iterate(0, x -> x + 1));
        }

        default public <A> PureStream<F, A> merge(PureStream<F, A> s1, PureStream<F, A> s2) {
            return new Suspend(this.monadDefer(), this.monadDefer().defer(() -> this.monadDefer().mapN(s1.split(), s2.split()).apply((opt1, opt2) -> {
                Option result = Option.map2((Option)opt1, (Option)opt2, (t1, t2) -> {
                    Kind head = (Kind)t1.get1();
                    PureStream tail = this.eval((Kind)t2.get1()).concat(this.merge((PureStream)t1.get2(), (PureStream)t2.get2()));
                    return new Cons(this.monadDefer(), head, tail);
                });
                return (PureStream)result.getOrElse(this::empty);
            })));
        }

        private <T, S> PureStream<F, T> doUnfold(S seed, Function1<? super S, Option<Tuple2<? extends T, ? extends S>>> function) {
            return (PureStream)((Option)function.apply(seed)).map(tuple -> (PureStream)tuple.applyTo((t, s) -> this.cons(t, this.suspend(() -> this.doUnfold(s, function))))).getOrElse(this::empty);
        }
    }
}

