/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.stream;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.stream.PureStream;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.MonadDefer;

public final class Suspend<F extends Kind<F, ?>, T>
implements PureStream<F, T> {
    private final MonadDefer<F> monad;
    private final Kind<F, PureStream<F, T>> evalStream;

    Suspend(MonadDefer<F> monad, Kind<F, PureStream<F, T>> stream) {
        this.monad = (MonadDefer)Precondition.checkNonNull(monad);
        this.evalStream = (Kind)Precondition.checkNonNull(stream);
    }

    @Override
    public Kind<F, Option<T>> headOption() {
        return this.monad.flatMap(this.evalStream, PureStream::headOption);
    }

    @Override
    public Kind<F, Option<Tuple2<Kind<F, T>, PureStream<F, T>>>> split() {
        return this.monad.flatMap(this.evalStream, PureStream::split);
    }

    @Override
    public PureStream<F, T> concat(PureStream<F, ? extends T> other) {
        return this.lazyMap(s -> s.concat(other));
    }

    @Override
    public PureStream<F, T> append(Kind<F, ? extends T> other) {
        return this.lazyMap(s -> s.append(other));
    }

    @Override
    public PureStream<F, T> prepend(Kind<F, ? extends T> other) {
        return this.lazyMap(s -> s.prepend(other));
    }

    @Override
    public PureStream<F, T> take(int n) {
        return this.lazyMap(s -> s.take(n));
    }

    @Override
    public PureStream<F, T> drop(int n) {
        return this.lazyMap(s -> s.drop(n));
    }

    @Override
    public PureStream<F, T> takeWhile(Matcher1<? super T> matcher) {
        return this.lazyMap(s -> s.takeWhile(matcher));
    }

    @Override
    public PureStream<F, T> dropWhile(Matcher1<? super T> matcher) {
        return this.lazyMap(s -> s.dropWhile(matcher));
    }

    @Override
    public PureStream<F, T> filter(Matcher1<? super T> matcher) {
        return this.lazyMap(s -> s.filter(matcher));
    }

    @Override
    public <R> PureStream<F, R> collect(PartialFunction1<? super T, ? extends R> partial) {
        return this.lazyMap(s -> s.collect(partial));
    }

    @Override
    public <R> Kind<F, R> foldLeft(R begin, Function2<? super R, ? super T, ? extends R> combinator) {
        return this.monad.flatMap(this.evalStream, s -> s.foldLeft(begin, combinator));
    }

    @Override
    public <R> Kind<F, R> foldRight(Kind<F, ? extends R> begin, Function2<? super T, ? super Kind<F, ? extends R>, ? extends Kind<F, ? extends R>> combinator) {
        return this.monad.flatMap(this.evalStream, s -> s.foldRight(begin, combinator));
    }

    @Override
    public Kind<F, Boolean> exists(Matcher1<? super T> matcher) {
        return this.monad.flatMap(this.evalStream, s -> s.exists(matcher));
    }

    @Override
    public Kind<F, Boolean> forall(Matcher1<? super T> matcher) {
        return this.monad.flatMap(this.evalStream, s -> s.forall(matcher));
    }

    @Override
    public <R> PureStream<F, R> map(Function1<? super T, ? extends R> mapper) {
        return this.lazyMap(s -> s.map(mapper));
    }

    @Override
    public <R> PureStream<F, R> mapEval(Function1<? super T, ? extends Kind<F, ? extends R>> mapper) {
        return this.suspend(() -> this.monad.map(this.evalStream, s -> s.mapEval(mapper)));
    }

    @Override
    public <R> PureStream<F, R> flatMap(Function1<? super T, ? extends Kind<PureStream<F, ?>, ? extends R>> map) {
        return this.lazyMap(s -> s.flatMap(map));
    }

    @Override
    public PureStream<F, T> repeat() {
        return this.lazyMap(PureStream::repeat);
    }

    @Override
    public PureStream<F, T> intersperse(Kind<F, ? extends T> value) {
        return this.lazyMap(s -> s.intersperse(value));
    }

    private <R> PureStream<F, R> lazyMap(Function1<PureStream<F, T>, PureStream<F, R>> mapper) {
        return this.suspend(() -> this.monad.map(this.evalStream, mapper));
    }

    private <R> PureStream<F, R> suspend(Producer<Kind<F, PureStream<F, R>>> stream) {
        return new Suspend<F, T>(this.monad, this.monad.defer(stream));
    }
}

