/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.transformer;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.transformer.OptionTOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Monad;

@HigherKind
public interface OptionT<F extends Kind<F, ?>, T>
extends OptionTOf<F, T>,
Bindable<OptionT<F, ?>, T> {
    public Monad<F> monad();

    public Kind<F, Option<T>> value();

    default public <R> OptionT<F, R> map(Function1<? super T, ? extends R> map) {
        return OptionT.of(this.monad(), this.monad().map(this.value(), v -> v.map(map)));
    }

    default public <R> OptionT<F, R> flatMap(Function1<? super T, ? extends Kind<OptionT<F, ?>, ? extends R>> map) {
        return OptionT.of(this.monad(), this.flatMapF(v -> ((OptionT)map.andThen(OptionTOf::toOptionT).apply(v)).value()));
    }

    default public <R> Kind<F, R> fold(Producer<? extends R> orElse, Function1<? super T, ? extends R> map) {
        return this.monad().map(this.value(), v -> v.fold(orElse, map));
    }

    default public <G extends Kind<G, ?>> OptionT<G, T> mapK(Monad<G> other, FunctionK<F, G> functionK) {
        return OptionT.of(other, functionK.apply(this.value()));
    }

    default public Kind<F, T> getOrElseThrow() {
        return this.monad().map(this.value(), Option::getOrElseThrow);
    }

    default public Kind<F, Boolean> isEmpty() {
        return this.monad().map(this.value(), Option::isEmpty);
    }

    default public Kind<F, T> getOrElse(T orElse) {
        return this.getOrElse(Producer.cons(orElse));
    }

    default public Kind<F, T> getOrElse(Producer<? extends T> orElse) {
        return this.fold(orElse, Function1.identity());
    }

    default public OptionT<F, T> filter(Matcher1<? super T> filter) {
        return OptionT.of(this.monad(), this.monad().map(this.value(), v -> v.filter(filter)));
    }

    default public OptionT<F, T> filterNot(Matcher1<? super T> matcher) {
        return this.filter(matcher.negate());
    }

    public static <F extends Kind<F, ?>, T> OptionT<F, T> lift(Monad<F> monad, Option<T> value) {
        return OptionT.of(monad, monad.pure(value));
    }

    public static <F extends Kind<F, ?>, T> OptionT<F, T> of(final Monad<F> monad, final Kind<F, Option<T>> value) {
        Precondition.checkNonNull(monad);
        Precondition.checkNonNull(value);
        return new OptionT<F, T>(){

            @Override
            public Monad<F> monad() {
                return monad;
            }

            @Override
            public Kind<F, Option<T>> value() {
                return value;
            }
        };
    }

    public static <F extends Kind<F, ?>, T> OptionT<F, T> some(Monad<F> monad, T value) {
        return OptionT.lift(monad, Option.some(value));
    }

    public static <F extends Kind<F, ?>, T> OptionT<F, T> none(Monad<F> monad) {
        return OptionT.lift(monad, Option.none());
    }

    default public <R> Kind<F, Option<R>> flatMapF(Function1<? super T, ? extends Kind<F, ? extends Option<R>>> map) {
        return this.monad().flatMap(this.value(), v -> (Kind)v.fold(Producer.cons((Object)this.monad().pure((Object)Option.none())), map));
    }
}

