/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.transformer;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Function2;
import com.github.tonivade.purefun.core.Operator1;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.transformer.StateTOf;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Monad;

@HigherKind
public interface StateT<F extends Kind<F, ?>, S, A>
extends StateTOf<F, S, A>,
Bindable<StateT<F, S, ?>, A> {
    public Monad<F> monad();

    public Kind<F, Tuple2<S, A>> run(S var1);

    default public Kind<F, A> eval(S state) {
        return this.monad().map(this.run(state), Tuple2::get2);
    }

    default public <R> StateT<F, S, R> map(Function1<? super A, ? extends R> map) {
        return this.flatMap(value -> StateT.pure(this.monad(), map.apply(value)));
    }

    default public <R> StateT<F, S, R> flatMap(Function1<? super A, ? extends Kind<StateT<F, S, ?>, ? extends R>> map) {
        return StateT.state(this.monad(), state -> {
            Kind<F, Tuple2<Object, A>> newState = this.run(state);
            return this.monad().flatMap(newState, state2 -> ((StateT)map.andThen(StateTOf::toStateT).apply(state2.get2())).run(state2.get1()));
        });
    }

    default public <G extends Kind<G, ?>> StateT<G, S, A> mapK(Monad<G> other, FunctionK<F, G> functionK) {
        return StateT.state(other, state -> functionK.apply(this.run(state)));
    }

    public static <F extends Kind<F, ?>, S, A> StateT<F, S, A> state(final Monad<F> monad, final Function1<S, Kind<F, Tuple2<S, A>>> run) {
        return new StateT<F, S, A>(){

            @Override
            public Monad<F> monad() {
                return monad;
            }

            @Override
            public Kind<F, Tuple2<S, A>> run(S state) {
                return (Kind)run.apply(state);
            }
        };
    }

    public static <F extends Kind<F, ?>, S, A> StateT<F, S, A> lift(Monad<F> monad, Function1<S, Tuple2<S, A>> run) {
        return StateT.state(monad, run.andThen(arg_0 -> monad.pure(arg_0)));
    }

    public static <F extends Kind<F, ?>, S, A> StateT<F, S, A> pure(Monad<F> monad, A value) {
        return StateT.lift(monad, state -> Tuple2.of((Object)state, (Object)value));
    }

    public static <F extends Kind<F, ?>, S> StateT<F, S, S> get(Monad<F> monad) {
        return StateT.lift(monad, state -> Tuple2.of((Object)state, (Object)state));
    }

    public static <F extends Kind<F, ?>, S> StateT<F, S, Unit> set(Monad<F> monad, S value) {
        return StateT.lift(monad, state -> Tuple2.of((Object)value, (Object)Unit.unit()));
    }

    public static <F extends Kind<F, ?>, S> StateT<F, S, Unit> modify(Monad<F> monad, Operator1<S> mapper) {
        return StateT.lift(monad, state -> Tuple2.of((Object)mapper.apply(state), (Object)Unit.unit()));
    }

    public static <F extends Kind<F, ?>, S, A> StateT<F, S, A> inspect(Monad<F> monad, Function1<S, A> mapper) {
        return StateT.lift(monad, state -> Tuple2.of((Object)state, (Object)mapper.apply(state)));
    }

    public static <F extends Kind<F, ?>, S, A> StateT<F, S, Sequence<A>> traverse(Monad<F> monad, Sequence<StateT<F, S, A>> states) {
        return (StateT)states.foldLeft(StateT.pure(monad, ImmutableList.empty()), (xs, a) -> StateT.map2(xs, a, Sequence::append));
    }

    public static <F extends Kind<F, ?>, S, A, B, C> StateT<F, S, C> map2(StateT<F, S, ? extends A> sa, StateT<F, S, ? extends B> sb, Function2<? super A, ? super B, ? extends C> mapper) {
        return sa.flatMap(a -> sb.map(b -> ((Function1)mapper.curried().apply(a)).apply(b)));
    }

    public static <F extends Kind<F, ?>, S, A> StateT<F, S, A> of(Monad<F> monad, Function1<S, Kind<F, Tuple2<S, A>>> run) {
        return StateT.state(monad, run);
    }
}

