/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.transformer;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.transformer.EitherTOf;
import com.github.tonivade.purefun.transformer.OptionT;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Monad;

@HigherKind
public interface EitherT<F extends Kind<F, ?>, L, R>
extends EitherTOf<F, L, R>,
Bindable<EitherT<F, L, ?>, R> {
    public Monad<F> monad();

    public Kind<F, Either<L, R>> value();

    default public <V> EitherT<F, L, V> map(Function1<? super R, ? extends V> map) {
        return EitherT.of(this.monad(), this.monad().map(this.value(), v -> v.map(map)));
    }

    default public <V> EitherT<F, L, V> flatMap(Function1<? super R, ? extends Kind<EitherT<F, L, ?>, ? extends V>> map) {
        return EitherT.of(this.monad(), this.flatMapF(v -> ((EitherT)map.andThen(EitherTOf::toEitherT).apply(v)).value()));
    }

    default public <V> EitherT<F, L, V> andThen(Kind<EitherT<F, L, ?>, ? extends V> next) {
        return this.flatMap(ignore -> next);
    }

    default public <T, V> EitherT<F, T, V> bimap(Function1<? super L, ? extends T> leftMapper, Function1<? super R, ? extends V> rightMapper) {
        return EitherT.of(this.monad(), this.monad().map(this.value(), v -> v.bimap(leftMapper, rightMapper)));
    }

    default public <T> EitherT<F, T, R> mapLeft(Function1<? super L, ? extends T> leftMapper) {
        return EitherT.of(this.monad(), this.monad().map(this.value(), v -> v.mapLeft(leftMapper)));
    }

    default public <V> Kind<F, V> fold(Function1<? super L, ? extends V> leftMapper, Function1<? super R, ? extends V> rightMapper) {
        return this.monad().map(this.value(), v -> v.fold(leftMapper, rightMapper));
    }

    default public <G extends Kind<G, ?>> EitherT<G, L, R> mapK(Monad<G> other, FunctionK<F, G> functionK) {
        return EitherT.of(other, functionK.apply(this.value()));
    }

    default public EitherT<F, L, R> filterOrElse(Matcher1<R> filter, Producer<Either<L, R>> orElse) {
        return EitherT.of(this.monad(), this.monad().map(this.value(), v -> v.filterOrElse(filter, orElse)));
    }

    default public EitherT<F, R, L> swap() {
        return EitherT.of(this.monad(), this.monad().map(this.value(), Either::swap));
    }

    default public Kind<F, Boolean> isRight() {
        return this.monad().map(this.value(), Either::isRight);
    }

    default public Kind<F, Boolean> isLeft() {
        return this.monad().map(this.value(), Either::isLeft);
    }

    default public Kind<F, L> getLeft() {
        return this.monad().map(this.value(), Either::getLeft);
    }

    default public Kind<F, R> getRight() {
        return this.monad().map(this.value(), Either::getRight);
    }

    default public Kind<F, R> get() {
        return this.getRight();
    }

    default public Kind<F, R> getOrElse(R orElse) {
        return this.getOrElse(Producer.cons(orElse));
    }

    default public Kind<F, R> getOrElse(Producer<? extends R> orElse) {
        return this.fold(left -> orElse.get(), Function1.identity());
    }

    default public OptionT<F, R> toOption() {
        return OptionT.of(this.monad(), this.monad().map(this.value(), Either::toOption));
    }

    public static <F extends Kind<F, ?>, L, R> EitherT<F, L, R> lift(Monad<F> monad, Either<L, R> either) {
        return EitherT.of(monad, monad.pure(either));
    }

    public static <F extends Kind<F, ?>, L, R> EitherT<F, L, R> of(final Monad<F> monad, final Kind<F, Either<L, R>> value) {
        Precondition.checkNonNull(monad);
        Precondition.checkNonNull(value);
        return new EitherT<F, L, R>(){

            @Override
            public Monad<F> monad() {
                return monad;
            }

            @Override
            public Kind<F, Either<L, R>> value() {
                return value;
            }
        };
    }

    public static <F extends Kind<F, ?>, L, R> EitherT<F, L, R> right(Monad<F> monad, R right) {
        return EitherT.lift(monad, Either.right(right));
    }

    public static <F extends Kind<F, ?>, L, R> EitherT<F, L, R> left(Monad<F> monad, L left) {
        return EitherT.lift(monad, Either.left(left));
    }

    public static <F extends Kind<F, ?>, R> EitherT<F, Throwable, R> fromOption(Monad<F> monad, Option<R> value) {
        return EitherT.lift(monad, value.toEither());
    }

    public static <F extends Kind<F, ?>, R> EitherT<F, Throwable, R> fromTry(Monad<F> monad, Try<R> value) {
        return EitherT.lift(monad, value.toEither());
    }

    default public <V> Kind<F, Either<L, V>> flatMapF(Function1<? super R, ? extends Kind<F, ? extends Either<L, V>>> map) {
        return this.monad().flatMap(this.value(), v -> (Kind)v.fold(left -> this.monad().pure((Object)Either.left((Object)left)), map));
    }
}

