/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.transformer;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.transformer.KleisliOf;
import com.github.tonivade.purefun.typeclasses.Monad;

@HigherKind
public interface Kleisli<F extends Kind<F, ?>, Z, A>
extends KleisliOf<F, Z, A>,
Bindable<Kleisli<F, Z, ?>, A> {
    public Monad<F> monad();

    public Kind<F, A> run(Z var1);

    default public <R> Kleisli<F, Z, R> map(Function1<? super A, ? extends R> map) {
        return Kleisli.of(this.monad(), value -> this.monad().map(this.run(value), map));
    }

    default public <R> Kleisli<F, Z, R> flatMap(Function1<? super A, ? extends Kind<Kleisli<F, Z, ?>, ? extends R>> map) {
        return Kleisli.of(this.monad(), value -> this.monad().flatMap(this.run(value), a -> ((Kleisli)map.andThen(KleisliOf::toKleisli).apply(a)).run(value)));
    }

    default public <R> Kleisli<F, Z, R> andThen(Kind<Kleisli<F, Z, ?>, ? extends R> next) {
        return this.flatMap(ignore -> next);
    }

    default public <B> Kleisli<F, Z, B> compose(Kleisli<F, A, B> other) {
        return Kleisli.of(this.monad(), value -> this.monad().flatMap(this.run(value), other::run));
    }

    default public <X> Kleisli<F, X, A> local(Function1<? super X, ? extends Z> map) {
        return Kleisli.of(this.monad(), map.andThen(this::run));
    }

    public static <F extends Kind<F, ?>, A, B> Kleisli<F, A, B> lift(Monad<F> monad, Function1<? super A, ? extends B> map) {
        return Kleisli.of(monad, map.andThen(arg_0 -> monad.pure(arg_0)));
    }

    public static <F extends Kind<F, ?>, Z> Kleisli<F, Z, Z> env(Monad<F> monad) {
        return Kleisli.of(monad, arg_0 -> monad.pure(arg_0));
    }

    public static <F extends Kind<F, ?>, A, B> Kleisli<F, A, B> pure(Monad<F> monad, B value) {
        return Kleisli.of(monad, a -> monad.pure(value));
    }

    public static <F extends Kind<F, ?>, A, B> Kleisli<F, A, B> of(final Monad<F> monad, final Function1<? super A, ? extends Kind<F, ? extends B>> run) {
        Precondition.checkNonNull(monad);
        Precondition.checkNonNull(run);
        return new Kleisli<F, A, B>(){

            @Override
            public Monad<F> monad() {
                return monad;
            }

            @Override
            public Kind<F, B> run(A value) {
                return (Kind)run.andThen(Kind::narrowK).apply(value);
            }
        };
    }
}

