/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.transformer;

import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Bindable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.transformer.WriterTOf;
import com.github.tonivade.purefun.typeclasses.FunctionK;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.purefun.typeclasses.Monoid;

@HigherKind
public interface WriterT<F extends Kind<F, ?>, L, A>
extends WriterTOf<F, L, A>,
Bindable<WriterT<F, L, ?>, A> {
    public Monoid<L> monoid();

    public Monad<F> monad();

    public Kind<F, Tuple2<L, A>> value();

    default public Kind<F, A> getValue() {
        return this.monad().map(this.value(), Tuple2::get2);
    }

    default public Kind<F, L> getLog() {
        return this.monad().map(this.value(), Tuple2::get1);
    }

    default public <R> WriterT<F, L, R> map(Function1<? super A, ? extends R> mapper) {
        return this.bimap(this.monoid(), Function1.identity(), mapper);
    }

    default public <V> WriterT<F, V, A> mapLog(Monoid<V> monoidV, Function1<? super L, ? extends V> mapper) {
        return this.bimap(monoidV, mapper, Function1.identity());
    }

    default public WriterT<F, L, Tuple2<L, A>> listen() {
        return WriterT.writer(this.monoid(), this.monad(), this.monad().map(this.value(), tuple -> Tuple.of((Object)tuple.get1(), (Object)Tuple.of((Object)tuple.get1(), (Object)tuple.get2()))));
    }

    default public WriterT<F, L, A> append(L log2) {
        return this.mapLog(this.monoid(), log1 -> this.monoid().combine(log1, log2));
    }

    default public WriterT<F, L, A> reset() {
        return this.bimap(this.monoid(), Function1.cons((Object)this.monoid().zero()), Function1.identity());
    }

    default public <V, R> WriterT<F, V, R> bimap(Monoid<V> monoidV, Function1<? super L, ? extends V> mapper1, Function1<? super A, ? extends R> mapper2) {
        return WriterT.writer(monoidV, this.monad(), this.monad().map(this.value(), tuple -> tuple.map(mapper1, mapper2)));
    }

    default public <G extends Kind<G, ?>> WriterT<G, L, A> mapK(Monad<G> monadG, FunctionK<F, G> functionK) {
        return WriterT.writer(this.monoid(), monadG, functionK.apply(this.value()));
    }

    default public <R> WriterT<F, L, R> flatMap(Function1<? super A, ? extends Kind<WriterT<F, L, ?>, ? extends R>> mapper) {
        return WriterT.writer(this.monoid(), this.monad(), this.monad().flatMap(this.value(), current -> this.monad().map(((WriterT)mapper.andThen(WriterTOf::toWriterT).apply(current.get2())).value(), other -> Tuple.of((Object)this.monoid().combine(current.get1(), other.get1()), (Object)other.get2()))));
    }

    default public <R> WriterT<F, L, R> andThen(Kind<WriterT<F, L, ?>, ? extends R> next) {
        return this.flatMap(ignore -> next);
    }

    public static <F extends Kind<F, ?>, L, A> WriterT<F, L, A> pure(Monoid<L> monoid, Monad<F> monad, A value) {
        return WriterT.lift(monoid, monad, Tuple2.of((Object)monoid.zero(), value));
    }

    public static <F extends Kind<F, ?>, L, A> WriterT<F, L, A> lift(Monoid<L> monoid, Monad<F> monad, Tuple2<L, A> value) {
        return WriterT.writer(monoid, monad, monad.pure(value));
    }

    public static <F extends Kind<F, ?>, L, A> WriterT<F, L, A> writer(final Monoid<L> monoid, final Monad<F> monad, final Kind<F, Tuple2<L, A>> value) {
        Precondition.checkNonNull(monoid);
        Precondition.checkNonNull(monad);
        Precondition.checkNonNull(value);
        return new WriterT<F, L, A>(){

            @Override
            public Monoid<L> monoid() {
                return monoid;
            }

            @Override
            public Monad<F> monad() {
                return monad;
            }

            @Override
            public Kind<F, Tuple2<L, A>> value() {
                return value;
            }
        };
    }
}

