/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Recoverable;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;

@FunctionalInterface
public interface CheckedFunction1<T, R>
extends Recoverable {
    public R apply(T var1) throws Exception;

    default public <V> CheckedFunction1<T, V> andThen(CheckedFunction1<R, V> after) {
        return value -> after.apply(this.apply(value));
    }

    default public <V> CheckedFunction1<V, R> compose(CheckedFunction1<V, T> before) {
        return value -> this.apply(before.apply(value));
    }

    default public Function1<T, R> recover(Function1<Throwable, R> mapper) {
        return value -> {
            try {
                return this.apply(value);
            }
            catch (Exception e) {
                return mapper.apply(e);
            }
        };
    }

    default public Function1<T, Option<R>> liftOption() {
        return this.liftTry().andThen(Try::toOption);
    }

    default public Function1<T, Either<Throwable, R>> liftEither() {
        return this.liftTry().andThen(Try::toEither);
    }

    default public Function1<T, Try<R>> liftTry() {
        return value -> Try.of(() -> this.apply(value));
    }

    default public Function1<T, R> unchecked() {
        return this.recover(this::sneakyThrow);
    }

    public static <T> CheckedFunction1<T, T> identity() {
        return value -> value;
    }

    public static <T, X extends Exception> CheckedFunction1<T, T> failure(Producer<X> supplier) {
        return value -> {
            throw (Exception)supplier.get();
        };
    }

    public static <T, R> CheckedFunction1<T, R> of(CheckedFunction1<T, R> reference) {
        return reference;
    }
}

